/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.qald;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.load.Dataset;
import org.aksw.qa.commons.load.LoaderController;
import org.aksw.qa.commons.load.json.EJDataset;
import org.aksw.qa.commons.load.json.EJQuestionFactory;
import org.aksw.qa.commons.load.json.ExtendedQALDJSONLoader;
import org.aksw.qa.commons.load.json.QaldJson;
import org.aksw.qa.commons.qald.IQuestionCsvParser;
import org.aksw.qa.commons.sparql.AnswerSyncer;
import org.aksw.qa.commons.sparql.SPARQL;
import org.aksw.qa.commons.sparql.SPARQLPrefixResolver;

public class Qald8Creation {
    public static void main(String[] args) throws Exception {
        Qald8Creation.qald8test();
        Qald8Creation.qald8train();
    }

    public static void qald8train() throws Exception {
        List<IQuestion> questions = LoaderController.load(Dataset.QALD7_Train_Multilingual);
        List<IQuestion> questions7test = LoaderController.load(Dataset.QALD7_Test_Multilingual);
        for (IQuestion q : questions7test) {
            q.setId(Integer.parseInt(q.getId()) + 300 + "");
        }
        questions.addAll(questions7test);
        Vector<IQuestion> failQuestions = new Vector<IQuestion>();
        List<String> skipId = Arrays.asList("15", "30", "43", "57", "62", "90", "94", "124", "199", "213");
        Vector<IQuestion> removeQuestions = new Vector<IQuestion>();
        for (IQuestion iQuestion : questions) {
            if (!skipId.contains(iQuestion.getId())) continue;
            removeQuestions.add(iQuestion);
        }
        questions.removeAll(removeQuestions);
        failQuestions.addAll(removeQuestions);
        removeQuestions.clear();
        for (IQuestion iQuestion : questions) {
            String oldQuery = iQuestion.getSparqlQuery();
            String newSparql = SPARQLPrefixResolver.addMissingPrefixes(iQuestion.getSparqlQuery());
            iQuestion.setSparqlQuery(newSparql);
        }
        for (IQuestion iQuestion : questions) {
            if (SPARQL.isValidSparqlQuery(iQuestion.getSparqlQuery())) continue;
            removeQuestions.add(iQuestion);
        }
        questions.removeAll(removeQuestions);
        failQuestions.addAll(removeQuestions);
        removeQuestions.clear();
        for (IQuestion iQuestion : questions) {
            try {
                AnswerSyncer.syncAnswers(iQuestion, "http://dbpedia.org/sparql");
            }
            catch (Exception e) {
                removeQuestions.add(iQuestion);
            }
        }
        questions.removeAll(removeQuestions);
        failQuestions.addAll(removeQuestions);
        removeQuestions.clear();
        for (IQuestion iQuestion : questions) {
            if (!iQuestion.getGoldenAnswers().isEmpty()) continue;
            removeQuestions.add(iQuestion);
        }
        questions.removeAll(removeQuestions);
        failQuestions.addAll(removeQuestions);
        removeQuestions.clear();
        int newID = 1;
        for (IQuestion q : questions) {
            q.setId("" + newID++);
        }
        File file = new File("c:/output/qald8/");
        File qaldjsonFile = new File(file, "qald-8-train-multilingual.json ");
        qaldjsonFile.delete();
        QaldJson qaldJson = EJQuestionFactory.getQaldJson(questions);
        EJDataset header = new EJDataset();
        header.setId("qald-8-train-multilingual");
        qaldJson.setDataset(header);
        ExtendedQALDJSONLoader.writeJson(qaldJson, qaldjsonFile, true);
        File f = new File(file, "qald8trainGOOD_QUESTIONS.csv ");
        f.delete();
        FileWriter fw = new FileWriter(f);
        CSVWriter wr = new CSVWriter((Writer)fw, ';', '\"');
        IQuestionCsvParser.questionListToCsv(wr, true, questions, IQuestionCsvParser.Column.ID(), IQuestionCsvParser.Column.question("en"), IQuestionCsvParser.Column.sparqlQuery(), IQuestionCsvParser.Column.goldenAnswers());
        wr.flush();
        fw.close();
        File f2 = new File(file, "qald8trainBAD_QUESTIONS.csv ");
        f2.delete();
        FileWriter fw2 = new FileWriter(f2);
        CSVWriter wr2 = new CSVWriter((Writer)fw2, ';', '\"');
        IQuestionCsvParser.questionListToCsv(wr2, true, failQuestions, IQuestionCsvParser.Column.ID(), IQuestionCsvParser.Column.question("en"), IQuestionCsvParser.Column.sparqlQuery(), IQuestionCsvParser.Column.goldenAnswers());
        wr2.flush();
        fw2.close();
        System.out.println("done qald8train");
    }

    public static void qald8test() throws Exception {
        FileReader rd = new FileReader(new File("c:/output/QALD8testtask1.csv"));
        File parentDir = new File("c:/output/qald8/");
        CSVReader csvReader = IQuestionCsvParser.readerForGoogleDocsCsvExports(rd, 1);
        List<IQuestion> que = IQuestionCsvParser.csvToQuestionList(csvReader, IQuestionCsvParser.Column.question("en"), IQuestionCsvParser.Column.sparqlQuery(), IQuestionCsvParser.Column.ignore(), IQuestionCsvParser.Column.answerType(), IQuestionCsvParser.Column.aggregationFlag(), IQuestionCsvParser.Column.onlyDboFlag(), IQuestionCsvParser.Column.hybridFlag(), IQuestionCsvParser.Column.keywords("en"));
        IQuestion removeMe = null;
        for (IQuestion iQuestion : que) {
            if (!iQuestion.getLanguageToQuestion().get("en").equals("How old was Shockley when he died?")) continue;
            removeMe = iQuestion;
        }
        que.remove(removeMe);
        for (IQuestion iQuestion : que) {
            String newSparql = SPARQLPrefixResolver.addMissingPrefixes(iQuestion.getSparqlQuery());
            iQuestion.setSparqlQuery(newSparql);
            if (SPARQL.isValidSparqlQuery(newSparql)) continue;
            throw new Exception("Sparql not valid " + iQuestion.getLanguageToQuestion().get("en"));
        }
        AnswerSyncer.syncAnswers(que, "http://dbpedia.org/sparql");
        int id = 1;
        for (IQuestion q : que) {
            if (q.getGoldenAnswers().isEmpty()) {
                throw new Exception("Answerset empty");
            }
            q.setId("" + id++);
        }
        QaldJson qaldJson = EJQuestionFactory.getQaldJson(que);
        EJDataset header = new EJDataset();
        header.setId("qald-8-test-multilingual");
        qaldJson.setDataset(header);
        ExtendedQALDJSONLoader.writeJson(qaldJson, new File(parentDir, "qald-8-test-multilingual.json"), true);
        File f2 = new File(parentDir, "qald8testGOOD_QUESTIONS.csv");
        f2.delete();
        FileWriter fw2 = new FileWriter(f2);
        CSVWriter wr2 = new CSVWriter((Writer)fw2, ';', '\"');
        IQuestionCsvParser.questionListToCsv(wr2, true, que, IQuestionCsvParser.Column.ID(), IQuestionCsvParser.Column.question("en"), IQuestionCsvParser.Column.sparqlQuery(), IQuestionCsvParser.Column.goldenAnswers());
        wr2.close();
        fw2.close();
        System.out.println("qald8test done");
    }
}

