/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.load;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.datastructure.Question;
import org.aksw.qa.commons.load.Dataset;
import org.aksw.qa.commons.load.json.EJQuestionFactory;
import org.aksw.qa.commons.load.json.ExtendedQALDJSONLoader;
import org.aksw.qa.commons.load.json.QaldJson;
import org.aksw.qa.commons.load.stanford.StanfordLoader;
import org.aksw.qa.commons.utils.DateFormatter;
import org.aksw.qa.commons.utils.SPARQLExecutor;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LoaderController {
    static Logger log = LoggerFactory.getLogger(LoaderController.class);

    private static InputStream getInputStream(Dataset set) {
        try {
            InputStream url = LoaderController.mapDatasetToPath(set);
            return url;
        }
        catch (NullPointerException e) {
            log.error("No Mapping for this Dataset " + set.toString(), (Throwable)e);
            return null;
        }
    }

    public static Class<?> getLoadingAnchor() {
        Class<?> loadingAnchor = null;
        try {
            loadingAnchor = Class.forName("org.aksw.qa.datasets.ResourceLoadingAnchor");
        }
        catch (ClassNotFoundException e) {
            log.error("Couldn't find the org.aksw.qa.datasets.ResourceLoadingAnchor class necessary to load the datasets. Returning null.", (Throwable)e);
            return null;
        }
        return loadingAnchor;
    }

    public static InputStream mapDatasetToPath(Dataset set) {
        Class<?> loadingAnchor = LoaderController.getLoadingAnchor();
        switch (set) {
            case nlq: {
                return loadingAnchor.getResourceAsStream("/NLQ-OKBQA/nlq1_vis.json");
            }
            case QALD1_Test_dbpedia: {
                return loadingAnchor.getResourceAsStream("/QALD-master/1/data/dbpedia-test.xml");
            }
            case QALD1_Test_musicbrainz: {
                return loadingAnchor.getResourceAsStream("/QALD-master/1/data/musicbrainz-test.xml");
            }
            case QALD1_Train_dbpedia: {
                return loadingAnchor.getResourceAsStream("/QALD-master/1/data/dbpedia-train.xml");
            }
            case QALD1_Train_musicbrainz: {
                return loadingAnchor.getResourceAsStream("/QALD-master/1/data/musicbrainz-train.xml");
            }
            case QALD2_Test_dbpedia: {
                return loadingAnchor.getResourceAsStream("/QALD-master/2/data/dbpedia-test.xml");
            }
            case QALD2_Test_musicbrainz: {
                return loadingAnchor.getResourceAsStream("/QALD-master/2/data/musicbrainz-test.xml");
            }
            case QALD2_Train_dbpedia: {
                return loadingAnchor.getResourceAsStream("/QALD-master/2/data/dbpedia-train-answers.xml");
            }
            case QALD2_Train_musicbrainz: {
                return loadingAnchor.getResourceAsStream("/QALD-master/2/data/musicbrainz-train-answers.xml");
            }
            case QALD2_Participants_Challenge: {
                return loadingAnchor.getResourceAsStream("/QALD-master/2/data/participants-challenge-answers.xml");
            }
            case QALD3_Test_dbpedia: {
                return loadingAnchor.getResourceAsStream("/QALD-master/3/data/dbpedia-test-answers.xml");
            }
            case QALD3_Test_esdbpedia: {
                return loadingAnchor.getResourceAsStream("/QALD-master/3/data/esdbpedia-test-answers.xml");
            }
            case QALD3_Test_musicbrainz: {
                return loadingAnchor.getResourceAsStream("/QALD-master/3/data/musicbrainz-test-answers.xml");
            }
            case QALD3_Train_dbpedia: {
                return loadingAnchor.getResourceAsStream("/QALD-master/3/data/dbpedia-train-answers.xml");
            }
            case QALD3_Train_esdbpedia: {
                return loadingAnchor.getResourceAsStream("/QALD-master/3/data/esdbpedia-train-answers.xml");
            }
            case QALD3_Train_musicbrainz: {
                return loadingAnchor.getResourceAsStream("/QALD-master/3/data/musicbrainz-train-answers.xml");
            }
            case QALD4_Test_Hybrid: {
                return loadingAnchor.getResourceAsStream("/QALD-master/4/data/qald-4_hybrid_test_withanswers.xml");
            }
            case QALD4_Test_Multilingual: {
                return loadingAnchor.getResourceAsStream("/QALD-master/4/data/qald-4_multilingual_test_withanswers.xml");
            }
            case QALD4_Test_biomedical: {
                return loadingAnchor.getResourceAsStream("/QALD-master/4/data/qald-4_biomedical_test_withanswers.xml");
            }
            case QALD4_Train_Hybrid: {
                return loadingAnchor.getResourceAsStream("/QALD-master/4/data/qald-4_hybrid_train.xml");
            }
            case QALD4_Train_Multilingual: {
                return loadingAnchor.getResourceAsStream("/QALD-master/4/data/qald-4_multilingual_train_withanswers.xml");
            }
            case QALD4_Train_biomedical: {
                return loadingAnchor.getResourceAsStream("/QALD-master/4/data/qald-4_biomedical_train_withanswers.xml");
            }
            case QALD5_Test_Hybrid: 
            case QALD5_Test_Multilingual: {
                return loadingAnchor.getResourceAsStream("/QALD-master/5/data/qald-5_test.xml");
            }
            case QALD5_Train_Hybrid: 
            case QALD5_Train_Multilingual: {
                return loadingAnchor.getResourceAsStream("/QALD-master/5/data/qald-5_train.xml");
            }
            case QALD6_Train_Hybrid: {
                return loadingAnchor.getResourceAsStream("/QALD-master/6/data/qald-6-train-hybrid.json");
            }
            case QALD6_Train_Multilingual: {
                return loadingAnchor.getResourceAsStream("/QALD-master/6/data/qald-6-train-multilingual.json");
            }
            case QALD6_Test_Hybrid: {
                return loadingAnchor.getResourceAsStream("/QALD-master/6/data/qald-6-test-hybrid.json");
            }
            case QALD6_Test_Multilingual: {
                return loadingAnchor.getResourceAsStream("/QALD-master/6/data/qald-6-test-multilingual.json");
            }
            case QALD7_Train_Hybrid: {
                return loadingAnchor.getResourceAsStream("/QALD-master/7/data/qald-7-train-hybrid.json");
            }
            case QALD7_Train_Multilingual: {
                return loadingAnchor.getResourceAsStream("/QALD-master/7/data/qald-7-train-multilingual.json");
            }
            case QALD7_Train_Wikidata_en: {
                return loadingAnchor.getResourceAsStream("/QALD-master/7/data/qald-7-train-en-wikidata.json");
            }
            case QALD7_Test_Multilingual: {
                return loadingAnchor.getResourceAsStream("/QALD-master/7/data/qald-7-test-multilingual.json");
            }
            case QALD7_Test_Wikidata_en: {
                return loadingAnchor.getResourceAsStream("/QALD-master/7/data/qald-7-test-en-wikidata.json");
            }
            case Stanford_dev: {
                return loadingAnchor.getResourceAsStream("/stanfordqa-dev.json");
            }
            case Stanford_train: {
                return loadingAnchor.getResourceAsStream("/stanfordqa-train.json");
            }
            case QALD8_Test_Multilingual: {
                return loadingAnchor.getResourceAsStream("/QALD-master/8/data/qald-8-test-multilingual.json");
            }
            case QALD8_Train_Multilingual: {
                return loadingAnchor.getResourceAsStream("/QALD-master/8/data/qald-8-train-multilingual.json");
            }
            case LCQUAD: {
                return loadingAnchor.getResourceAsStream("/lcquad_qaldformat.json");
            }
        }
        return null;
    }

    public static List<IQuestion> load(Dataset data) {
        return LoaderController.load(data, null, "en");
    }

    @Deprecated
    public static List<IQuestion> load(Dataset data, String deriveUri, String questionLang) {
        try {
            InputStream is = null;
            is = LoaderController.getInputStream(data);
            if (is == null) {
                log.error("Couldn't load dataset " + data.name() + ". Returning null.");
                return null;
            }
            List<IQuestion> out = null;
            if (is.available() > 0) {
                switch (data) {
                    case QALD1_Test_dbpedia: 
                    case QALD1_Test_musicbrainz: 
                    case QALD1_Train_dbpedia: 
                    case QALD1_Train_musicbrainz: 
                    case QALD2_Test_dbpedia: 
                    case QALD2_Test_musicbrainz: 
                    case QALD2_Train_dbpedia: 
                    case QALD2_Train_musicbrainz: 
                    case QALD2_Participants_Challenge: 
                    case QALD3_Test_dbpedia: 
                    case QALD3_Test_musicbrainz: 
                    case QALD3_Train_dbpedia: 
                    case QALD3_Train_esdbpedia: 
                    case QALD3_Train_musicbrainz: 
                    case QALD4_Test_Hybrid: 
                    case QALD4_Test_Multilingual: 
                    case QALD4_Test_biomedical: 
                    case QALD4_Train_Hybrid: 
                    case QALD4_Train_Multilingual: 
                    case QALD4_Train_biomedical: {
                        out = LoaderController.loadXML(is, deriveUri, questionLang);
                        break;
                    }
                    case QALD3_Test_esdbpedia: {
                        is.close();
                        out = LoaderController.qald3_test_esdbpedia_loader(deriveUri, questionLang);
                        break;
                    }
                    case QALD5_Test_Hybrid: 
                    case QALD5_Train_Hybrid: {
                        ArrayList<IQuestion> hybrid = new ArrayList<IQuestion>();
                        List<IQuestion> loadedQ = LoaderController.loadXML(is, deriveUri, questionLang);
                        for (IQuestion q : loadedQ) {
                            if (!q.getHybrid().booleanValue()) continue;
                            hybrid.add(q);
                        }
                        out = hybrid;
                        break;
                    }
                    case QALD5_Test_Multilingual: 
                    case QALD5_Train_Multilingual: {
                        ArrayList<IQuestion> hybrid = new ArrayList<IQuestion>();
                        List<IQuestion> loadedQ = LoaderController.loadXML(is, deriveUri, questionLang);
                        for (IQuestion q : loadedQ) {
                            if (q.getHybrid().booleanValue()) continue;
                            hybrid.add(q);
                        }
                        out = hybrid;
                        break;
                    }
                    case QALD6_Train_Hybrid: 
                    case QALD6_Train_Multilingual: 
                    case QALD6_Test_Hybrid: 
                    case QALD6_Test_Multilingual: 
                    case QALD7_Train_Hybrid: 
                    case QALD7_Train_Multilingual: 
                    case QALD7_Train_Wikidata_en: 
                    case QALD7_Test_Multilingual: 
                    case QALD7_Test_Wikidata_en: 
                    case QALD8_Test_Multilingual: 
                    case QALD8_Train_Multilingual: 
                    case LCQUAD: {
                        QaldJson json = (QaldJson)ExtendedQALDJSONLoader.readJson(LoaderController.getInputStream(data), QaldJson.class);
                        out = EJQuestionFactory.getQuestionsFromQaldJson(json);
                        for (IQuestion q : out) {
                            HashSet<String> set = new HashSet<String>();
                            if (deriveUri == null || q.getSparqlQuery() == null) continue;
                            Set<RDFNode> answers = SPARQLExecutor.sparql(deriveUri, q.getSparqlQuery());
                            for (RDFNode answ : answers) {
                                if (answ.isResource()) {
                                    set.add(answ.asResource().getURI());
                                    continue;
                                }
                                if (answ.isLiteral()) {
                                    set.add(((Literal)answ).getValue().toString());
                                    continue;
                                }
                                set.add(answ.toString());
                            }
                            q.setGoldenAnswers(set);
                        }
                        break;
                    }
                    case nlq: {
                        out = LoaderController.loadNLQ(is, deriveUri);
                        break;
                    }
                    case Stanford_dev: 
                    case Stanford_train: {
                        out = StanfordLoader.load(is);
                    }
                }
                is.close();
                return out;
            }
            is.close();
            throw new IOException("InputStream is null");
        }
        catch (IOException e) {
            log.info("Couldnt load dataset ", (Throwable)e);
            return null;
        }
    }

    @Deprecated
    private static List<IQuestion> qald3_test_esdbpedia_loader(String deriveUri, String questionLang) {
        List<IQuestion> answerList = null;
        try {
            InputStream sparqlIs = null;
            InputStream answerIs = null;
            sparqlIs = LoaderController.getLoadingAnchor().getResourceAsStream("/QALD-master/3/data/esdbpedia-test.xml");
            answerIs = LoaderController.getInputStream(Dataset.QALD3_Test_esdbpedia);
            if (sparqlIs == null || answerIs == null) {
                log.error("Couldn't load dataset /QALD-master/3/data/esdbpedia-test.xml and  " + Dataset.QALD3_Test_esdbpedia.toString() + ". Returning null.");
                return null;
            }
            if (sparqlIs.available() > 0 && answerIs.available() > 0) {
                answerList = LoaderController.loadXML(answerIs, deriveUri, questionLang);
                List<IQuestion> sparqlList = LoaderController.loadXML(sparqlIs, deriveUri, questionLang);
                for (IQuestion q : answerList) {
                    for (IQuestion sparqlQ : sparqlList) {
                        if (!q.getId().equals(sparqlQ.getId())) continue;
                        q.setSparqlQuery(sparqlQ.getSparqlQuery());
                    }
                }
            }
        }
        catch (IOException e) {
            log.info("Couldnt load datasets ", (Throwable)e);
        }
        return answerList;
    }

    public static List<IQuestion> loadXML(InputStream file, String questionLang) {
        return LoaderController.loadXML(file, null, questionLang);
    }

    @Deprecated
    public static List<IQuestion> loadXML(InputStream file, String deriveUri, String questionLang) {
        ArrayList<IQuestion> questions = new ArrayList<IQuestion>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            NodeList questionNodes = doc.getElementsByTagName("question");
            for (int i = 0; i < questionNodes.getLength(); ++i) {
                Object answers;
                Node item;
                NodeList childNodes;
                Question question = new Question();
                Element questionNode = (Element)questionNodes.item(i);
                question.setId(questionNode.getAttribute("id"));
                question.setAnswerType(questionNode.getAttribute("answertype"));
                question.setAggregation(Boolean.valueOf(questionNode.getAttribute("aggregation")));
                question.setOnlydbo(Boolean.valueOf(questionNode.getAttribute("onlydbo")));
                question.setHybrid(Boolean.valueOf(questionNode.getAttribute("hybrid")));
                NodeList nlrs = questionNode.getElementsByTagName("string");
                for (int j = 0; j < nlrs.getLength(); ++j) {
                    String lang = ((Element)nlrs.item(j)).getAttribute("lang");
                    if (Strings.isNullOrEmpty((String)lang)) {
                        question.getLanguageToQuestion().put(questionLang, ((Element)nlrs.item(j)).getTextContent().trim());
                        break;
                    }
                    question.getLanguageToQuestion().put(lang, ((Element)nlrs.item(j)).getTextContent().trim());
                }
                NodeList keywords = questionNode.getElementsByTagName("keywords");
                for (int j = 0; j < keywords.getLength(); ++j) {
                    String lang = ((Element)keywords.item(j)).getAttribute("lang");
                    question.getLanguageToKeywords().put(lang, Arrays.asList(((Element)keywords.item(j)).getTextContent().trim().split(", ")));
                }
                Element element = (Element)questionNode.getElementsByTagName("pseudoquery").item(0);
                if (element != null && element.hasChildNodes()) {
                    childNodes = element.getChildNodes();
                    item = childNodes.item(0);
                    question.setPseudoSparqlQuery(item.getNodeValue().trim());
                }
                if ((element = (Element)questionNode.getElementsByTagName("query").item(0)) != null && element.hasChildNodes()) {
                    childNodes = element.getChildNodes();
                    item = childNodes.item(0);
                    question.setSparqlQuery(item.getNodeValue().trim());
                    try {
                        QueryFactory.create((String)question.getSparqlQuery());
                    }
                    catch (Exception e) {
                        log.error("Couldn't parse a query - Skipping question", (Throwable)e);
                        continue;
                    }
                }
                if (question.getPseudoSparqlQuery() != null) {
                    question.setOutOfScope(question.getPseudoSparqlQuery().toUpperCase().contains("OUT OF SCOPE"));
                }
                if (question.getSparqlQuery() != null) {
                    question.setOutOfScope(question.getSparqlQuery().toUpperCase().contains("OUT OF SCOPE"));
                }
                HashSet<String> set = new HashSet<String>();
                if (deriveUri != null && question.getSparqlQuery() != null) {
                    answers = SPARQLExecutor.sparql(deriveUri, question.getSparqlQuery());
                    Iterator e = answers.iterator();
                    while (e.hasNext()) {
                        RDFNode answ = (RDFNode)e.next();
                        if (answ.isResource()) {
                            set.add(answ.asResource().getURI());
                            continue;
                        }
                        if (answ.isLiteral()) {
                            set.add(((Literal)answ).getValue().toString());
                            continue;
                        }
                        set.add(answ.toString());
                    }
                } else {
                    answers = questionNode.getElementsByTagName("answers");
                    for (int j = 0; j < answers.getLength(); ++j) {
                        NodeList answer = ((Element)answers.item(j)).getElementsByTagName("answer");
                        block20: for (int k = 0; k < answer.getLength(); ++k) {
                            switch (question.getAnswerType().toLowerCase()) {
                                case "boolean": {
                                    Boolean b = Boolean.valueOf(((Element)answer.item(k)).getTextContent().toLowerCase().trim());
                                    set.add(b.toString().trim());
                                    continue block20;
                                }
                                case "date": {
                                    set.add(DateFormatter.formatDate(((Element)answer.item(k)).getTextContent()).trim());
                                    continue block20;
                                }
                                default: {
                                    String answerString = ((Element)answer.item(k)).getTextContent();
                                    String x = Arrays.asList(answerString.trim().split("\n")).get(0);
                                    set.add(x);
                                }
                            }
                        }
                    }
                }
                question.setGoldenAnswers(set);
                questions.add(question);
            }
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return questions;
    }

    public static List<IQuestion> loadNLQ(InputStream file) {
        return LoaderController.loadNLQ(file, null);
    }

    public static List<IQuestion> loadNLQ(InputStream file, String deriveUri) {
        ArrayList<IQuestion> output = new ArrayList<IQuestion>();
        HashMap idToQuestion = new HashMap();
        try {
            if (file.available() > 0) {
                JsonReader jsonReader = Json.createReader((InputStream)file);
                JsonArray mainJsonArray = jsonReader.readArray();
                for (Object currentJsonValue : mainJsonArray) {
                    JsonObject currentObject = (JsonObject)currentJsonValue;
                    try {
                        Integer id = Integer.parseInt(currentObject.getString("id"));
                        if (idToQuestion.containsKey(id)) {
                            ((ArrayList)idToQuestion.get(id)).add(currentObject);
                            continue;
                        }
                        ArrayList<JsonObject> jArray = new ArrayList<JsonObject>();
                        jArray.add(currentObject);
                        idToQuestion.put(id, jArray);
                    }
                    catch (NumberFormatException e) {
                        log.debug("Couldn't load question \"" + ((JsonObject)currentJsonValue).getString("question") + "\" from dataset due to wrong or missing question ID", (Throwable)e);
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("Could not load Dataset", (Throwable)e);
        }
        for (Integer i : idToQuestion.keySet()) {
            Question q = new Question();
            for (JsonObject currentJsonObject : (ArrayList)idToQuestion.get(i)) {
                q.setValue("id", currentJsonObject.getString("id"));
                String lang = currentJsonObject.getString("lang");
                String questiion = currentJsonObject.getString("question");
                String answer = currentJsonObject.getString("answer");
                String sparql = currentJsonObject.getString("sparql");
                q.getLanguageToQuestion().put(lang, questiion);
                q.setSparqlQuery(lang, sparql);
                HashSet<String> answ = new HashSet<String>();
                if (deriveUri != null && q.getSparqlQuery() != null) {
                    Set<RDFNode> answers = SPARQLExecutor.sparql(deriveUri, q.getSparqlQuery());
                    for (RDFNode a : answers) {
                        if (a.isResource()) {
                            answ.add(a.asResource().getURI());
                            continue;
                        }
                        if (a.isLiteral()) {
                            answ.add(((Literal)answ).getValue().toString());
                            continue;
                        }
                        answ.add(((Object)answ).toString());
                    }
                } else {
                    answ.add(answer);
                }
                q.setGoldenAnswers(lang, answ);
            }
            try {
                QueryFactory.create((String)q.getSparqlQuery());
            }
            catch (Exception e) {
                continue;
            }
            output.add(q);
        }
        return output;
    }

    public static void main(String[] args) throws ParseException {
        ArrayList<String> output = new ArrayList<String>();
        ArrayList<String> output2 = new ArrayList<String>();
        for (Dataset data : Dataset.values()) {
            List<IQuestion> questions = LoaderController.load(data);
            if (questions == null) {
                System.out.println("Dataset null" + data.toString());
                continue;
            }
            if (questions.size() == 0) {
                System.out.println("Dataset empty" + data.toString());
                continue;
            }
            HashSet<IQuestion> noanswers = new HashSet<IQuestion>();
            HashSet<IQuestion> nosparql = new HashSet<IQuestion>();
            for (IQuestion q : questions) {
                if ((q.getSparqlQuery() == null || q.getSparqlQuery().isEmpty()) && (q.getPseudoSparqlQuery() == null || q.getPseudoSparqlQuery().isEmpty())) {
                    nosparql.add(q);
                }
                if (q.getGoldenAnswers() != null && !q.getGoldenAnswers().isEmpty()) continue;
                noanswers.add(q);
            }
            DecimalFormat df = new DecimalFormat("###.##");
            df.setRoundingMode(RoundingMode.CEILING);
            if (!noanswers.isEmpty()) {
                output.add(df.format((double)noanswers.size() / (double)questions.size() * 100.0) + "%" + " Missing answers on : " + data.toString() + ", " + noanswers.size() + " Question(s).");
            }
            if (!nosparql.isEmpty()) {
                output2.add(df.format((double)nosparql.size() / (double)questions.size() * 100.0) + "%" + " Neither Sparql nor Pseudo : " + data.toString() + ", " + nosparql.size() + " Question(s).");
            }
            System.out.println("Loaded successfully: " + data.toString());
        }
        System.out.println("\n\n");
        for (String s : output) {
            System.out.println(s);
        }
        System.out.println("\n\n");
        for (String s : output2) {
            System.out.println(s);
        }
    }
}

