/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.sparql;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.aksw.qa.commons.sparql.SPARQL;
import org.apache.jena.rdf.model.RDFNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedSPARQL {
    private SPARQL sparql;
    private int timeoutInSeconds = 10;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    ExecutorService executor = Executors.newFixedThreadPool(1);

    public ThreadedSPARQL() {
        this.sparql = new SPARQL();
    }

    public ThreadedSPARQL(int timeoutInSeconds, String endpoint) {
        this.sparql = endpoint == null || endpoint.isEmpty() ? new SPARQL() : new SPARQL(endpoint);
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public synchronized Set<RDFNode> sparql(String query) throws ExecutionException {
        Callable<Set> task = () -> {
            Date dateStart = new Date();
            Set<RDFNode> result = this.sparql.sparql(query);
            double executionTimeInS = ((double)new Date().getTime() - (double)dateStart.getTime()) / 1000.0;
            DecimalFormat df = new DecimalFormat("00.000");
            this.log.info("Sparql response time: " + df.format(executionTimeInS) + "s");
            return result;
        };
        Future<Set> future = this.executor.submit(task);
        Set result = null;
        try {
            result = future.get(this.timeoutInSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.log.error("Sparql thread interrupted, returned null. Query: \n" + query, (Throwable)e);
        }
        catch (TimeoutException e) {
            this.log.info("Query timed out after " + this.timeoutInSeconds + " s \n" + query, (Throwable)e);
        }
        future.cancel(true);
        return result;
    }

    public int getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public void setTimeoutInSeconds(int timeoutInSeconds) {
        if (timeoutInSeconds > 0) {
            this.timeoutInSeconds = timeoutInSeconds;
        }
    }

    public void destroy() {
        this.executor.shutdown();
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException {
        String query = "PREFIX dbo: <http://dbpedia.org/ontology/> PREFIX res: <http://dbpedia.org/resource/> PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> SELECT DISTINCT ?uri ?string WHERE {         ?uri rdf:type dbo:FormulaOneRacer . \t?uri dbo:races ?x .         OPTIONAL { ?uri rdfs:label ?string. FILTER (lang(?string) = 'en') } } ORDER BY DESC(?x) OFFSET 0 LIMIT 1";
        System.out.println(new ThreadedSPARQL(90, "http://dbpedia.org/sparql").sparql(query));
        System.out.println("system exit");
    }
}

