/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.load.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;
import org.aksw.qa.commons.load.json.EJHead;
import org.aksw.qa.commons.load.json.EJResults;

public class EJAnswers {
    private EJHead head;
    private EJResults results;
    private String confidence = "";
    private Boolean isTrue;

    @JsonCreator
    public static EJAnswers factory(String json) {
        try {
            return (EJAnswers)new ObjectMapper().readValue(json, EJAnswers.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "\n    Head: " + Objects.toString(this.head) + "\n    Results: " + Objects.toString(this.results) + "\n    Confidence: " + this.confidence + "\n    Boolean: " + this.isTrue;
    }

    public EJResults getResults() {
        if (this.results == null) {
            this.results = new EJResults();
        }
        return this.results;
    }

    public EJHead getHead() {
        if (this.head == null) {
            this.head = new EJHead();
        }
        return this.head;
    }

    public String getConfidence() {
        return this.confidence;
    }

    public Boolean getBoolean() {
        return this.isTrue;
    }

    public EJAnswers setHead(EJHead head) {
        this.head = head;
        return this;
    }

    public EJAnswers setConfidence(String confidence) {
        this.confidence = confidence;
        return this;
    }

    public EJAnswers setBoolean(Boolean isTrue) {
        this.isTrue = isTrue;
        return this;
    }

    public EJAnswers setResults(EJResults results) {
        this.results = results;
        return this;
    }
}

