/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.utils;

import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.aksw.qa.commons.qald.QALD4_EvaluationUtils;
import org.aksw.qa.commons.utils.Results;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SPARQLExecutor {
    public static boolean isEndpointAlive(String endpoint) {
        try {
            BufferedReader reader = SPARQLExecutor.getReader(endpoint);
            reader.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static Results executeSelect(String query, String endpoint) {
        try {
            BufferedReader reader = SPARQLExecutor.getReader(endpoint + "?query=" + URLEncoder.encode(query, "UTF-8"));
            String results = SPARQLExecutor.readAll(reader);
            reader.close();
            Results ret = SPARQLExecutor.processSelectResults(results);
            return ret;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Boolean executeAsk(String query, String endpoint) {
        try {
            BufferedReader reader = SPARQLExecutor.getReader(endpoint + "?query=" + URLEncoder.encode(query, "UTF-8"));
            String results = SPARQLExecutor.readAll(reader);
            reader.close();
            return Boolean.valueOf(results);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Results processSelectResults(String results) throws ParserConfigurationException, SAXException, IOException {
        InputSource is = new InputSource(new StringReader(results));
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(is);
        NodeList nodes = doc.getFirstChild().getChildNodes();
        Results res = new Results();
        for (int i = 0; i < nodes.getLength(); ++i) {
            NodeList childs = nodes.item(i).getChildNodes();
            LinkedList<String> row = new LinkedList<String>();
            for (int j = 0; j < childs.getLength(); ++j) {
                if (childs.item(j).getNodeName().equals("th")) {
                    res.header.add(childs.item(j).getTextContent());
                    continue;
                }
                String add = "";
                add = childs.item(j).hasChildNodes() ? childs.item(j).getFirstChild().getTextContent().trim() : childs.item(j).getTextContent().trim();
                if (add.isEmpty()) continue;
                row.add(add);
            }
            if (row.isEmpty()) continue;
            res.table.add(row);
        }
        return res;
    }

    private static String readAll(BufferedReader reader) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = reader.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    private static BufferedReader getReader(String endpoint) throws IOException {
        URL url = new URL(endpoint);
        InputStream stream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charset.forName("UTF-8")));
        return reader;
    }

    public static Set<RDFNode> sparql(String service, String query) {
        HashSet set = Sets.newHashSet();
        QueryExecution qe = QueryExecutionFactory.sparqlService((String)service, (String)query);
        if (qe != null && query.toString() != null) {
            if (QALD4_EvaluationUtils.isAskType(query)) {
                set.add(new ResourceImpl(String.valueOf(qe.execAsk())));
            } else {
                ResultSet results = qe.execSelect();
                String firstVarName = (String)results.getResultVars().get(0);
                while (results.hasNext()) {
                    RDFNode node = results.next().get(firstVarName);
                    if (node == null) continue;
                    set.add(node);
                }
            }
            qe.close();
        }
        return set;
    }
}

