/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.aksw.qa.commons.utils.Results;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SPARQLExecutor {
    public static boolean isEndpointAlive(String endpoint) {
        try {
            BufferedReader reader = SPARQLExecutor.getReader(endpoint);
            reader.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static Results executeSelect(String query, String endpoint) {
        try {
            BufferedReader reader = SPARQLExecutor.getReader(String.valueOf(endpoint) + "?query=" + URLEncoder.encode(query, "UTF-8"));
            String results = SPARQLExecutor.readAll(reader);
            reader.close();
            Results ret = SPARQLExecutor.processSelectResults(results);
            return ret;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Boolean executeAsk(String query, String endpoint) {
        try {
            BufferedReader reader = SPARQLExecutor.getReader(String.valueOf(endpoint) + "?query=" + URLEncoder.encode(query, "UTF-8"));
            String results = SPARQLExecutor.readAll(reader);
            reader.close();
            return Boolean.valueOf(results);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Results processSelectResults(String results) throws ParserConfigurationException, SAXException, IOException {
        InputSource is = new InputSource(new StringReader(results));
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.parse(is);
        NodeList nodes = doc.getFirstChild().getChildNodes();
        Results res = new Results();
        int i = 0;
        while (i < nodes.getLength()) {
            NodeList childs = nodes.item(i).getChildNodes();
            LinkedList<String> row = new LinkedList<String>();
            int j = 0;
            while (j < childs.getLength()) {
                if (childs.item(j).getNodeName().equals("th")) {
                    res.header.add(childs.item(j).getTextContent());
                } else {
                    String add = "";
                    add = childs.item(j).hasChildNodes() ? childs.item(j).getFirstChild().getTextContent().trim() : childs.item(j).getTextContent().trim();
                    if (!add.isEmpty()) {
                        row.add(add);
                    }
                }
                ++j;
            }
            if (!row.isEmpty()) {
                res.table.add(row);
            }
            ++i;
        }
        return res;
    }

    private static String readAll(BufferedReader reader) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = reader.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    private static BufferedReader getReader(String endpoint) throws IOException {
        URL url = new URL(endpoint);
        InputStream stream = url.openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charset.forName("UTF-8")));
        return reader;
    }
}

