/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.load;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.datastructure.Question;
import org.aksw.qa.commons.load.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class QALD_Loader {
    static Logger log = LoggerFactory.getLogger(QALD_Loader.class);

    private static InputStream getInputStream(Dataset set) {
        try {
            URL url = QALD_Loader.mapDatasetToPath(set);
            return url.openStream();
        }
        catch (IOException e) {
            log.error("Couldnt open stream to dataset", (Throwable)e);
        }
        catch (NullPointerException e) {
            log.error("No Mapping for this Dataset " + set.toString(), (Throwable)e);
        }
        return null;
    }

    private static URL mapDatasetToPath(Dataset set) {
        File f = new File("src/main/resources/");
        File g = new File(f.getAbsolutePath().replace("qa-commons", "qa-datasets"));
        File[] files = g.listFiles();
        String qaldDirName = "";
        int i = 0;
        while (i < files.length) {
            if (files[i].toString().contains("ag-sc-QALD")) {
                File qaldDir = files[i];
                qaldDirName = qaldDir.getAbsolutePath();
                qaldDirName = qaldDirName.substring(qaldDirName.indexOf("ag-sc-QALD"));
            }
            ++i;
        }
        switch (set) {
            case nlq: {
                return ClassLoader.getSystemClassLoader().getResource("NLQ-OKBQA/nlq1_vis.json");
            }
            case QALD1_Test_dbpedia: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/1/data/dbpedia-test.xml");
            }
            case QALD1_Test_musicbrainz: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/1/data/musicbrainz-test.xml");
            }
            case QALD1_Train_dbpedia: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/1/data/dbpedia-train.xml");
            }
            case QALD1_Train_musicbrainz: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/1/data/musicbrainz-train.xml");
            }
            case QALD2_Test_dbpedia: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/2/data/dbpedia-test.xml");
            }
            case QALD2_Test_musicbrainz: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/2/data/musicbrainz-test.xml");
            }
            case QALD2_Train_dbpedia: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/2/data/dbpedia-train.xml");
            }
            case QALD2_Train_musicbrainz: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/2/data/musicbrainz-train.xml");
            }
            case QALD3_Test_dbpedia: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/3/data/dbpedia-test.xml");
            }
            case QALD3_Test_esdbpedia: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/3/data/esdbpedia-test.xml");
            }
            case QALD3_Test_musicbrainz: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/3/data/musicbrainz-test.xml");
            }
            case QALD3_Train_dbpedia: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/3/data/dbpedia-train.xml");
            }
            case QALD3_Train_esdbpedia: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/3/data/esdbpedia-train.xml");
            }
            case QALD3_Train_musicbrainz: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/3/data/musicbrainz-train.xml");
            }
            case QALD4_Test_Hybrid: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/4/data/qald-4_hybrid_test_withanswers.xml");
            }
            case QALD4_Test_Multilingual: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/4/data/qald-4_multilingual_test_withanswers.xml");
            }
            case QALD4_Test_biomedical: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/4/data/qald-4_biomedical_test.xml");
            }
            case QALD4_Train_Hybrid: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/4/data/qald-4_hybrid_train.xml");
            }
            case QALD4_Train_Multilingual: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/4/data/qald-4_multilingual_train_withanswers.xml");
            }
            case QALD4_Train_biomedical: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/4/data/qald-4_biomedical_train.xml");
            }
            case QALD5_Test_Hybrid: 
            case QALD5_Test_Multilingual: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/5/data/qald-5_test.xml");
            }
            case QALD5_Train_Hybrid: 
            case QALD5_Train_Multilingual: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/5/data/qald-5_train.xml");
            }
            case QALD6_Train_Hybrid: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/6/data/qald-6-train-hybrid.json");
            }
            case QALD6_Train_Multilingual: {
                return ClassLoader.getSystemClassLoader().getResource(String.valueOf(qaldDirName) + "/6/data/qald-6-train-multilingual.json");
            }
        }
        return null;
    }

    public static List<IQuestion> load(Dataset data) {
        try {
            InputStream is = null;
            is = QALD_Loader.getInputStream(data);
            List<IQuestion> out = null;
            if (is.available() > 0) {
                switch (data) {
                    case QALD1_Test_dbpedia: 
                    case QALD1_Train_dbpedia: 
                    case QALD1_Test_musicbrainz: 
                    case QALD1_Train_musicbrainz: 
                    case QALD2_Test_dbpedia: 
                    case QALD2_Train_dbpedia: 
                    case QALD2_Test_musicbrainz: 
                    case QALD2_Train_musicbrainz: 
                    case QALD3_Test_dbpedia: 
                    case QALD3_Train_dbpedia: 
                    case QALD3_Test_musicbrainz: 
                    case QALD3_Train_musicbrainz: 
                    case QALD3_Test_esdbpedia: 
                    case QALD3_Train_esdbpedia: 
                    case QALD4_Test_Hybrid: 
                    case QALD4_Train_Hybrid: 
                    case QALD4_Test_Multilingual: 
                    case QALD4_Train_Multilingual: 
                    case QALD4_Test_biomedical: 
                    case QALD4_Train_biomedical: {
                        out = QALD_Loader.loadXML(is);
                        break;
                    }
                    case QALD5_Test_Hybrid: 
                    case QALD5_Train_Hybrid: {
                        ArrayList<IQuestion> hybrid = new ArrayList<IQuestion>();
                        List<IQuestion> loadedQ = QALD_Loader.loadXML(is);
                        for (IQuestion q : loadedQ) {
                            if (!q.getHybrid().booleanValue()) continue;
                            hybrid.add(q);
                        }
                        out = hybrid;
                        break;
                    }
                    case QALD5_Test_Multilingual: 
                    case QALD5_Train_Multilingual: {
                        ArrayList<IQuestion> hybrid = new ArrayList<IQuestion>();
                        List<IQuestion> loadedQ = QALD_Loader.loadXML(is);
                        for (IQuestion q : loadedQ) {
                            if (q.getHybrid().booleanValue()) continue;
                            hybrid.add(q);
                        }
                        out = hybrid;
                        break;
                    }
                    case QALD6_Train_Hybrid: 
                    case QALD6_Train_Multilingual: {
                        out = QALD_Loader.loadJSON(is);
                        break;
                    }
                    case nlq: {
                        out = QALD_Loader.loadNLQ(is);
                    }
                }
                is.close();
                return out;
            }
            throw new IOException("InputStream is null");
        }
        catch (IOException e) {
            log.info("Couldnt load dataset ", (Throwable)e);
            return null;
        }
    }

    public static List<IQuestion> loadXML(InputStream file) {
        ArrayList<IQuestion> questions = new ArrayList<IQuestion>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            doc.getDocumentElement().normalize();
            NodeList questionNodes = doc.getElementsByTagName("question");
            int i = 0;
            while (i < questionNodes.getLength()) {
                Node item;
                NodeList childNodes;
                Question question = new Question();
                Element questionNode = (Element)questionNodes.item(i);
                question.setId(Integer.valueOf(questionNode.getAttribute("id")));
                question.setAnswerType(questionNode.getAttribute("answertype"));
                question.setAggregation(Boolean.valueOf(questionNode.getAttribute("aggregation")));
                question.setOnlydbo(Boolean.valueOf(questionNode.getAttribute("onlydbo")));
                question.setHybrid(Boolean.valueOf(questionNode.getAttribute("hybrid")));
                NodeList nlrs = questionNode.getElementsByTagName("string");
                int j = 0;
                while (j < nlrs.getLength()) {
                    String lang = ((Element)nlrs.item(j)).getAttribute("lang");
                    question.getLanguageToQuestion().put(lang, ((Element)nlrs.item(j)).getTextContent().trim());
                    ++j;
                }
                NodeList keywords = questionNode.getElementsByTagName("keywords");
                int j2 = 0;
                while (j2 < keywords.getLength()) {
                    String lang = ((Element)keywords.item(j2)).getAttribute("lang");
                    question.getLanguageToKeywords().put(lang, Arrays.asList(((Element)keywords.item(j2)).getTextContent().trim().split(", ")));
                    ++j2;
                }
                Element element = (Element)questionNode.getElementsByTagName("pseudoquery").item(0);
                if (element != null && element.hasChildNodes()) {
                    childNodes = element.getChildNodes();
                    item = childNodes.item(0);
                    question.setPseudoSparqlQuery(item.getNodeValue().trim());
                }
                if ((element = (Element)questionNode.getElementsByTagName("query").item(0)) != null && element.hasChildNodes()) {
                    childNodes = element.getChildNodes();
                    item = childNodes.item(0);
                    question.setSparqlQuery(item.getNodeValue().trim());
                }
                if (question.getPseudoSparqlQuery() != null) {
                    question.setOutOfScope(question.getPseudoSparqlQuery().toUpperCase().contains("OUT OF SCOPE"));
                }
                if (question.getSparqlQuery() != null) {
                    question.setOutOfScope(question.getSparqlQuery().toUpperCase().contains("OUT OF SCOPE"));
                }
                NodeList answers = questionNode.getElementsByTagName("answer");
                HashSet<String> set = new HashSet<String>();
                int j3 = 0;
                while (j3 < answers.getLength()) {
                    String answer = ((Element)answers.item(j3)).getTextContent();
                    set.add(answer.trim());
                    ++j3;
                }
                question.setGoldenAnswers(set);
                questions.add(question);
                ++i;
            }
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return questions;
    }

    public static List<IQuestion> loadJSON(InputStream file) {
        ArrayList<IQuestion> output = new ArrayList<IQuestion>();
        try {
            JsonReader jsonReader = Json.createReader((InputStream)file);
            JsonObject mainJsonObject = jsonReader.readObject();
            JsonArray jArray = mainJsonObject.getJsonArray("questions");
            String[] attributes = new String[]{"id", "aggregation", "answertype", "onlydbo", "hybrid"};
            for (JsonValue questionJsonObj : jArray) {
                JsonArray answerList;
                String strQuery;
                JsonObject listObj = (JsonObject)questionJsonObj;
                Question q = new Question();
                String[] stringArray = attributes;
                int n = attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    String attr = stringArray[n2];
                    if (listObj.containsKey((Object)attr)) {
                        String val = ((JsonValue)listObj.get((Object)attr)).toString().replace("\"", "");
                        q.setValue(attr, val);
                    }
                    ++n2;
                }
                output.add(q);
                JsonArray questionArray = listObj.getJsonArray("question");
                for (JsonValue questionVal : questionArray) {
                    JsonObject questionObj = (JsonObject)questionVal;
                    String lang = questionObj.getString("language");
                    q.getLanguageToQuestion().put(lang, questionObj.getString("string").trim());
                    if (!questionObj.containsKey((Object)"keywords")) continue;
                    List<String> keywords = Arrays.asList(questionObj.getString("keywords").split(","));
                    q.getLanguageToKeywords().put(lang, keywords);
                }
                JsonObject query = (JsonObject)listObj.get((Object)"query");
                if (query.containsKey((Object)"sparql")) {
                    strQuery = query.getString("sparql").trim();
                    q.setSparqlQuery(strQuery);
                }
                if (query.containsKey((Object)"pseudo")) {
                    strQuery = query.getString("pseudo").trim();
                    q.setPseudoSparqlQuery(strQuery);
                }
                if ((answerList = listObj.getJsonArray("answers")).isEmpty()) continue;
                JsonObject answerListHead = answerList.getJsonObject(0);
                JsonObject headObject = answerListHead.getJsonObject("head");
                JsonArray vars = headObject.getJsonArray("vars");
                HashSet<String> answers = new HashSet<String>();
                if (answerList.isEmpty()) continue;
                JsonObject answerObject = answerList.getJsonObject(0);
                if (answerObject.containsKey((Object)"boolean")) {
                    answers.add(((JsonValue)answerObject.get((Object)"boolean")).toString());
                }
                if (answerObject.containsKey((Object)"results")) {
                    JsonObject resultObject = answerObject.getJsonObject("results");
                    JsonArray bindingsList = resultObject.getJsonArray("bindings");
                    for (JsonValue bind : bindingsList) {
                        JsonObject bindObj = (JsonObject)bind;
                        for (JsonValue varName : vars) {
                            String var = varName.toString().replaceAll("\"", "");
                            if (!bindObj.containsKey((Object)var)) continue;
                            JsonObject j = bindObj.getJsonObject(var);
                            answers.add(j.getString("value").trim());
                        }
                    }
                }
                q.setGoldenAnswers(answers);
            }
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        boolean printHappend = false;
        String message = "";
        ArrayList<IQuestion> emptyQuestions = new ArrayList<IQuestion>();
        for (IQuestion k : output) {
            if (!k.getGoldenAnswers().isEmpty()) continue;
            emptyQuestions.add(k);
            if (!printHappend) {
                message = String.valueOf(message) + "Following Questions (id) have no attached answers: ";
                printHappend = true;
            }
            message = String.valueOf(message) + k.getId() + ", ";
        }
        if (printHappend) {
            log.debug(String.valueOf(message) + " and will be removed");
        }
        output.removeAll(emptyQuestions);
        return output;
    }

    public static List<IQuestion> loadNLQ(InputStream file) {
        ArrayList<IQuestion> output = new ArrayList<IQuestion>();
        HashMap idToQuestion = new HashMap();
        try {
            if (file.available() > 0) {
                JsonReader jsonReader = Json.createReader((InputStream)file);
                JsonArray mainJsonArray = jsonReader.readArray();
                for (JsonValue currentJsonValue : mainJsonArray) {
                    JsonObject currentObject = (JsonObject)currentJsonValue;
                    try {
                        Integer id = Integer.parseInt(currentObject.getString("id"));
                        if (idToQuestion.containsKey(id)) {
                            ((ArrayList)idToQuestion.get(id)).add(currentObject);
                            continue;
                        }
                        ArrayList<JsonObject> jArray = new ArrayList<JsonObject>();
                        jArray.add(currentObject);
                        idToQuestion.put(id, jArray);
                    }
                    catch (NumberFormatException e) {
                        log.info("Couldnt load question from dataset due to wrong or missing question-id", (Throwable)e);
                    }
                }
            }
        }
        catch (IOException e) {
            log.error("Could not load Dataset", (Throwable)e);
        }
        for (Integer i : idToQuestion.keySet()) {
            Question q = new Question();
            for (JsonObject currentJsonObject : (ArrayList)idToQuestion.get(i)) {
                q.setValue("id", currentJsonObject.getString("id"));
                String lang = currentJsonObject.getString("lang");
                String questiion = currentJsonObject.getString("question");
                String answer = currentJsonObject.getString("answer");
                String sparql = currentJsonObject.getString("sparql");
                q.getLanguageToQuestion().put(lang, questiion);
                q.setSparqlQuery(lang, sparql);
                HashSet<String> answ = new HashSet<String>();
                answ.add(answer);
                q.setGoldenAnswers(lang, answ);
            }
            output.add(q);
        }
        return output;
    }

    public static void main(String[] args) {
        Dataset[] datasetArray = Dataset.values();
        int n = datasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            Dataset data = datasetArray[n2];
            List<IQuestion> questions = QALD_Loader.load(data);
            if (questions == null) {
                System.out.println("Dataset null" + data.toString());
            } else if (questions.size() == 0) {
                System.out.println("Dataset Empty" + data.toString());
            } else {
                System.out.println("LOADED SUCCESSFULLY " + data.toString());
            }
            ++n2;
        }
    }
}

