/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.measure;

import java.util.Set;
import org.aksw.qa.commons.utils.CollectionUtils;
import org.aksw.qa.commons.utils.SPARQLExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQLBasedEvaluation {
    private static Logger logger = LoggerFactory.getLogger(SPARQLBasedEvaluation.class);

    public static double precision(String sparqlQueryString, String targetSPARQLQueryString, String endpoint) {
        double precision = 0.0;
        if (SPARQLBasedEvaluation.isSelectType(sparqlQueryString) && SPARQLBasedEvaluation.isSelectType(targetSPARQLQueryString)) {
            Set<String> nodes = SPARQLExecutor.executeSelect(sparqlQueryString, endpoint).getStringSet();
            Set<String> targetNodes = SPARQLExecutor.executeSelect(targetSPARQLQueryString, endpoint).getStringSet();
            Set<String> intersection = CollectionUtils.intersection(nodes, targetNodes);
            if (nodes.size() != 0) {
                precision = (double)intersection.size() / (double)nodes.size();
            }
        } else if (SPARQLBasedEvaluation.isAskType(sparqlQueryString) && SPARQLBasedEvaluation.isAskType(targetSPARQLQueryString)) {
            boolean targetAnswer;
            boolean answer = SPARQLExecutor.executeAsk(sparqlQueryString, endpoint);
            if (answer == (targetAnswer = SPARQLExecutor.executeAsk(targetSPARQLQueryString, endpoint).booleanValue())) {
                precision = 1.0;
            }
        } else {
            logger.error("Not implemented SPARQL query type.");
        }
        return precision;
    }

    public static double recall(String sparqlQueryString, String targetSPARQLQueryString, String endpoint) {
        double recall = 0.0;
        if (SPARQLBasedEvaluation.isSelectType(sparqlQueryString) && SPARQLBasedEvaluation.isSelectType(targetSPARQLQueryString)) {
            if (SPARQLBasedEvaluation.hasAggregations(sparqlQueryString) && SPARQLBasedEvaluation.hasAggregations(targetSPARQLQueryString)) {
                return 1.0;
            }
            Set<String> nodes = SPARQLExecutor.executeSelect(sparqlQueryString, endpoint).getStringSet();
            Set<String> targetNodes = SPARQLExecutor.executeSelect(targetSPARQLQueryString, endpoint).getStringSet();
            Set<String> intersection = CollectionUtils.intersection(nodes, targetNodes);
            if (nodes.size() != 0) {
                recall = (double)intersection.size() / (double)targetNodes.size();
            }
        } else if (SPARQLBasedEvaluation.isAskType(sparqlQueryString) && SPARQLBasedEvaluation.isAskType(targetSPARQLQueryString)) {
            recall = 1.0;
        } else {
            logger.error("Not implemented SPARQL query type.");
        }
        return recall;
    }

    public static double fMeasure(String sparqlQuery, String targetSPARQLQuery, String endpoint) {
        double precision = SPARQLBasedEvaluation.precision(sparqlQuery, targetSPARQLQuery, endpoint);
        double recall = SPARQLBasedEvaluation.recall(sparqlQuery, targetSPARQLQuery, endpoint);
        double fMeasure = 0.0;
        if (precision + recall > 0.0) {
            fMeasure = 2.0 * precision * recall / (precision + recall);
        }
        return fMeasure;
    }

    private static boolean isAskType(String sparqlQuery) {
        return sparqlQuery.contains("\nASK\n") || sparqlQuery.contains("ASK ");
    }

    private static boolean isSelectType(String sparqlQuery) {
        return sparqlQuery.contains("\nSELECT\n") || sparqlQuery.contains("SELECT ");
    }

    private static boolean hasAggregations(String query) {
        return query.toLowerCase().contains("count") || query.toLowerCase().contains("sum");
    }
}

