/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.commons.load;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.aksw.qa.commons.datastructure.IQuestion;
import org.aksw.qa.commons.datastructure.Question;
import org.aksw.qa.commons.load.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class QALD_Loader {
    static Logger log = LoggerFactory.getLogger(QALD_Loader.class);

    private static InputStream getInputStream(Dataset set) throws IOException {
        URL url = QALD_Loader.mapDatasetToPath(set);
        System.out.println(url);
        return url.openStream();
    }

    private static String getInputStreamURL(Dataset set) throws IOException {
        URL url = QALD_Loader.mapDatasetToPath(set);
        return url.toString();
    }

    private static URL mapDatasetToPath(Dataset set) {
        System.out.println(set.toString());
        switch (set) {
            case nlq: {
                return ClassLoader.getSystemClassLoader().getResource("NLQ-OKBQA/nlq1_vis.json");
            }
            case QALD5_Test: {
                return ClassLoader.getSystemClassLoader().getResource("QALD-5/qald-5_test.xml");
            }
            case QALD6_Train_Hybrid: {
                return ClassLoader.getSystemClassLoader().getResource("QALD-6/qald-6-train-hybrid.json");
            }
            case QALD6_Train_Multilingual: {
                return ClassLoader.getSystemClassLoader().getResource("QALD-6/qald-6-train-multilingual.json");
            }
            case QALD6_Train_Datacube: {
                return ClassLoader.getSystemClassLoader().getResource("QALD-6/qald-6-train-datacube.json");
            }
            case QALD5_Train: {
                return ClassLoader.getSystemClassLoader().getResource("QALD-5/qald-5_train.xml");
            }
            case qbench1: {
                return ClassLoader.getSystemClassLoader().getResource("qbench/qbench1.xml");
            }
            case qbench2: {
                return ClassLoader.getSystemClassLoader().getResource("qbench/qbench2.xml");
            }
            case stonetemple: {
                return ClassLoader.getSystemClassLoader().getResource("stonetemple/stonetemple");
            }
        }
        return null;
    }

    public static List<IQuestion> load(Dataset data) {
        try {
            InputStream is = null;
            is = QALD_Loader.getInputStream(data);
            String isURL = QALD_Loader.getInputStreamURL(data);
            if (is.available() > 0) {
                if (isURL.toLowerCase().endsWith("xml")) {
                    log.info("Loading XML file [" + isURL + "].");
                    List<IQuestion> ret = QALD_Loader.loadXML(is);
                    is.close();
                    return ret;
                }
                if (isURL.toLowerCase().endsWith("json")) {
                    log.info("Loading JSON file [" + isURL + "].");
                    List<IQuestion> ret = QALD_Loader.loadJSON(is);
                    is.close();
                    return ret;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<IQuestion> loadXML(InputStream file) {
        ArrayList<IQuestion> questions = new ArrayList<IQuestion>();
        try {
            if (file.available() > 0) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(file);
                doc.getDocumentElement().normalize();
                NodeList questionNodes = doc.getElementsByTagName("question");
                for (int i = 0; i < questionNodes.getLength(); ++i) {
                    Node item;
                    NodeList childNodes;
                    Question question = new Question();
                    Element questionNode = (Element)questionNodes.item(i);
                    question.setId(Integer.valueOf(questionNode.getAttribute("id")));
                    question.setAnswerType(questionNode.getAttribute("answertype"));
                    question.setAggregation(Boolean.valueOf(questionNode.getAttribute("aggregation")));
                    question.setOnlydbo(Boolean.valueOf(questionNode.getAttribute("onlydbo")));
                    question.setHybrid(Boolean.valueOf(questionNode.getAttribute("hybrid")));
                    NodeList nlrs = questionNode.getElementsByTagName("string");
                    for (int j = 0; j < nlrs.getLength(); ++j) {
                        String lang = ((Element)nlrs.item(j)).getAttribute("lang");
                        question.getLanguageToQuestion().put(lang, ((Element)nlrs.item(j)).getTextContent().trim());
                    }
                    NodeList keywords = questionNode.getElementsByTagName("keywords");
                    for (int j = 0; j < keywords.getLength(); ++j) {
                        String lang = ((Element)keywords.item(j)).getAttribute("lang");
                        question.getLanguageToKeywords().put(lang, Arrays.asList(((Element)keywords.item(j)).getTextContent().trim().split(", ")));
                    }
                    Element element = (Element)questionNode.getElementsByTagName("pseudoquery").item(0);
                    if (element != null && element.hasChildNodes()) {
                        childNodes = element.getChildNodes();
                        item = childNodes.item(0);
                        question.setPseudoSparqlQuery(item.getNodeValue().trim());
                    }
                    if ((element = (Element)questionNode.getElementsByTagName("query").item(0)) != null && element.hasChildNodes()) {
                        childNodes = element.getChildNodes();
                        item = childNodes.item(0);
                        question.setSparqlQuery(item.getNodeValue().trim());
                    }
                    if (question.getPseudoSparqlQuery() != null) {
                        question.setOutOfScope(question.getPseudoSparqlQuery().toUpperCase().contains("OUT OF SCOPE"));
                    }
                    if (question.getSparqlQuery() != null) {
                        question.setOutOfScope(question.getSparqlQuery().toUpperCase().contains("OUT OF SCOPE"));
                    }
                    NodeList answers = questionNode.getElementsByTagName("answer");
                    HashSet<String> set = new HashSet<String>();
                    for (int j = 0; j < answers.getLength(); ++j) {
                        String answer = ((Element)answers.item(j)).getTextContent();
                        set.add(answer.trim());
                    }
                    question.setGoldenAnswers(set);
                    questions.add(question);
                }
            }
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return questions;
    }

    public static List<IQuestion> loadJSON(InputStream file) {
        ArrayList<IQuestion> output = new ArrayList<IQuestion>();
        try {
            if (file.available() > 0) {
                JsonReader jsonReader = Json.createReader((InputStream)file);
                JsonObject mainJsonObject = jsonReader.readObject();
                JsonArray jArray = mainJsonObject.getJsonArray("questions");
                String[] attributes = new String[]{"id", "aggregation", "answertype", "onlydbo", "hybrid"};
                for (JsonValue questionJsonObj : jArray) {
                    JsonArray answerList;
                    JsonObject listObj = (JsonObject)questionJsonObj;
                    Question q = new Question();
                    for (String attr : attributes) {
                        if (!listObj.containsKey((Object)attr)) continue;
                        String val = ((JsonValue)listObj.get((Object)attr)).toString().replace("\"", "");
                        q.setValue(attr, val);
                    }
                    output.add(q);
                    JsonArray questionArray = listObj.getJsonArray("question");
                    for (JsonValue questionVal : questionArray) {
                        JsonObject questionObj = (JsonObject)questionVal;
                        String lang = questionObj.getString("language");
                        q.getLanguageToQuestion().put(lang, questionObj.getString("string").trim());
                        if (!questionObj.containsKey((Object)"keywords")) continue;
                        List<String> keywords = Arrays.asList(questionObj.getString("keywords").split(","));
                        q.getLanguageToKeywords().put(lang, keywords);
                    }
                    JsonObject query = (JsonObject)listObj.get((Object)"query");
                    if (query.containsKey((Object)"sparql")) {
                        String strQuery = query.getString("sparql").trim();
                        q.setSparqlQuery(strQuery);
                    }
                    if (query.containsKey((Object)"pseudo")) {
                        String strQuery = query.getString("pseudo").trim();
                        q.setPseudoSparqlQuery(strQuery);
                    }
                    if ((answerList = listObj.getJsonArray("answers")).isEmpty()) continue;
                    JsonObject answerListHead = answerList.getJsonObject(0);
                    JsonObject headObject = answerListHead.getJsonObject("head");
                    JsonArray vars = headObject.getJsonArray("vars");
                    HashSet<String> answers = new HashSet<String>();
                    if (answerList.isEmpty()) continue;
                    JsonObject answerObject = answerList.getJsonObject(0);
                    if (answerObject.containsKey((Object)"boolean")) {
                        answers.add(((JsonValue)answerObject.get((Object)"boolean")).toString());
                    }
                    if (answerObject.containsKey((Object)"results")) {
                        JsonObject resultObject = answerObject.getJsonObject("results");
                        JsonArray bindingsList = resultObject.getJsonArray("bindings");
                        for (JsonValue bind : bindingsList) {
                            JsonObject bindObj = (JsonObject)bind;
                            for (JsonValue varName : vars) {
                                String var = varName.toString().replaceAll("\"", "");
                                if (!bindObj.containsKey((Object)var)) continue;
                                JsonObject j = bindObj.getJsonObject(var);
                                answers.add(j.getString("value").trim());
                            }
                        }
                    }
                    q.setGoldenAnswers(answers);
                }
            }
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        boolean unanswered = false;
        for (IQuestion k : output) {
            if (!k.getGoldenAnswers().isEmpty()) continue;
            if (!unanswered) {
                System.out.println("Following Questions (id) have no attached answers:");
                unanswered = true;
            }
            System.out.print(k.getId() + ", ");
        }
        return output;
    }
}

