/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.annotation.webservice;

import org.aksw.qa.annotation.comparison.ComparisonUtils;
import org.aksw.qa.annotation.util.NifEverything;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/comparison"})
public class ComparisonRequest {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ComparisonUtils properties;
    private NifEverything nif = NifEverything.getInstance();

    public ComparisonRequest() {
        this.properties = new ComparisonUtils();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String getProperty(@RequestParam(value="q") String q) {
        this.logger.debug("Requesting COMPARISON search for term (VIA GET) :|" + q + "|");
        return this.nif.createNIFResultFromComparisonUtils(q, this.properties, NifEverything.NifProperty.TAIDENTREF);
    }

    @RequestMapping(method={RequestMethod.POST})
    public String postProperty(@RequestBody String input) {
        this.logger.debug("Requesting COMPARISON search for term (VIA POST) ");
        this.logger.trace("|" + input + "|");
        return this.nif.appendNIFResultFromComparisonUtils(input, this.properties, NifEverything.NifProperty.TAIDENTREF);
    }
}

