/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.annotation.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.aksw.gerbil.io.nif.impl.TurtleNIFParser;
import org.aksw.gerbil.io.nif.impl.TurtleNIFWriter;
import org.aksw.gerbil.transfer.nif.Document;
import org.aksw.gerbil.transfer.nif.Marking;
import org.aksw.gerbil.transfer.nif.data.DocumentImpl;
import org.aksw.gerbil.transfer.nif.data.NamedEntity;
import org.aksw.gerbil.transfer.nif.data.TypedSpanImpl;
import org.aksw.qa.annotation.comparison.ComparisonUtils;
import org.aksw.qa.annotation.index.IndexDBO;
import org.aksw.qa.annotation.spotter.ASpotter;
import org.aksw.qa.commons.datastructure.Entity;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NifEverything {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static NifEverything nif = null;
    public static final String INPUT_NOT_PARSABLE = "Given input not parsable or nothing found";

    private NifEverything() {
    }

    public static NifEverything getInstance() {
        if (nif == null) {
            nif = new NifEverything();
        }
        return nif;
    }

    private List<ImmutablePair<String, Integer>> extractSplitQuestion(String q) {
        ArrayList<ImmutablePair<String, Integer>> ret = new ArrayList<ImmutablePair<String, Integer>>();
        String cleanedSentence = q.trim().replaceAll("(\\p{Punct})(\\s)*(\\z)", " $1");
        int wordIndex = 0;
        for (String s : cleanedSentence.split(" ")) {
            ret.add((ImmutablePair<String, Integer>)new ImmutablePair((Object)s, (Object)wordIndex));
            wordIndex += s.length() + 1;
        }
        return ret;
    }

    public String createNIFResultFromIndexDBO(String q, IndexDBO indexDBO, NifProperty nif) {
        DocumentImpl doc = new DocumentImpl(q);
        this.addAllMarkingsToDoc((Document)doc, this.stringToMarkingsIndexDBO(q, indexDBO, nif));
        return this.writeNIF((Document)doc);
    }

    public String appendNIFResultFromIndexDBO(String documentsString, IndexDBO indexDBO, NifProperty nif) {
        List<Document> docs = null;
        try {
            docs = this.parseNIF(documentsString);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("Given input results in empty document list - check input");
            return INPUT_NOT_PARSABLE;
        }
        for (Document doc : docs) {
            this.addAllMarkingsToDoc(doc, this.stringToMarkingsIndexDBO(doc.getText(), indexDBO, nif));
        }
        return this.writeNIF(docs);
    }

    public String createNIFResultFromComparisonUtils(String q, ComparisonUtils comparison, NifProperty nif) {
        DocumentImpl doc = new DocumentImpl(q);
        this.addAllMarkingsToDoc((Document)doc, this.stringToMarkingsComparison(q, comparison, nif));
        return this.writeNIF((Document)doc);
    }

    public String appendNIFResultFromComparisonUtils(String documentsString, ComparisonUtils comparison, NifProperty nif) {
        List<Document> docs = null;
        try {
            docs = this.parseNIF(documentsString);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("Given input results in empty document list - check input");
            return INPUT_NOT_PARSABLE;
        }
        for (Document doc : docs) {
            this.addAllMarkingsToDoc(doc, this.stringToMarkingsComparison(doc.getText(), comparison, nif));
        }
        return this.writeNIF(docs);
    }

    public void addAllMarkingsToDoc(Document doc, Collection<Marking> markings) {
        for (Marking marking : markings) {
            doc.addMarking(marking);
        }
    }

    private List<Marking> stringToMarkingsIndexDBO(String q, IndexDBO indexDBO, NifProperty nif) {
        ArrayList<Marking> markings = new ArrayList<Marking>();
        for (ImmutablePair<String, Integer> it : this.extractSplitQuestion(q)) {
            List<String> foundURIs = indexDBO.search((String)it.getLeft());
            if (CollectionUtils.isEmpty(foundURIs)) continue;
            markings.add(nif.getInstanceWith((Integer)it.getRight(), ((String)it.getLeft()).length(), foundURIs));
        }
        return markings;
    }

    private List<Marking> stringToMarkingsComparison(String q, ComparisonUtils comparison, NifProperty nif) {
        ArrayList<Marking> markings = new ArrayList<Marking>();
        for (ImmutablePair<String, Integer> it : this.extractSplitQuestion(q)) {
            ArrayList foundComparisons = new ArrayList();
            ArrayList<String> foundURIs = new ArrayList<String>();
            Stream.of(comparison.getSuperlatives((String)it.getLeft()), comparison.getComparatives((String)it.getLeft())).forEach(foundComparisons::addAll);
            foundComparisons.stream().map(x -> comparison.getProperties((String)x)).forEach(foundURIs::addAll);
            if (CollectionUtils.isEmpty(foundURIs)) continue;
            markings.add(nif.getInstanceWith((Integer)it.getRight(), ((String)it.getLeft()).length(), foundURIs));
        }
        return markings;
    }

    public String appendNIFResultFromSpotters(String documentsString, ASpotter spotter) {
        List<Document> docs = null;
        try {
            docs = this.parseNIF(documentsString);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("Given input results in empty document list - check input");
            return INPUT_NOT_PARSABLE;
        }
        for (Document doc : docs) {
            this.addAllMarkingsToDoc(doc, this.stringToMarkingsSpotters(doc.getText(), spotter));
        }
        return this.writeNIF(docs);
    }

    public String writeNIF(List<Document> docs) {
        TurtleNIFWriter writer = new TurtleNIFWriter();
        return writer.writeNIF(docs);
    }

    public String createNIFResultFromSpotters(String q, ASpotter spotter) {
        DocumentImpl doc = new DocumentImpl(q);
        this.addAllMarkingsToDoc((Document)doc, this.stringToMarkingsSpotters(q, spotter));
        return this.writeNIF((Document)doc);
    }

    private List<Marking> stringToMarkingsSpotters(String q, ASpotter spotter) {
        ArrayList<Marking> markings = new ArrayList<Marking>();
        ArrayList<Entity> allEntities = new ArrayList<Entity>();
        for (List<Entity> it : spotter.getEntities(q).values()) {
            allEntities.addAll(it);
        }
        for (Entity entityIt : allEntities) {
            ArrayList<String> uris = new ArrayList<String>();
            for (Resource res : entityIt.getUris()) {
                uris.add(res.getURI());
            }
            markings.add(NifProperty.TAIDENTREF.getInstanceWith(entityIt.getOffset(), entityIt.getLabel().length(), uris));
        }
        return markings;
    }

    public String writeNIF(Document doc) {
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(doc);
        TurtleNIFWriter writer = new TurtleNIFWriter();
        String nifString = writer.writeNIF(documents);
        return nifString;
    }

    public List<Document> parseNIF(String input) throws IllegalArgumentException {
        TurtleNIFParser parser = new TurtleNIFParser();
        List docs = parser.parseNIF(input);
        for (Document doc : docs) {
            doc.setDocumentURI(null);
        }
        if (CollectionUtils.isEmpty((Collection)docs)) {
            this.logger.debug("Recieved empty or not parsable POST body");
            throw new IllegalArgumentException("Nothing parsed");
        }
        return docs;
    }

    public static enum NifProperty {
        TAIDENTREF{

            @Override
            public Marking getInstanceWith(int offset, int len, List<String> uris) {
                return new NamedEntity(offset, len, new HashSet<String>(uris));
            }
        }
        ,
        TACLASSREF{

            @Override
            public Marking getInstanceWith(int offset, int len, List<String> uris) {
                return new TypedSpanImpl(offset, len, new HashSet<String>(uris));
            }
        };


        public abstract Marking getInstanceWith(int var1, int var2, List<String> var3);
    }
}

