/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.annotation.spotter;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.qa.annotation.spotter.ASpotter;
import org.aksw.qa.commons.datastructure.Entity;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fox
extends ASpotter {
    private static Logger log = LoggerFactory.getLogger(Fox.class);
    private String requestURL = "http://fox.cs.uni-paderborn.de:4444/fox";
    private String outputFormat = "RDF/JSON";
    private String taskType = "ner";
    private String inputType = "text";
    private String contentType = "application/json; charset=utf-8";

    private String doTask(String inputText) {
        JSONObject urlParameters = new JSONObject();
        urlParameters.put((Object)"type", (Object)this.inputType);
        urlParameters.put((Object)"task", (Object)this.taskType);
        urlParameters.put((Object)"lang", (Object)"en");
        urlParameters.put((Object)"output", (Object)this.outputFormat);
        urlParameters.put((Object)"input", (Object)inputText);
        return this.requestPOST(urlParameters.toString(), this.requestURL, this.contentType);
    }

    @Override
    public Map<String, List<Entity>> getEntities(String question) {
        HashMap<String, List<Entity>> mappedEntitiesReturn = new HashMap<String, List<Entity>>();
        String foxJSONOutput = null;
        foxJSONOutput = this.doTask(question);
        if (!"".equals(foxJSONOutput) && foxJSONOutput != null) {
            try {
                JSONParser parser = new JSONParser();
                JSONObject jsonArray = (JSONObject)parser.parse(foxJSONOutput);
                ArrayList<Entity> tmpList = new ArrayList<Entity>();
                for (Object key : jsonArray.keySet()) {
                    JSONObject json = (JSONObject)jsonArray.get(key);
                    if (!json.keySet().contains("http://www.w3.org/2005/11/its/rdf#taIdentRef")) continue;
                    Entity ent = new Entity();
                    JSONArray uriArray = (JSONArray)json.get((Object)"http://www.w3.org/2005/11/its/rdf#taIdentRef");
                    String uri = (String)((JSONObject)uriArray.get(0)).get((Object)"value");
                    String encode = uri.replaceAll(",", "%2C");
                    ResourceImpl e = new ResourceImpl(encode);
                    ent.getUris().add(e);
                    JSONArray typeArray = (JSONArray)json.get((Object)"http://www.w3.org/2005/11/its/rdf#taClassRef");
                    for (int i = 0; i < typeArray.size(); ++i) {
                        JSONObject types = (JSONObject)typeArray.get(i);
                        encode = ((String)types.get((Object)"value")).replaceAll(",", "%2C");
                        e = new ResourceImpl(encode);
                        ent.getPosTypesAndCategories().add(e);
                    }
                    JSONArray labelArray = (JSONArray)json.get((Object)"http://persistence.uni-leipzig.org/nlp2rdf/ontologies/nif-core#anchorOf");
                    String label = (String)((JSONObject)labelArray.get(0)).get((Object)"value");
                    ent.setLabel(label);
                    JSONArray offsetArray = (JSONArray)json.get((Object)"http://persistence.uni-leipzig.org/nlp2rdf/ontologies/nif-core#beginIndex");
                    String offset = (String)((JSONObject)offsetArray.get(0)).get((Object)"value");
                    ent.setOffset(Integer.parseInt(offset));
                    tmpList.add(ent);
                }
                mappedEntitiesReturn.put("en", tmpList);
            }
            catch (ParseException e) {
                log.error("Could not parse Server rensponse", (Throwable)e);
            }
        }
        if (!mappedEntitiesReturn.isEmpty()) {
            log.debug("\t" + Joiner.on((String)"\n").join((Iterable)mappedEntitiesReturn.get("en")));
        }
        return mappedEntitiesReturn;
    }
}

