/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.annotation.sparql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aksw.gerbil.transfer.nif.Document;
import org.aksw.gerbil.transfer.nif.Marking;
import org.aksw.gerbil.transfer.nif.data.NamedEntity;
import org.aksw.gerbil.transfer.nif.data.TypedNamedEntity;
import org.aksw.gerbil.transfer.nif.data.TypedSpanImpl;
import org.aksw.qa.annotation.sparql.SimpleQuantityRanker;
import org.aksw.qa.annotation.util.NifEverything;

public class PatternSparqlGenerator {
    private static final String NOT_DEFINED = "No pattern for those quantities of classes / properties / named entities available";
    private static PatternSparqlGenerator instance;
    private Integer limit = null;
    private NifEverything nif = NifEverything.getInstance();
    private SimpleQuantityRanker ranker = new SimpleQuantityRanker();
    private List<String> classes;
    private List<String> properties;
    private List<String> namedEntities;
    private static final String CLASS_PREFIX = "a dbo:";
    private static final String PROPERTY_PREFIX = "dbo:";
    private static final String NAMED_ENTITY_PREFIX = "dbr:";
    private static final String URI_START_PREFIX = "http://dbpedia.org/";
    private static final String PROJ = " ?proj ";
    private static final String PROJ2 = " ?proj2 ";

    private PatternSparqlGenerator() {
    }

    public static PatternSparqlGenerator getInstance() {
        if (instance == null) {
            instance = new PatternSparqlGenerator();
        }
        return instance;
    }

    public String nifToQuery(Document doc) {
        List markings = doc.getMarkings();
        ArrayList<String> classUri = new ArrayList<String>();
        ArrayList<String> propertyUri = new ArrayList<String>();
        ArrayList<String> namedUri = new ArrayList<String>();
        for (Marking marking : markings) {
            if (marking instanceof TypedSpanImpl) {
                classUri.add(this.ranker.rank(((TypedSpanImpl)marking).getTypes()));
                continue;
            }
            if (marking instanceof TypedNamedEntity) {
                TypedNamedEntity typednamed = (TypedNamedEntity)marking;
                boolean foundNamed = false;
                for (String uri : typednamed.getUris()) {
                    if (!uri.contains("dbpedia.org/resource")) continue;
                    namedUri.add(uri);
                    foundNamed = true;
                    break;
                }
                if (!foundNamed) {
                    ArrayList<String> uris = new ArrayList<String>();
                    uris.addAll(typednamed.getUris());
                    uris.addAll(typednamed.getTypes());
                    String ranked = this.ranker.rank(uris);
                    if (this.ranker.disambiguateOntologyIsProperty(ranked)) {
                        propertyUri.add(ranked);
                    } else {
                        classUri.add(ranked);
                    }
                }
                classUri.add((String)typednamed.getTypes().iterator().next());
                continue;
            }
            if (!(marking instanceof NamedEntity)) continue;
            NamedEntity named = (NamedEntity)marking;
            String uri = (String)named.getUris().iterator().next();
            if (uri.contains("dbpedia.org/resource")) {
                namedUri.add(uri);
                continue;
            }
            propertyUri.add(uri);
        }
        return this.generateQuery(classUri, propertyUri, namedUri);
    }

    public String nifStrigToQuery(String nifString) {
        List<Document> parsedDocs = this.nif.parseNIF(nifString);
        if (parsedDocs.size() != 1) {
            return "Cannot convert more than one nif at a time";
        }
        return this.nifToQuery(parsedDocs.get(0));
    }

    public String generateQuery(List<String> classesIn, List<String> propertiesIn, List<String> namedEntitiesIn) {
        this.classes = this.emptyIfNull(classesIn);
        this.properties = this.emptyIfNull(propertiesIn);
        this.namedEntities = this.emptyIfNull(namedEntitiesIn);
        switch (this.classes.size()) {
            case 0: {
                switch (this.properties.size()) {
                    case 0: {
                        switch (this.namedEntities.size()) {
                            case 0: {
                                return NOT_DEFINED;
                            }
                            case 1: {
                                return "SELECT " + this.named(0).get() + " WHERE {}";
                            }
                            case 2: {
                                return this.construct(Querytype.SELECT, this.named(0), this.var(PROJ), this.named(1));
                            }
                        }
                        return NOT_DEFINED;
                    }
                    case 1: {
                        switch (this.namedEntities.size()) {
                            case 0: {
                                return this.construct(Querytype.SELECT, this.var(PROJ), this.prop(0), this.var(PROJ2));
                            }
                            case 1: {
                                return this.construct(Querytype.SELECT, this.named(0), this.prop(0), this.var(PROJ));
                            }
                            case 2: {
                                return this.construct(Querytype.SELECT, this.named(0), this.prop(0), this.var(PROJ), this.named(1), this.prop(0), this.var(PROJ));
                            }
                        }
                        return NOT_DEFINED;
                    }
                    case 2: {
                        switch (this.namedEntities.size()) {
                            case 0: {
                                return this.construct(Querytype.SELECT, this.var(PROJ), this.prop(0), this.var(PROJ2), this.var(PROJ), this.prop(1), this.var(PROJ2));
                            }
                            case 1: {
                                return this.construct(Querytype.SELECT, this.named(0), this.prop(0), this.var(PROJ), this.named(0), this.prop(1), this.var(PROJ));
                            }
                            case 2: {
                                return this.construct(Querytype.SELECT, this.named(0), this.prop(0), this.var(PROJ), this.named(1), this.prop(1), this.var(PROJ));
                            }
                        }
                        return NOT_DEFINED;
                    }
                }
                return NOT_DEFINED;
            }
            case 1: {
                switch (this.properties.size()) {
                    case 0: {
                        switch (this.namedEntities.size()) {
                            case 0: {
                                return this.construct(Querytype.SELECT, this.var(PROJ), this.clazz(0));
                            }
                            case 1: {
                                return this.construct(Querytype.ASK, this.named(0), this.clazz(0));
                            }
                            case 2: {
                                return this.construct(Querytype.ASK, this.named(0), this.clazz(0), this.named(1), this.clazz(0));
                            }
                        }
                        return NOT_DEFINED;
                    }
                    case 1: {
                        switch (this.namedEntities.size()) {
                            case 0: {
                                return this.construct(Querytype.SELECT, this.var(PROJ), this.clazz(0), this.var(PROJ), this.prop(0), this.var(PROJ2));
                            }
                            case 1: {
                                return this.construct(Querytype.SELECT, this.var(PROJ), this.clazz(0), this.named(0), this.prop(0), this.var(PROJ));
                            }
                            case 2: {
                                return this.construct(Querytype.SELECT, this.var(PROJ), this.clazz(0), this.named(0), this.prop(0), this.var(PROJ), this.named(1), this.prop(0), this.var(PROJ));
                            }
                        }
                        return NOT_DEFINED;
                    }
                    case 2: {
                        switch (this.namedEntities.size()) {
                            case 0: {
                                return this.construct(Querytype.SELECT, this.var(PROJ), this.clazz(0), this.var(PROJ), this.prop(0), this.var(PROJ2), this.var(PROJ), this.prop(1), this.var(PROJ2));
                            }
                            case 1: {
                                return this.construct(Querytype.SELECT, this.var(PROJ), this.clazz(0), this.named(0), this.prop(0), this.var(PROJ), this.named(0), this.prop(1), this.var(PROJ));
                            }
                            case 2: {
                                return this.construct(Querytype.SELECT, this.var(PROJ), this.clazz(0), this.named(0), this.prop(0), this.var(PROJ), this.named(1), this.prop(1), this.var(PROJ));
                            }
                        }
                        return NOT_DEFINED;
                    }
                }
                return NOT_DEFINED;
            }
            case 2: {
                switch (this.properties.size()) {
                    case 0: {
                        switch (this.namedEntities.size()) {
                            case 0: {
                                return this.construct(Querytype.SELECT, this.var(PROJ), this.clazz(0), this.var(PROJ), this.clazz(1));
                            }
                            case 1: {
                                return this.construct(Querytype.ASK, this.named(0), this.clazz(0), this.named(0), this.clazz(1));
                            }
                            case 2: {
                                return this.construct(Querytype.ASK, this.named(0), this.clazz(0), this.named(1), this.clazz(1));
                            }
                        }
                        return NOT_DEFINED;
                    }
                    case 1: {
                        switch (this.namedEntities.size()) {
                            case 0: {
                                return this.construct(Querytype.SELECT, this.var(PROJ), this.clazz(0), this.var(PROJ), this.clazz(1), this.var(PROJ), this.prop(0), this.var(PROJ2));
                            }
                            case 1: {
                                return this.construct(Querytype.SELECT, this.var(PROJ), this.clazz(0), this.var(PROJ), this.clazz(1), this.named(0), this.prop(0), this.var(PROJ));
                            }
                            case 2: {
                                return this.construct(Querytype.SELECT, this.var(PROJ), this.clazz(0), this.var(PROJ), this.clazz(1), this.named(0), this.prop(0), this.var(PROJ), this.named(1), this.prop(0), this.var(PROJ));
                            }
                        }
                        return NOT_DEFINED;
                    }
                    case 2: {
                        switch (this.namedEntities.size()) {
                            case 0: {
                                return this.construct(Querytype.SELECT, this.var(PROJ), this.clazz(0), this.var(PROJ), this.clazz(1), this.var(PROJ), this.prop(0), this.var(PROJ2), this.var(PROJ), this.prop(1), this.var(PROJ2));
                            }
                            case 1: {
                                return this.construct(Querytype.SELECT, this.var(PROJ), this.clazz(0), this.var(PROJ), this.clazz(1), this.named(0), this.prop(0), this.var(PROJ), this.named(0), this.prop(1), this.var(PROJ));
                            }
                            case 2: {
                                return this.construct(Querytype.SELECT, this.var(PROJ), this.clazz(0), this.var(PROJ), this.clazz(1), this.named(0), this.prop(0), this.var(PROJ), this.named(1), this.prop(1), this.var(PROJ));
                            }
                        }
                        return NOT_DEFINED;
                    }
                }
                return NOT_DEFINED;
            }
        }
        return NOT_DEFINED;
    }

    private <T> List<T> emptyIfNull(List<T> coll) {
        if (coll == null) {
            return new ArrayList();
        }
        return coll;
    }

    private Querypart clazz(int index) {
        String uri = this.classes.get(index);
        if (uri.startsWith(URI_START_PREFIX)) {
            return new Clazz(" a <" + uri + ">");
        }
        return new Clazz(CLASS_PREFIX + uri);
    }

    private Querypart prop(int index) {
        String uri = this.properties.get(index);
        if (uri.startsWith(URI_START_PREFIX)) {
            return new Property("<" + uri + ">");
        }
        return new Property(PROPERTY_PREFIX + uri);
    }

    private Querypart named(int index) {
        String uri = this.namedEntities.get(index);
        if (uri.startsWith(URI_START_PREFIX)) {
            return new Named("<" + uri + ">");
        }
        return new Named(NAMED_ENTITY_PREFIX + uri);
    }

    private Querypart var(String var) {
        return new Variable(var);
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    private String construct(Querytype type, Querypart ... queryparts) {
        List<Querypart> input = Arrays.asList(queryparts);
        int partCntr = 1;
        String query = "";
        for (Querypart it : input) {
            query = query + " " + it.get();
            if (partCntr == 3 || it instanceof Clazz) {
                query = query + " . ";
                partCntr = 0;
            }
            ++partCntr;
        }
        String out = "";
        switch (type) {
            case SELECT: {
                out = "SELECT * WHERE{ " + query + " }";
                break;
            }
            case ASK: {
                out = "ASK { " + query + " } ";
                break;
            }
            default: {
                return NOT_DEFINED;
            }
        }
        if (this.limit != null) {
            out = out + " LIMIT " + this.limit;
        }
        return out;
    }

    class Variable
    extends Querypart {
        public Variable(String part) {
            super(part);
        }
    }

    class Named
    extends Querypart {
        public Named(String part) {
            super(part);
        }
    }

    class Property
    extends Querypart {
        public Property(String part) {
            super(part);
        }
    }

    class Clazz
    extends Querypart {
        public Clazz(String part) {
            super(part);
        }
    }

    class Querypart {
        private String part;

        public Querypart(String part) {
            this.part = part;
        }

        public String get() {
            return this.part;
        }
    }

    static enum Querytype {
        SELECT,
        ASK;

    }
}

