/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.annotation.comparison;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.aksw.qa.annotation.comparison.ComparisonEnum;

public class ComparisonUtils {
    private static final StanfordCoreNLP PIPELINE;
    private static final String COMPARATIVETAG = "JJR";
    private static final String SUPERLATIVETAG = "JJS";

    public ArrayList<String> getProperties(String comparison) {
        if (comparison == null) {
            return null;
        }
        String comp = comparison.toUpperCase();
        if (Arrays.stream(ComparisonEnum.values()).anyMatch(enumValue -> enumValue.toString().equals(comp))) {
            return ComparisonEnum.valueOf(comp).getURIS();
        }
        return null;
    }

    public String getOrder(String comparison) {
        if (comparison == null) {
            return null;
        }
        String comp = comparison.toUpperCase();
        if (Arrays.stream(ComparisonEnum.values()).anyMatch(enumValue -> enumValue.toString().equals(comp))) {
            return ComparisonEnum.valueOf(comp).getOrder();
        }
        return null;
    }

    public ArrayList<String> getComparatives(String question) {
        return this.getWords(question, COMPARATIVETAG);
    }

    public ArrayList<String> getSuperlatives(String question) {
        return this.getWords(question, SUPERLATIVETAG);
    }

    private ArrayList<String> getWords(String question, String tag) {
        if (question == null || tag == null) {
            return null;
        }
        Annotation annotation = new Annotation(question);
        PIPELINE.annotate(annotation);
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        ArrayList<String> words = new ArrayList<String>();
        for (CoreMap sentence : sentences) {
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            for (CoreLabel token : tokens) {
                if (!token.tag().startsWith(tag)) continue;
                String word = token.toString();
                words.add(word.substring(0, word.lastIndexOf("-")));
            }
        }
        return words;
    }

    static {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize, ssplit, pos, depparse");
        PIPELINE = new StanfordCoreNLP(props);
    }
}

