/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.annotation.cache;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentCache {
    public static Logger log = LoggerFactory.getLogger(PersistentCache.class);
    public String charset = "UTF-8";
    public static String cacheLocation;
    public HashMap<String, String> cache;

    public PersistentCache() {
        cacheLocation = new File("cache/spotterCache").getAbsolutePath();
        log.debug("cacheLocation: " + cacheLocation);
        this.readCache();
    }

    public void readCache() {
        this.cache = new HashMap();
        try {
            if (new File(cacheLocation).exists()) {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(cacheLocation), "UTF8"));
                String s = reader.readLine();
                while (s != null) {
                    String input = s.split("\t")[0];
                    String output = s.split("\t")[1];
                    this.cache.put(input, output);
                    s = reader.readLine();
                }
                reader.close();
            }
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void writeCache() {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(cacheLocation)));
            for (String input : this.cache.keySet()) {
                writer.println(input + "\t" + this.cache.get(input));
            }
            writer.close();
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public boolean containsKey(String input) {
        return this.cache.containsKey(input);
    }

    public String get(String input) {
        return this.cache.get(input);
    }

    public void put(String input, String output) {
        this.cache.put(input, output);
    }

    public int size() {
        return this.cache.size();
    }
}

