/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.annotation.spotter;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.qa.annotation.spotter.ASpotter;
import org.aksw.qa.commons.datastructure.Entity;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFReader;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fox
extends ASpotter {
    static Logger log = LoggerFactory.getLogger(Fox.class);
    private String requestURL = "http://fox.cs.uni-paderborn.de:4444/fox";
    private String outputFormat = "N-Triples";
    private String taskType = "ner";
    private String inputType = "text";

    private String doTask(String inputText) {
        String urlParameters = "type=" + this.inputType;
        urlParameters = urlParameters + "&task=" + this.taskType;
        urlParameters = urlParameters + "&output=" + this.outputFormat;
        try {
            urlParameters = urlParameters + "&input=" + URLEncoder.encode(inputText, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.debug("", (Throwable)e);
        }
        return this.requestPOST(urlParameters, this.requestURL);
    }

    public Map<String, List<Entity>> getEntities(String question) {
        HashMap<String, List<Entity>> mappedEntitysReturn = new HashMap<String, List<Entity>>();
        String foxJSONOutput = null;
        foxJSONOutput = this.doTask(question);
        if (!foxJSONOutput.equals("") && foxJSONOutput != null) {
            try {
                JSONParser parser = new JSONParser();
                JSONObject jsonArray = (JSONObject)parser.parse(foxJSONOutput);
                String output = URLDecoder.decode((String)jsonArray.get((Object)"output"), "UTF-8");
                String baseURI = "http://dbpedia.org";
                Model model = ModelFactory.createDefaultModel();
                RDFReader r = model.getReader("N3");
                r.read(model, (Reader)new StringReader(output), baseURI);
                ResIterator iter = model.listSubjects();
                ArrayList<Entity> tmpList = new ArrayList<Entity>();
                while (iter.hasNext()) {
                    Resource next = (Resource)iter.next();
                    StmtIterator statementIter = next.listProperties();
                    Entity ent = new Entity();
                    while (statementIter.hasNext()) {
                        Statement statement = (Statement)statementIter.next();
                        String predicateURI = statement.getPredicate().getURI();
                        if (predicateURI.equals("http://www.w3.org/2000/10/annotation-ns#body")) {
                            ent.setLabel(statement.getObject().asLiteral().getString());
                            continue;
                        }
                        if (predicateURI.equals("http://ns.aksw.org/scms/means")) {
                            String uri = statement.getObject().asResource().getURI();
                            String encode = uri.replaceAll(",", "%2C");
                            ResourceImpl e = new ResourceImpl(encode);
                            ent.getUris().add(e);
                            continue;
                        }
                        if (!predicateURI.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) continue;
                        ent.getPosTypesAndCategories().add(statement.getObject().asResource());
                    }
                    ent.setOffset(question.indexOf(ent.getLabel()));
                    tmpList.add(ent);
                }
                mappedEntitysReturn.put("en", tmpList);
            }
            catch (IOException | ParseException e) {
                log.error("Could not parse Server rensponse", e);
            }
        }
        if (!mappedEntitysReturn.isEmpty()) {
            log.debug("\t" + Joiner.on((String)"\n").join((Iterable)mappedEntitysReturn.get("en")));
        }
        return mappedEntitysReturn;
    }
}

