/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.annotation.webservice;

import org.aksw.qa.annotation.index.IndexDBO;
import org.aksw.qa.annotation.index.IndexDBO_properties;
import org.aksw.qa.annotation.util.NifEverything;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/property"})
public class ClassDBO_PropertyRequest {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IndexDBO_properties properties;
    private NifEverything nif = NifEverything.getInstance();

    public ClassDBO_PropertyRequest() {
        this.properties = new IndexDBO_properties();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String getProperty(@RequestParam(value="q") String q) {
        this.logger.debug("Requesting PROPERTY search for term (VIA GET) :|" + q + "|");
        return this.nif.createNIFResultFromIndexDBO(q, (IndexDBO)this.properties, NifEverything.NifProperty.TAIDENTREF);
    }

    @RequestMapping(method={RequestMethod.POST})
    public String postProperty(@RequestBody String input) {
        this.logger.debug("Requesting PROPERTY search for term (VIA POST) ");
        this.logger.trace("|" + input + "|");
        return this.nif.appendNIFResultFromIndexDBO(input, (IndexDBO)this.properties, NifEverything.NifProperty.TAIDENTREF);
    }
}

