/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.annotation.sparql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.aksw.qa.commons.sparql.SPARQL;
import org.apache.jena.ext.com.google.common.collect.Iterables;
import org.apache.jena.rdf.model.RDFNode;

public class SimpleQuantityRanker {
    private SPARQL sparql = new SPARQL();
    private static final String DBPEDIA_ONTO_URI = "http://dbpedia.org/ontology/";

    public String rank(Collection<String> uris) {
        HashMap<Integer, String> uriToQuantity = new HashMap<Integer, String>();
        for (String it : uris) {
            ArrayList answers = new ArrayList(this.sparql.sparql(this.constructQuery(it)));
            System.out.println(this.constructQuery(it));
            RDFNode node = (RDFNode)answers.get(0);
            uriToQuantity.put((Integer)node.asLiteral().getValue(), it);
        }
        ArrayList sorted = new ArrayList(uriToQuantity.keySet());
        Collections.sort(sorted);
        return (String)uriToQuantity.get(Iterables.getLast(sorted));
    }

    private String constructQuery(String uri) {
        if (this.disambiguateOntologyIsProperty(uri)) {
            return "SELECT(count(*) AS ?proj)  {?x <" + uri + "> ?y . }";
        }
        if (this.disambiguateOntologyIsClass(uri)) {
            return "SELECT (count(*) AS ?proj) {?x a  <" + uri + "> .  }";
        }
        return null;
    }

    public boolean disambiguateOntologyIsProperty(String uri) {
        Character character = Character.valueOf(uri.charAt(DBPEDIA_ONTO_URI.length()));
        return uri.startsWith(DBPEDIA_ONTO_URI) && Character.isLowerCase(character.charValue());
    }

    public boolean disambiguateOntologyIsClass(String uri) {
        Character character = Character.valueOf(uri.charAt(DBPEDIA_ONTO_URI.length()));
        return uri.startsWith(DBPEDIA_ONTO_URI) && Character.isUpperCase(character.charValue());
    }
}

