/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.annotation.index;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.aksw.qa.annotation.index.IndexDBO;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDFS;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexDBO_classes
extends IndexDBO {
    private static final Version LUCENE_VERSION = Version.LUCENE_46;
    private Logger log = LoggerFactory.getLogger(IndexDBO_classes.class);
    public String FIELD_NAME_SUBJECT = "subject";
    public String FIELD_NAME_PREDICATE = "predicate";
    public String FIELD_NAME_OBJECT = "object";
    private int numberOfDocsRetrievedFromIndex = 100;
    private Directory directory;
    private IndexSearcher isearcher;
    private DirectoryReader ireader;
    private IndexWriter iwriter;
    private SimpleAnalyzer analyzer;

    public IndexDBO_classes() {
        try {
            File index = new File("resources/ontologyClasses");
            this.analyzer = new SimpleAnalyzer(LUCENE_VERSION);
            if (!index.exists() || index.list().length < 2) {
                index.mkdir();
                IndexWriterConfig config = new IndexWriterConfig(LUCENE_VERSION, (Analyzer)this.analyzer);
                this.directory = new MMapDirectory(index);
                this.iwriter = new IndexWriter(this.directory, config);
                this.index();
            } else {
                this.directory = new MMapDirectory(index);
            }
            this.ireader = DirectoryReader.open((Directory)this.directory);
            this.isearcher = new IndexSearcher((IndexReader)this.ireader);
        }
        catch (IOException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public List<String> search(String object) {
        if (stopwords.contains(object.toLowerCase())) {
            this.log.debug("\t Stopword detected: |" + object + "|");
            return ImmutableList.of();
        }
        ArrayList uris = Lists.newArrayList();
        try {
            ScoreDoc[] hits;
            this.log.debug("\t start asking index...");
            FuzzyQuery q = new FuzzyQuery(new Term(this.FIELD_NAME_OBJECT, object), 0);
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)this.numberOfDocsRetrievedFromIndex, (boolean)true);
            this.isearcher.search((Query)q, (Collector)collector);
            for (ScoreDoc hit : hits = collector.topDocs().scoreDocs) {
                Document hitDoc = this.isearcher.doc(hit.doc);
                uris.add(hitDoc.get(this.FIELD_NAME_SUBJECT));
            }
            this.log.debug("\t finished asking index...");
        }
        catch (Exception e) {
            this.log.error(e.getLocalizedMessage() + " -> " + object, (Throwable)e);
        }
        return uris;
    }

    public void close() {
        try {
            this.ireader.close();
            this.directory.close();
        }
        catch (IOException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void index() {
        try {
            InputStream res = this.getClass().getResourceAsStream("/dbpedia_3Eng_class.ttl");
            Model model = ModelFactory.createDefaultModel();
            model.read(res, "http://dbpedia.org/", "TTL");
            StmtIterator stmts = model.listStatements(null, RDFS.label, (RDFNode)null);
            while (stmts.hasNext()) {
                Statement stmt = (Statement)stmts.next();
                RDFNode label = stmt.getObject();
                this.addDocumentToIndex(stmt.getSubject(), "rdfs:label", label.asLiteral().getString());
            }
            this.iwriter.commit();
            this.iwriter.close();
        }
        catch (IOException e) {
            this.log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void addDocumentToIndex(Resource resource, String predicate, String object) throws IOException {
        Document doc = new Document();
        doc.add((IndexableField)new StringField(this.FIELD_NAME_SUBJECT, resource.getURI(), Field.Store.YES));
        doc.add((IndexableField)new StringField(this.FIELD_NAME_PREDICATE, predicate, Field.Store.YES));
        doc.add((IndexableField)new TextField(this.FIELD_NAME_OBJECT, object, Field.Store.YES));
        this.iwriter.addDocument((Iterable)doc);
    }
}

