/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.annotation.webservice;

import org.aksw.qa.annotation.spotter.ASpotter;
import org.aksw.qa.annotation.spotter.Fox;
import org.aksw.qa.annotation.util.NifEverything;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fox"})
public class Spotter_FoxRequest {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Fox fox;
    private NifEverything nif = NifEverything.getInstance();

    public Spotter_FoxRequest() {
        this.fox = new Fox();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String getFox(@RequestParam(value="q") String q) {
        this.logger.debug("Requesting NER/FOX for term (VIA GET) :|" + q + "|");
        return this.nif.createNIFResultFromSpotters(q, (ASpotter)this.fox);
    }

    @RequestMapping(method={RequestMethod.POST})
    public String postFox(@RequestBody String input) {
        this.logger.debug("Requesting NER/FOX search for term (VIA POST)");
        this.logger.trace("|" + input + "|");
        return this.nif.appendNIFResultFromSpotters(input, (ASpotter)this.fox);
    }
}

