/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.annotation.webservice;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.aksw.gerbil.transfer.nif.Document;
import org.aksw.gerbil.transfer.nif.Marking;
import org.aksw.gerbil.transfer.nif.Span;
import org.aksw.gerbil.transfer.nif.data.DocumentImpl;
import org.aksw.qa.annotation.util.AgdistisJson;
import org.aksw.qa.annotation.util.NifEverything;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/agdistis"})
public class AgdistisWrapper {
    private NifEverything nif = NifEverything.getInstance();
    private static final String AGDISTIS_URL = "http://139.18.2.164:8080/AGDISTIS";
    final Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(method={RequestMethod.GET})
    public String getAgdistis() {
        this.logger.debug("Requesting AGDISTIS VIA GET - forbidden");
        return "GET forbidden";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String postAgdistis(@RequestBody String input) {
        this.logger.debug("Requesting agdistis search  (VIA POST)");
        this.logger.trace("|" + input + "|");
        return this.process(input);
    }

    public String process(String input) {
        List docs;
        try {
            docs = this.nif.parseNIF(input);
        }
        catch (Exception e) {
            return "Given input not parsable or nothing found";
        }
        ArrayList<DocumentImpl> answerDocs = new ArrayList<DocumentImpl>();
        for (Document doc : docs) {
            DocumentImpl answerDoc = new DocumentImpl(doc.getText());
            List resultMarkings = this.requestForStringAgdistis(this.createAgdistisString(doc));
            this.nif.addAllMarkingsToDoc((Document)answerDoc, (Collection)resultMarkings);
            answerDocs.add(answerDoc);
        }
        return this.nif.writeNIF(answerDocs);
    }

    private String agdistisPost(String input) throws IOException {
        String body = "text=" + URLEncoder.encode("'" + input + "'", "UTF-8") + "&type=agdistis";
        URL url = new URL(AGDISTIS_URL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty("Content-Length", String.valueOf(body.length()));
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
        writer.write(body);
        writer.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder out = new StringBuilder();
        int i = reader.read();
        while (i != -1) {
            out.append((char)i);
            i = reader.read();
        }
        writer.close();
        reader.close();
        return out.toString();
    }

    public List<Marking> requestForStringAgdistis(String sentence) {
        ArrayList<Marking> ret = new ArrayList<Marking>();
        String agdistisReturn = null;
        try {
            agdistisReturn = this.agdistisPost(sentence);
        }
        catch (IOException e) {
            this.logger.info("Prolem reaching AGDISITS", (Throwable)e);
            return new ArrayList<Marking>();
        }
        ObjectMapper mapper = new ObjectMapper();
        CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, AgdistisJson.class);
        List returnList = new ArrayList();
        try {
            returnList = (List)mapper.readValue(agdistisReturn, (JavaType)type);
        }
        catch (IOException e) {
            this.logger.info("Prolem parsing AGDISTIS results", (Throwable)e);
        }
        for (AgdistisJson result : returnList) {
            Marking span = NifEverything.NifProperty.TAIDENTREF.getInstanceWith(result.getStart() - 1, result.getOffset(), new ArrayList<String>(Arrays.asList(result.getDisambiguatedURL())));
            ret.add(span);
        }
        return ret;
    }

    public String createAgdistisString(Document doc) {
        ArrayList<Span> spans = new ArrayList<Span>();
        for (Span span : doc.getMarkings(Span.class)) {
            if (!span.getIsWord()) continue;
            spans.add(span);
        }
        Collections.sort(spans, new /* Unavailable Anonymous Inner Class!! */);
        ArrayList notProcessedSpans = new ArrayList(spans);
        StringBuilder docStr = new StringBuilder(doc.getText());
        for (Span span : spans) {
            notProcessedSpans.remove(span);
            int spanStart = span.getStartPosition();
            int spanLength = span.getLength();
            String word = docStr.substring(spanStart, spanStart + spanLength);
            String insertionString = "<entity>" + word + "</entity>";
            int offsetForFollowing = insertionString.length() - word.length();
            for (Span it : notProcessedSpans) {
                it.setStartPosition(it.getStartPosition() + offsetForFollowing);
            }
            docStr.replace(spanStart, spanStart + spanLength, insertionString);
        }
        return docStr.toString();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Started agdistis wrapper");
        AgdistisWrapper wrapper = new AgdistisWrapper();
        System.out.println("|" + wrapper.agdistisPost("<entity>Barack Obama</entity> arrives in <entity>Washington, D.C.</entity>.") + "|");
    }
}

