/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.qa.annotation.spotter;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.qa.annotation.spotter.ASpotter;
import org.aksw.qa.commons.datastructure.Entity;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Spotlight
extends ASpotter {
    static Logger log = LoggerFactory.getLogger(Spotlight.class);
    private String requestURL = "http://spotlight.sztaki.hu:2222/rest/annotate";
    private String confidence = "0.65";
    private String support = "20";

    private String doTASK(String inputText) throws MalformedURLException, IOException, ProtocolException {
        String urlParameters = "text=" + URLEncoder.encode(inputText, "UTF-8");
        urlParameters = urlParameters + "&confidence=" + this.confidence;
        urlParameters = urlParameters + "&support=" + this.support;
        return this.requestPOST(urlParameters, this.requestURL);
    }

    public Map<String, List<Entity>> getEntities(String question) {
        HashMap<String, List<Entity>> tmp = new HashMap<String, List<Entity>>();
        try {
            String foxJSONOutput = this.doTASK(question);
            JSONParser parser = new JSONParser();
            JSONObject jsonObject = (JSONObject)parser.parse(foxJSONOutput);
            JSONArray resources = (JSONArray)jsonObject.get((Object)"Resources");
            if (resources != null) {
                ArrayList<Entity> tmpList = new ArrayList<Entity>();
                for (Object res : resources.toArray()) {
                    JSONObject next = (JSONObject)res;
                    Entity ent = new Entity();
                    ent.setOffset(Integer.valueOf((String)next.get((Object)"@offset")).intValue());
                    ent.setLabel((String)next.get((Object)"@surfaceForm"));
                    String uri = ((String)next.get((Object)"@URI")).replaceAll(",", "%2C");
                    ent.getUris().add(new ResourceImpl(uri));
                    for (String type : ((String)next.get((Object)"@types")).split(",")) {
                        ent.getPosTypesAndCategories().add(new ResourceImpl(type));
                    }
                    tmpList.add(ent);
                }
                tmp.put("en", tmpList);
            }
        }
        catch (IOException | ParseException e) {
            log.error("Could not call Spotlight for NER/NED", e);
        }
        return tmp;
    }

    public String getConfidence() {
        return this.confidence;
    }

    public void setConfidence(double i) {
        this.confidence = String.valueOf(i);
    }

    public String getSupport() {
        return this.support;
    }

    public void setSupport(String support) {
        this.support = support;
    }
}

