/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.openqa.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertyLoaderUtil {
    private static Logger logger = Logger.getLogger(PropertyLoaderUtil.class);

    public static Map<String, Object> getProperties(Class<?> clazz, String filePath) {
        Map<String, Object> params = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inStream = clazz.getResourceAsStream(filePath);){
                if (inStream != null) {
                    params = PropertyLoaderUtil.loadParams(inStream);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error initializing component params:" + clazz.getName()), (Throwable)e);
        }
        return params;
    }

    public static Map<String, Object> getPropertiesWithWhiteSpaceFromFile(String filePath) {
        Map<String, Object> params;
        block12: {
            params = null;
            try {
                File f = new File(filePath);
                if (!f.exists()) break block12;
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileReader fileReader = new FileReader(f);){
                    if (fileReader != null) {
                        params = PropertyLoaderUtil.loadParamsWithWhiteSpace(fileReader);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error loading params:" + filePath), (Throwable)e);
            }
        }
        return params;
    }

    public static Map<String, Object> getPropertiesFromFile(String filePath) {
        Map<String, Object> params;
        block12: {
            params = null;
            try {
                File f = new File(filePath);
                if (!f.exists()) break block12;
                Throwable throwable = null;
                Object var4_6 = null;
                try (FileInputStream inStream = new FileInputStream(filePath);){
                    if (inStream != null) {
                        params = PropertyLoaderUtil.loadParams(inStream);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error loading params:" + filePath), (Throwable)e);
            }
        }
        return params;
    }

    protected static Map<String, Object> loadParamsWithWhiteSpace(FileReader fileReader) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (fileReader != null) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    String[] attr = line.split("=");
                    params.put(attr[0].trim(), attr[1].trim());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return params;
    }

    protected static Map<String, Object> loadParams(InputStream is) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Properties prop = new Properties();
        if (is != null) {
            prop.load(is);
            for (Object key : prop.keySet()) {
                params.put((String)key, prop.get(key));
            }
        }
        return params;
    }
}

