/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.openqa.qald;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.aksw.openqa.qald.QuestionResult;

public class QALDBenchmarkResult
extends ArrayList<QuestionResult> {
    private static final long serialVersionUID = 7694073500728608223L;

    public double getPrecision() {
        if (this.size() == 0) {
            return 0.0;
        }
        double precision = 0.0;
        for (QuestionResult qResult : this) {
            precision += qResult.getPrecision();
        }
        return precision / (double)this.size();
    }

    public double getRecall() {
        if (this.size() == 0) {
            return 0.0;
        }
        double recall = 0.0;
        for (QuestionResult qResult : this) {
            recall += qResult.getRecall();
        }
        return recall / (double)this.size();
    }

    public double getFmeasure() {
        if (this.size() == 0) {
            return 0.0;
        }
        double fmeasure = 0.0;
        for (QuestionResult qResult : this) {
            fmeasure += qResult.getFmeasure();
        }
        return fmeasure / (double)this.size();
    }

    public int getPartialAnsweredQueries() {
        int partial = 0;
        for (QuestionResult qResult : this) {
            if (!(qResult.getRecall() > 0.0) || !(qResult.getRecall() < 1.0)) continue;
            ++partial;
        }
        return partial;
    }

    public int getFullAnsweredQueries() {
        int full = 0;
        for (QuestionResult qResult : this) {
            if (qResult.getRecall() != 1.0) continue;
            ++full;
        }
        return full;
    }

    @Override
    public String toString() {
        String result = "";
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (PrintStream ps = new PrintStream(baos);){
                    for (QuestionResult qResult : this) {
                        ps.println(qResult.toString());
                    }
                    ps.println("Recall:" + this.getRecall() + " Precision:" + this.getPrecision() + " F-measure:" + this.getFmeasure() + " Fully Answered Queries:" + this.getFullAnsweredQueries() + " Partial Answered Queries:" + this.getFullAnsweredQueries());
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                result = baos.toString();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

