/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.openqa.qald;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.aksw.openqa.AnswerFormulation;
import org.aksw.openqa.component.param.IResultMap;
import org.aksw.openqa.component.param.IResultMapList;
import org.aksw.openqa.main.ProcessResult;
import org.aksw.openqa.main.QueryResult;
import org.aksw.openqa.manager.plugin.PluginManager;
import org.aksw.openqa.qald.EvaluationUtils;
import org.aksw.openqa.qald.QALDBenchmarkResult;
import org.aksw.openqa.qald.QuestionResult;
import org.aksw.openqa.qald.schema.Answer;
import org.aksw.openqa.qald.schema.Answers;
import org.aksw.openqa.qald.schema.Dataset;
import org.aksw.openqa.qald.schema.Keywords;
import org.aksw.openqa.qald.schema.Question;
import org.aksw.openqa.qald.schema.String;
import org.aksw.openqa.util.JAXBUtil;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class QALDBenchmark {
    private static Logger logger = Logger.getLogger(QALDBenchmark.class);
    private static final java.lang.String OUT_OF_SCOPE_MESSAGE = " OUT OF SCOPE ";

    public static void serialize(Dataset dataset, File outputFile) throws Exception {
        FileOutputStream fout = new FileOutputStream(outputFile);
        JAXBUtil.serialize(Dataset.class, dataset, fout, "string keywords query");
    }

    public static Dataset deserialize(File qaldFile) throws Exception {
        Dataset dataset = JAXBUtil.deserialize(Dataset.class, qaldFile);
        return dataset;
    }

    public void evaluate(File qaldFile, File outputFile, java.lang.String lang, java.lang.String queryType, PluginManager pluginManager) throws Exception {
        Dataset dataset = this.evaluate(qaldFile, lang, queryType, pluginManager);
        QALDBenchmark.serialize(dataset, outputFile);
    }

    public Dataset evaluate(File qaldTest, java.lang.String lang, java.lang.String queryType, PluginManager pluginManager) throws ParserConfigurationException, SAXException, IOException, JAXBException {
        Dataset dataset = JAXBUtil.deserialize(Dataset.class, qaldTest);
        logger.debug((Object)("Running tests for dataset " + dataset.getId()));
        List<Question> questions = dataset.getQuestion();
        for (Question question : questions) {
            this.evaluate(question, lang, queryType, pluginManager);
        }
        return dataset;
    }

    public void evaluate(Question question, java.lang.String lang, java.lang.String queryType, PluginManager pluginManager) throws ParserConfigurationException, SAXException, IOException, JAXBException {
        logger.debug((Object)("Running test for Question " + question.getId()));
        if (queryType.contains("keywords")) {
            List<Keywords> stringElements = question.getKeywords();
            for (Keywords query : stringElements) {
                if (lang != null && !query.getLang().equals(lang)) continue;
                java.lang.String queryValue = query.getValue();
                logger.debug((Object)("Running query: " + queryValue));
                try {
                    AnswerFormulation queryProcessor = new AnswerFormulation();
                    QueryResult result = queryProcessor.process(queryValue, pluginManager);
                    IResultMapList<? extends IResultMap> queryParserResults = result.getParam("QueryResult.QUERYPARSING_RESULT", ProcessResult.class).getOutput();
                    java.lang.String generatedQueries = QALDBenchmark.queryParserResultsToString(queryParserResults);
                    question.setQuery(generatedQueries);
                    IResultMapList<? extends IResultMap> entryResults = result.getOutput();
                    if (entryResults == null) continue;
                    question.setAnswers(this.getAnswers(entryResults));
                }
                catch (Exception e) {
                    logger.error((Object)("Erro executing query: " + queryValue), (Throwable)e);
                }
            }
        } else {
            List<String> stringElements = question.getString();
            for (String query : stringElements) {
                if (lang != null && !query.getLang().equals(lang)) continue;
                java.lang.String queryValue = query.getValue();
                logger.debug((Object)("Running query: " + queryValue));
                try {
                    AnswerFormulation queryProcessor = new AnswerFormulation();
                    QueryResult result = queryProcessor.process(queryValue, pluginManager);
                    IResultMapList<? extends IResultMap> queryParserResults = result.getParam("QueryResult.QUERYPARSING_RESULT", ProcessResult.class).getOutput();
                    java.lang.String generatedQueries = QALDBenchmark.queryParserResultsToString(queryParserResults);
                    question.setQuery(generatedQueries);
                    IResultMapList<? extends IResultMap> entryResults = result.getOutput();
                    if (entryResults == null) continue;
                    question.setAnswers(this.getAnswers(entryResults));
                }
                catch (Exception e) {
                    logger.error((Object)("Erro executing query: " + queryValue), (Throwable)e);
                }
            }
        }
    }

    public static java.lang.String queryParserResultsToString(List<? extends IResultMap> queryParserResults) {
        java.lang.String sparqlQueriesAnswer = null;
        if (queryParserResults != null && queryParserResults.size() > 0) {
            for (IResultMap iResultMap : queryParserResults) {
                java.lang.String sparqlParam = (java.lang.String)iResultMap.getParam("SPARQL_PARAM");
                if (sparqlParam == null) continue;
                sparqlQueriesAnswer = sparqlQueriesAnswer != null ? java.lang.String.valueOf(sparqlQueriesAnswer) + sparqlParam + ";" : java.lang.String.valueOf(sparqlParam) + ";";
            }
        }
        if (sparqlQueriesAnswer == null) {
            sparqlQueriesAnswer = OUT_OF_SCOPE_MESSAGE;
        }
        return sparqlQueriesAnswer;
    }

    public static QALDBenchmarkResult evaluate(File actualAnwersFile, File expectedAnswersFile) throws Exception {
        Dataset yourDataset = QALDBenchmark.deserialize(actualAnwersFile);
        Dataset targetDataset = QALDBenchmark.deserialize(expectedAnswersFile);
        return QALDBenchmark.evaluate(yourDataset, targetDataset);
    }

    public static QALDBenchmarkResult evaluate(Dataset actual, Dataset expected) throws Exception {
        QALDBenchmarkResult qaldBenchmarkResult = new QALDBenchmarkResult();
        List<Question> givenAnswers = actual.getQuestion();
        List<Question> targetAnswers = expected.getQuestion();
        for (Question targetQ : targetAnswers) {
            Question answeredQuestion = QALDBenchmark.locateQuestion(targetQ.getId(), givenAnswers);
            QuestionResult qResult = new QuestionResult();
            if (answeredQuestion != null) {
                qResult = QALDBenchmark.evaluate(answeredQuestion, targetQ);
            }
            qaldBenchmarkResult.add(qResult);
        }
        return qaldBenchmarkResult;
    }

    public static QuestionResult evaluate(Question actual, Question expected) throws Exception {
        QuestionResult qResult = new QuestionResult();
        double precision = EvaluationUtils.precision(expected, actual);
        double fmeasure = EvaluationUtils.fMeasure(expected, actual);
        double recall = EvaluationUtils.recall(expected, actual);
        qResult.setFmeasure(fmeasure);
        qResult.setRecal(recall);
        qResult.setPrecison(precision);
        return qResult;
    }

    private static Question locateQuestion(java.lang.String id, List<Question> questions) {
        for (Question question : questions) {
            if (!question.getId().equals(id)) continue;
            return question;
        }
        return null;
    }

    private Answers getAnswers(List<? extends IResultMap> entryResults) {
        Answers answers = new Answers();
        for (IResultMap iResultMap : entryResults) {
            java.lang.String attrValue = null;
            Answer answer = null;
            if (iResultMap.contains("URI_PARAM")) {
                attrValue = (java.lang.String)iResultMap.getParam("URI_PARAM");
                answer = new Answer();
                answer.setUri(attrValue);
            } else if (iResultMap.contains("LITERAL_NUMBER_PARAM")) {
                attrValue = iResultMap.getParam("LITERAL_NUMBER_PARAM").toString();
                answer = new Answer();
                answer.setNumber(attrValue);
            } else if (iResultMap.contains("LITERAL_DATE_PARAM")) {
                attrValue = (java.lang.String)iResultMap.getParam("LITERAL_DATE_PARAM");
                answer = new Answer();
                answer.setDate(attrValue);
            } else if (iResultMap.contains("LITERAL_BOOLEAN_PARAM")) {
                attrValue = (java.lang.String)iResultMap.getParam("LITERAL_BOOLEAN_PARAM");
                answer = new Answer();
                answer.setBoolean(attrValue);
            } else if (iResultMap.contains("RESOURCE_PARAM")) {
                attrValue = (java.lang.String)iResultMap.getParam("RESOURCE_PARAM");
                answer = new Answer();
                answer.setUri(attrValue);
            }
            if (answer == null) continue;
            answers.getAnswer().add(answer);
        }
        return answers;
    }
}

