/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.openqa.qald;

import java.util.HashSet;
import java.util.List;
import org.aksw.openqa.qald.schema.Answer;
import org.aksw.openqa.qald.schema.Question;

public class EvaluationUtils {
    public static double precision(Question expected, Question actual) {
        double precision = 0.0;
        List<Answer> targetAnswerList = expected.getAnswers().getAnswer();
        List<Answer> givenAnswerList = actual.getAnswers().getAnswer();
        if (targetAnswerList.size() == 0 && givenAnswerList.size() == 0) {
            return 1.0;
        }
        HashSet<Answer> intersectionAnswerSet = new HashSet<Answer>(targetAnswerList);
        HashSet<Answer> givenAnswerSet = new HashSet<Answer>(givenAnswerList);
        intersectionAnswerSet.retainAll(givenAnswerSet);
        if (givenAnswerSet.size() == 0) {
            return 0.0;
        }
        precision = (double)intersectionAnswerSet.size() / (double)givenAnswerSet.size();
        return precision;
    }

    public static double recall(Question expected, Question actual) {
        double precision = 0.0;
        List<Answer> targetAnswerList = expected.getAnswers().getAnswer();
        List<Answer> givenAnswerList = actual.getAnswers().getAnswer();
        if (targetAnswerList.size() == 0 && givenAnswerList.size() == 0) {
            return 1.0;
        }
        HashSet<Answer> expectedAnswerSet = new HashSet<Answer>(targetAnswerList);
        HashSet<Answer> intersectionAnswerSet = new HashSet<Answer>(targetAnswerList);
        HashSet<Answer> actualAnswerSet = new HashSet<Answer>(givenAnswerList);
        intersectionAnswerSet.retainAll(actualAnswerSet);
        if (expectedAnswerSet.size() == 0) {
            return 0.0;
        }
        precision = (double)intersectionAnswerSet.size() / (double)expectedAnswerSet.size();
        return precision;
    }

    public static double fMeasure(Question expected, Question actual) {
        double precision = EvaluationUtils.precision(expected, actual);
        double recall = EvaluationUtils.recall(expected, actual);
        double fMeasure = 0.0;
        if (precision + recall > 0.0) {
            fMeasure = 2.0 * precision * recall / (precision + recall);
        }
        return fMeasure;
    }
}

