/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.openqa.manager.plugin;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.openqa.PersistentContextParams;
import org.aksw.openqa.component.IPlugin;
import org.aksw.openqa.component.IPluginVisitor;
import org.aksw.openqa.component.IProcess;
import org.aksw.openqa.component.IProvider;
import org.aksw.openqa.component.ISpecializedPluginVisitor;
import org.aksw.openqa.component.answerformulation.IQueryParser;
import org.aksw.openqa.component.answerformulation.IRetriever;
import org.aksw.openqa.component.answerformulation.ISynthesizer;
import org.aksw.openqa.component.context.IContext;
import org.aksw.openqa.component.providers.impl.ContextProvider;
import org.aksw.openqa.component.providers.impl.QueryParserProvider;
import org.aksw.openqa.component.providers.impl.RetrieverProvider;
import org.aksw.openqa.component.providers.impl.ServiceProvider;
import org.aksw.openqa.component.providers.impl.SynthesizerProvider;
import org.aksw.openqa.component.service.IService;
import org.aksw.openqa.util.PropertyLoaderUtil;
import org.aksw.openqa.util.ZIPUtil;
import org.apache.log4j.Logger;

public class PluginManager
extends PropertyLoaderUtil {
    private static Logger logger = Logger.getLogger(PluginManager.class);
    private static final String ACTIVE = "ACTIVE";
    private static final String CONTEXT_DIR = "context";
    private File pluginDir = null;
    private ClassLoader parent;
    ServiceProvider serviceProvider;
    QueryParserProvider queryParserProvider;
    RetrieverProvider retrieverProvider;
    SynthesizerProvider synthesizerProvider;
    ContextProvider contextProvider;
    PersistentContextParams persistentContextParams = null;
    RegisterVisitor registerVisitor = new RegisterVisitor();
    UnregisterVisitor unregisterVisitor = new UnregisterVisitor();
    Map<Class<? extends IProvider<? extends IPlugin>>, IProvider<? extends IPlugin>> providers = new HashMap<Class<? extends IProvider<? extends IPlugin>>, IProvider<? extends IPlugin>>();

    public PluginManager(String pluginDir, ClassLoader parent, String appContext, IPlugin ... plugins) {
        this.parent = parent;
        this.pluginDir = new File(pluginDir);
        File contextDir = new File(String.valueOf(pluginDir) + "/" + CONTEXT_DIR);
        if (!contextDir.exists()) {
            contextDir.mkdir();
        }
        this.persistentContextParams = new PersistentContextParams(String.valueOf(pluginDir) + "/" + CONTEXT_DIR, appContext);
        this.load();
        IPlugin[] iPluginArray = plugins;
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            IPlugin plugin = iPluginArray[n2];
            this.unregister(plugin);
            this.register(plugin);
            ++n2;
        }
    }

    public PluginManager(String plugginDir, ClassLoader parent, String appContext) {
        this.parent = parent;
        this.pluginDir = new File(plugginDir);
        File contextDir = new File(String.valueOf(plugginDir) + "/" + CONTEXT_DIR);
        if (!contextDir.exists()) {
            contextDir.mkdir();
        }
        this.persistentContextParams = new PersistentContextParams(String.valueOf(plugginDir) + "/" + CONTEXT_DIR, appContext);
        this.load();
    }

    public PluginManager(String plugginDir, ClassLoader parent) {
        this.parent = parent;
        this.pluginDir = new File(plugginDir);
        this.load();
    }

    public PluginManager(ClassLoader parent, String appContext) {
        this.parent = parent;
        this.persistentContextParams = new PersistentContextParams(appContext);
        this.load();
    }

    public PluginManager(ClassLoader parent) {
        this.parent = parent;
        this.load();
    }

    public PluginManager(String appContext) {
        this.parent = Thread.currentThread().getContextClassLoader();
        this.persistentContextParams = new PersistentContextParams(appContext);
        this.load();
    }

    public PluginManager() {
        this.parent = Thread.currentThread().getContextClassLoader();
        this.load();
    }

    private void deploy() {
        if (this.pluginDir != null) {
            File[] directories = this.pluginDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            ArrayList<String> directoryNames = new ArrayList<String>();
            File[] fileArray = directories;
            int n = directories.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                directoryNames.add(String.valueOf(dir.getAbsolutePath()) + ".par");
                ++n2;
            }
            File[] parFiles = this.pluginDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().endsWith(".par");
                }
            });
            ArrayList<String> parFileNameList = new ArrayList<String>();
            File[] fileArray2 = parFiles;
            int n3 = parFiles.length;
            int n4 = 0;
            while (n4 < n3) {
                File parFile = fileArray2[n4];
                String absolutePath = parFile.getAbsolutePath();
                parFileNameList.add(absolutePath);
                ++n4;
            }
            parFileNameList.removeAll(directoryNames);
            for (String parFile : parFileNameList) {
                String destDirName = parFile.substring(0, parFile.length() - 4);
                File destDir = new File(destDirName);
                destDir.mkdir();
                ZIPUtil.unzip(parFile, destDir.getAbsolutePath());
            }
        }
    }

    private void load() {
        File[] directories;
        logger.debug((Object)"Deploying existing PAR files...");
        this.deploy();
        logger.debug((Object)"Loading plug-ins...");
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        classLoaders.add(this.parent);
        if (this.pluginDir != null && (directories = this.pluginDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) != null) {
            File[] fileArray = directories;
            int n = directories.length;
            int n2 = 0;
            while (n2 < n) {
                File directory = fileArray[n2];
                File[] flist = directory.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.getPath().toLowerCase().endsWith(".jar");
                    }
                });
                URL[] urls = new URL[flist.length];
                int i = 0;
                while (i < flist.length) {
                    try {
                        urls[i] = flist[i].toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        logger.error((Object)"Error in URI format", (Throwable)e);
                    }
                    ++i;
                }
                if (urls.length > 0) {
                    URLClassLoader ucl = new URLClassLoader(urls, this.parent);
                    classLoaders.add(ucl);
                }
                ++n2;
            }
        }
        this.serviceProvider = new ServiceProvider(classLoaders);
        this.providers.put(ServiceProvider.class, this.serviceProvider);
        this.queryParserProvider = new QueryParserProvider(classLoaders, this.serviceProvider);
        this.providers.put(QueryParserProvider.class, this.queryParserProvider);
        this.retrieverProvider = new RetrieverProvider(classLoaders, this.serviceProvider);
        this.providers.put(RetrieverProvider.class, this.retrieverProvider);
        this.synthesizerProvider = new SynthesizerProvider(classLoaders, this.serviceProvider);
        this.providers.put(SynthesizerProvider.class, this.synthesizerProvider);
        this.contextProvider = new ContextProvider(classLoaders, this.serviceProvider);
        this.providers.put(ContextProvider.class, this.contextProvider);
        if (this.persistentContextParams != null) {
            this.visit(new ContexParamVisitor());
        }
    }

    public void register(IPlugin plugin) {
        plugin.accept(this.registerVisitor);
    }

    public void unregister(IPlugin plugin) {
        plugin.accept(this.unregisterVisitor);
    }

    public void setPluginParam(String pluginID, Map<String, Object> params) {
        this.visit(new SetParamVisitor(pluginID, params));
    }

    public void saveState() {
        this.visit(new SaveStateVisitor());
    }

    public void saveState(String pluginID) {
        this.visit(new SaveStateVisitor(pluginID));
    }

    public void setActive(boolean active) {
        this.setActive(active, null);
    }

    public void shutdown() {
        this.visit(new PluginShutdownVisitor(null));
    }

    public void setActive(boolean active, String ... ids) {
        this.visit(new PluginActivateVisitor(active, ids));
    }

    public List<? extends IPlugin> getPlugins(Class<? extends IProvider<? extends IPlugin>> providerClass) throws Exception {
        Map<Class<? extends IProvider<? extends IPlugin>>, IProvider<? extends IPlugin>> providers = this.getProviders();
        IProvider<? extends IPlugin> provider = providers.get(providerClass);
        return provider.list();
    }

    public IPlugin getPlugin(String id) {
        Map<Class<? extends IProvider<? extends IPlugin>>, IProvider<? extends IPlugin>> providers = this.getProviders();
        for (IProvider<? extends IPlugin> providerEntry : providers.values()) {
            IPlugin component = providerEntry.get(id);
            if (component == null) continue;
            return component;
        }
        return null;
    }

    public <C extends IPlugin> C getPlugin(Class<? extends IProvider<?>> providerClass, Class<C> componentClass) {
        Map<Class<? extends IProvider<? extends IPlugin>>, IProvider<? extends IPlugin>> providers = this.getProviders();
        IProvider<? extends IPlugin> provider = providers.get(providerClass);
        if (provider != null) {
            return (C)((IPlugin)provider.get(componentClass));
        }
        return null;
    }

    public <L extends IProvider<? extends IPlugin>> L getProvider(Class<L> providerClass) {
        Map<Class<? extends IProvider<? extends IPlugin>>, IProvider<? extends IPlugin>> providers = this.getProviders();
        IProvider<? extends IPlugin> provider = providers.get(providerClass);
        return (L)provider;
    }

    public IProcess getProcessProvider(String componentID) {
        if (this.queryParserProvider.getId().equals(componentID)) {
            return this.queryParserProvider;
        }
        if (this.retrieverProvider.getId().equals(componentID)) {
            return this.retrieverProvider;
        }
        if (this.synthesizerProvider.getId().equals(componentID)) {
            return this.synthesizerProvider;
        }
        return null;
    }

    private Map<Class<? extends IProvider<? extends IPlugin>>, IProvider<? extends IPlugin>> getProviders() {
        return this.providers;
    }

    public void visit(IPluginVisitor visitor) {
        Map<Class<? extends IProvider<? extends IPlugin>>, IProvider<? extends IPlugin>> providersMap = this.getProviders();
        Collection<IProvider<? extends IPlugin>> providers = providersMap.values();
        for (IProvider<? extends IPlugin> provider : providers) {
            List<? extends IPlugin> plugins = provider.list();
            for (IPlugin iPlugin : plugins) {
                iPlugin.accept(visitor);
            }
        }
    }

    private class ContexParamVisitor
    implements IPluginVisitor {
        private ContexParamVisitor() {
        }

        @Override
        public void visit(IPlugin plugin) {
            Map<String, String> params = PluginManager.this.persistentContextParams.listParams(plugin.getId());
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            newMap.putAll(params);
            newMap.remove(PluginManager.ACTIVE);
            plugin.setProperties(newMap);
            String active = params.get(PluginManager.ACTIVE);
            if (active != null) {
                plugin.setActive(active.equals("true"));
            } else {
                plugin.setActive(true);
            }
        }
    }

    private class PluginActivateVisitor
    implements IPluginVisitor {
        String[] pluginIDs;
        Boolean activate;

        public PluginActivateVisitor(boolean activate, String ... pluginIDs) {
            this.activate = activate;
            this.pluginIDs = pluginIDs;
        }

        @Override
        public void visit(IPlugin plugin) {
            List<String> idList = null;
            if (this.pluginIDs != null) {
                idList = Arrays.asList(this.pluginIDs);
            }
            if (idList == null || idList.contains(plugin.getId())) {
                plugin.setActive(this.activate);
            }
        }
    }

    private class PluginShutdownVisitor
    implements IPluginVisitor {
        String[] pluginIDs;

        public PluginShutdownVisitor(String ... pluginIDs) {
            this.pluginIDs = pluginIDs;
        }

        @Override
        public void visit(IPlugin plugin) {
            List<String> idList = null;
            if (this.pluginIDs != null) {
                idList = Arrays.asList(this.pluginIDs);
            }
            if (idList == null || idList.contains(plugin.getId())) {
                plugin.shutdown();
            }
        }
    }

    private class RegisterVisitor
    implements ISpecializedPluginVisitor {
        private RegisterVisitor() {
        }

        @Override
        public void visit(IService service) {
            PluginManager.this.serviceProvider.register(service);
        }

        @Override
        public void visit(IQueryParser interpreter) {
            PluginManager.this.queryParserProvider.register(interpreter);
        }

        @Override
        public void visit(IRetriever retriever) {
            PluginManager.this.retrieverProvider.register(retriever);
        }

        @Override
        public void visit(ISynthesizer synthesizer) {
            PluginManager.this.synthesizerProvider.register(synthesizer);
        }

        @Override
        public void visit(IContext context) {
            PluginManager.this.contextProvider.register(context);
        }
    }

    private class SaveStateVisitor
    implements IPluginVisitor {
        String pluginID;

        public SaveStateVisitor() {
        }

        public SaveStateVisitor(String pluginID) {
            this.pluginID = pluginID;
        }

        @Override
        public void visit(IPlugin plugin) {
            if (this.pluginID == null || this.pluginID.equals(plugin.getId())) {
                Map<String, Object> params = plugin.getParameters();
                for (Map.Entry<String, Object> e : params.entrySet()) {
                    PluginManager.this.persistentContextParams.setProperty(plugin.getId(), e.getKey(), e.getValue().toString());
                }
                PluginManager.this.persistentContextParams.setProperty(plugin.getId(), PluginManager.ACTIVE, plugin.isActive() ? "true" : "false");
            }
        }
    }

    private class SetParamVisitor
    implements IPluginVisitor {
        String pluginID;
        Map<String, Object> params;

        public SetParamVisitor(String pluginID, Map<String, Object> params) {
            this.pluginID = pluginID;
            this.params = params;
        }

        @Override
        public void visit(IPlugin plugin) {
            if (this.pluginID != null && this.pluginID.equals(plugin.getId())) {
                for (Map.Entry<String, Object> e : this.params.entrySet()) {
                    plugin.setParam(e.getKey(), e.getValue());
                }
            }
        }
    }

    private class UnregisterVisitor
    implements ISpecializedPluginVisitor {
        private UnregisterVisitor() {
        }

        @Override
        public void visit(IService service) {
            PluginManager.this.serviceProvider.unregister(service);
        }

        @Override
        public void visit(IQueryParser interpreter) {
            PluginManager.this.queryParserProvider.unregister(interpreter);
        }

        @Override
        public void visit(IRetriever retriever) {
            PluginManager.this.retrieverProvider.unregister(retriever);
        }

        @Override
        public void visit(ISynthesizer synthesizer) {
            PluginManager.this.synthesizerProvider.unregister(synthesizer);
        }

        @Override
        public void visit(IContext context) {
            PluginManager.this.contextProvider.unregister(context);
        }
    }
}

