/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.openqa.component.service.cache.impl;

import java.util.HashMap;
import java.util.Map;
import org.aksw.openqa.component.service.AbstractService;
import org.aksw.openqa.component.service.cache.ICacheService;
import org.aksw.openqa.component.service.cache.impl.Cache;

public class CacheService
extends AbstractService
implements ICacheService {
    Map<String, Cache<String, Object>> caches = new HashMap<String, Cache<String, Object>>();
    public static final String MAX_CAPACITY = "MAX_CAPACITY";
    int capacity = 100;

    public CacheService(Map<String, Object> params) {
        super(params);
        this.setParam(MAX_CAPACITY, this.capacity);
    }

    @Override
    public void setParam(String param, Object o) {
        if (param.equals(MAX_CAPACITY)) {
            int capacity = Integer.parseInt(o.toString());
            for (Cache<String, Object> cache : this.caches.values()) {
                cache.setCapacity(capacity);
            }
        }
        super.setParam(param, o);
    }

    @Override
    public Cache<String, Object> get(String cacheContext) throws Exception {
        Cache<String, Object> cache = this.caches.get(cacheContext);
        if (cache == null) {
            cache = new Cache(this.capacity);
            this.caches.put(cacheContext, cache);
        }
        return cache;
    }

    @Override
    public Object get(String cacheContext, String objectID) throws Exception {
        Cache<String, Object> cache = this.get(cacheContext);
        return cache.get(objectID);
    }

    @Override
    public <T> T get(String cacheContext, String objectID, Class<T> clazz) throws Exception {
        Cache<String, Object> cache = this.get(cacheContext);
        return clazz.cast(cache.get(objectID));
    }

    @Override
    public void put(String cacheContext, String objectID, Object value) throws Exception {
        Cache<String, Object> cache = this.get(cacheContext);
        cache.put(objectID, value);
    }

    @Override
    public String getVersion() {
        return "v0.1.7-beta";
    }

    @Override
    public String getAPI() {
        return "1.0-beta";
    }
}

