/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.openqa.component.param;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.aksw.openqa.component.param.IMap;

public abstract class AbstractMap
implements IMap {
    private Map<String, Object> params = new HashMap<String, Object>();

    @Override
    public boolean contains(String propertyId) {
        return this.params.containsKey(propertyId);
    }

    @Override
    public boolean contains(String propertyId, Class<?> clazz) {
        return this.params.containsKey(propertyId) && this.getParam(propertyId, clazz) != null;
    }

    @Override
    public Object getParam(String propertyId) {
        return this.params.get(propertyId);
    }

    @Override
    public Object getParam(String propertyId, Object defaultValue) {
        Object value = this.getParam(propertyId);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public <T> T getParam(String propertyId, Class<T> clazz) {
        Object property = this.params.get(propertyId);
        if (property != null && clazz.isAssignableFrom(property.getClass())) {
            T tProperty = clazz.cast(property);
            return tProperty;
        }
        if (String.class.isInstance(property) && Number.class.isAssignableFrom(clazz)) {
            try {
                Constructor<T> f = clazz.getConstructor(property.getClass());
                return f.newInstance(property);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public <T> T getParam(String propertyId, Class<T> clazz, T defaultValue) {
        T property = this.getParam(propertyId, clazz);
        if (property == null) {
            return defaultValue;
        }
        return property;
    }

    @Override
    public void setParam(String propertyId, Object o) {
        this.params.put(propertyId, o);
    }

    public void setProperties(Map<String, Object> entries) {
        if (entries != null) {
            this.params.putAll(entries);
        }
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.params;
    }
}

