/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.openqa.component.answerformulation.synthesizer.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.openqa.component.answerformulation.AbstractSynthesizer;
import org.aksw.openqa.component.context.IContext;
import org.aksw.openqa.component.param.IParamMap;
import org.aksw.openqa.component.param.IResultMap;
import org.aksw.openqa.component.param.IResultMapList;
import org.aksw.openqa.component.param.ResultMap;
import org.aksw.openqa.component.param.ResultMapList;
import org.aksw.openqa.component.providers.impl.ServiceProvider;

public class ResourceSynthesizer
extends AbstractSynthesizer {
    Comparator<Map.Entry<String, Candidate>> comparator = new Comparator<Map.Entry<String, Candidate>>(){

        @Override
        public int compare(Map.Entry<String, Candidate> e1, Map.Entry<String, Candidate> e2) {
            Candidate c1 = e1.getValue();
            Candidate c2 = e2.getValue();
            return c2.incidence - c1.incidence;
        }
    };

    public ResourceSynthesizer(Map<String, Object> params) throws IOException {
        super(params);
    }

    @Override
    public boolean canProcess(IParamMap param) {
        return param.contains("URI_PARAM") || param.contains("LITERAL_NUMBER_PARAM") || param.contains("LITERAL_DATE_PARAM") || param.contains("LITERAL_BOOLEAN_PARAM") || param.contains("LITERAL_TEXT_PARAM") || param.contains("RESOURCE_PARAM");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IResultMapList<? extends IResultMap> process(List<? extends IParamMap> inputParams, ServiceProvider services, IContext context) throws Exception {
        Candidate candidate;
        HashMap<void, Candidate> instanceIncidence = new HashMap<void, Candidate>();
        for (IParamMap iParamMap : inputParams) {
            void var7_8;
            Object var7_9 = null;
            String attrKey = null;
            if (iParamMap.contains("URI_PARAM")) {
                String string = (String)iParamMap.getParam("URI_PARAM");
                attrKey = "URI_PARAM";
            } else if (iParamMap.contains("LITERAL_NUMBER_PARAM")) {
                String string = iParamMap.getParam("LITERAL_NUMBER_PARAM").toString();
            } else if (iParamMap.contains("LITERAL_DATE_PARAM")) {
                String string = (String)iParamMap.getParam("LITERAL_DATE_PARAM");
            } else if (iParamMap.contains("LITERAL_BOOLEAN_PARAM")) {
                String string = (String)iParamMap.getParam("LITERAL_BOOLEAN_PARAM");
            } else if (iParamMap.contains("LITERAL_TEXT_PARAM")) {
                String string = (String)iParamMap.getParam("LITERAL_TEXT_PARAM");
            } else {
                String string = (String)iParamMap.getParam("RESOURCE_PARAM");
            }
            if (attrKey == "URI_PARAM") {
                void var7_16;
                String string = var7_16.substring(attrKey.lastIndexOf("/") + 1);
            }
            if (instanceIncidence.containsKey(var7_8)) {
                candidate = (Candidate)instanceIncidence.get(var7_8);
                ++candidate.incidence;
                instanceIncidence.put(var7_8, candidate);
                continue;
            }
            candidate = new Candidate();
            candidate.param = iParamMap;
            ++candidate.incidence;
            instanceIncidence.put(var7_8, candidate);
        }
        ArrayList arrayList = new ArrayList(instanceIncidence.entrySet());
        Collections.sort(arrayList, this.comparator);
        ResultMapList<ResultMap> results = new ResultMapList<ResultMap>();
        for (Map.Entry entry : arrayList) {
            candidate = (Candidate)entry.getValue();
            IParamMap inputParam = candidate.param;
            ResultMap result = new ResultMap(inputParam.getParameters());
            results.add(result);
        }
        return results;
    }

    @Override
    public List<? extends IResultMap> process(IParamMap param, ServiceProvider services, IContext context) throws Exception {
        ArrayList<ResultMap> results = new ArrayList<ResultMap>();
        ResultMap result = new ResultMap(param.getParameters());
        results.add(result);
        return results;
    }

    @Override
    public String getVersion() {
        return "v0.1.7-beta";
    }

    @Override
    public String getAPI() {
        return "1.0-beta";
    }

    private class Candidate {
        IParamMap param;
        int incidence = 0;

        private Candidate() {
        }
    }
}

