/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.openqa.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.aksw.openqa.component.AbstractProvider;
import org.aksw.openqa.component.IPlugin;
import org.aksw.openqa.component.IPluginFactorySpi;
import org.aksw.openqa.component.providers.impl.ServiceProvider;

public abstract class AbstractPluginProvider<C extends IPlugin, F extends IPluginFactorySpi<C>>
extends AbstractProvider<C> {
    private static final String DEFAULT_META_PATH = "/";
    private static final String DEFAULT_INIT_SUFFIX = ".ini";
    private Map<String, C> components = new HashMap<String, C>();
    private Map<Class<?>, C> componentClasses = new HashMap();
    private List<C> componentList = new ArrayList<C>();

    public AbstractPluginProvider() {
    }

    public AbstractPluginProvider(Class<F> clazz, List<? extends ClassLoader> classLoaders, ServiceProvider serviceProvider) {
        this();
        this.loadComponents(clazz, classLoaders, serviceProvider);
    }

    @Override
    public void register(C component) {
        String componentId = component.getId();
        if (!this.components.containsKey(componentId)) {
            this.components.put(componentId, component);
            this.componentList.add(component);
            this.componentClasses.put(component.getClass(), component);
        }
    }

    @Override
    public void unregister(C component) {
        String componentId = component.getId();
        this.components.remove(componentId);
        this.componentList.remove(this.get(componentId));
        this.componentClasses.remove(component.getClass());
    }

    protected void loadComponents(Class<F> clazz, List<? extends ClassLoader> classLoaders, ServiceProvider serviceProvider) {
        List<C> componentList = this.list(clazz, classLoaders);
        for (IPlugin component : componentList) {
            this.register((C)component);
        }
    }

    private List<C> list(Class<F> clazz, ServiceLoader<F> serviceLoader) {
        ArrayList list = new ArrayList();
        for (IPluginFactorySpi factory : serviceLoader) {
            String className = factory.getClass().getName();
            String classPath = factory.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
            classPath = classPath.substring(0, classPath.lastIndexOf(DEFAULT_META_PATH));
            Map<String, Object> params = null;
            params = AbstractPluginProvider.getPropertiesFromFile(DEFAULT_META_PATH + className + DEFAULT_INIT_SUFFIX);
            if (params == null) {
                params = AbstractPluginProvider.getProperties(clazz, DEFAULT_META_PATH + className + DEFAULT_INIT_SUFFIX);
            }
            list.add(factory.create(params));
        }
        return list;
    }

    @Override
    public C get(String id) {
        return (C)((IPlugin)this.components.get(id));
    }

    @Override
    public List<C> list() {
        return this.componentList;
    }

    @Override
    public <K extends C> K get(Class<K> clazz) {
        for (Class<?> classEntry : this.componentClasses.keySet()) {
            IPlugin component;
            if (!clazz.isAssignableFrom(classEntry) || !(component = (IPlugin)this.componentClasses.get(classEntry)).isActive()) continue;
            return (K)component;
        }
        return null;
    }

    protected List<C> list(Class<F> clazz, List<? extends ClassLoader> classLoaders) {
        ArrayList<C> components = new ArrayList<C>();
        for (ClassLoader classLoader : classLoaders) {
            ServiceLoader<F> serviceLoader = ServiceLoader.load(clazz, classLoader);
            components.addAll(this.list(clazz, serviceLoader));
        }
        return components;
    }
}

