/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.openqa.component;

import java.util.ArrayList;
import java.util.List;
import org.aksw.openqa.component.AbstractPluginProvider;
import org.aksw.openqa.component.IPluginFactorySpi;
import org.aksw.openqa.component.IPluginProcess;
import org.aksw.openqa.component.IProcess;
import org.aksw.openqa.component.context.IContext;
import org.aksw.openqa.component.param.IParamMap;
import org.aksw.openqa.component.param.IResultMap;
import org.aksw.openqa.component.param.IResultMapList;
import org.aksw.openqa.component.param.ResultMapList;
import org.aksw.openqa.component.providers.impl.ServiceProvider;
import org.apache.log4j.Logger;

public abstract class AbstractPluginProcessProvider<C extends IPluginProcess, F extends IPluginFactorySpi<C>>
extends AbstractPluginProvider<C, F>
implements IProcess {
    private static Logger logger = Logger.getLogger(AbstractPluginProcessProvider.class);

    public AbstractPluginProcessProvider(Class<F> clazz, List<? extends ClassLoader> classLoaders, ServiceProvider serviceProvider) {
        super(clazz, classLoaders, serviceProvider);
    }

    public AbstractPluginProcessProvider() {
    }

    protected IResultMapList<IResultMap> process(List<? extends IParamMap> arguments, List<C> components, ServiceProvider serviceProvider, IContext context) {
        ResultMapList<IResultMap> results = new ResultMapList<IResultMap>();
        for (IPluginProcess component : components) {
            List<IParamMap> canProcessArguments = this.getArguments(arguments, component);
            if (!component.isActive() || canProcessArguments == null) continue;
            try {
                results.addAll(component.process(canProcessArguments, serviceProvider, context));
            }
            catch (Exception e) {
                logger.error((Object)"ProcessProvider exception", (Throwable)e);
            }
            catch (Error e) {
                logger.error((Object)"ProcessProvider error", (Throwable)e);
            }
        }
        return results;
    }

    public List<IParamMap> getArguments(List<? extends IParamMap> arguments, C component) {
        ArrayList<IParamMap> componentArguments = null;
        for (IParamMap iParamMap : arguments) {
            if (!component.canProcess(iParamMap)) continue;
            if (componentArguments == null) {
                componentArguments = new ArrayList<IParamMap>();
            }
            componentArguments.add(iParamMap);
        }
        return componentArguments;
    }

    public IResultMapList<IResultMap> process(List<? extends IParamMap> arguments, ServiceProvider services, IContext context) throws Exception {
        return this.process(arguments, this.list(), services, context);
    }
}

