/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.openqa.component;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.aksw.openqa.component.IPlugin;
import org.aksw.openqa.component.IPluginVisitor;
import org.aksw.openqa.component.param.AbstractMap;
import org.aksw.openqa.util.PropertyLoaderUtil;
import org.apache.log4j.Logger;

public abstract class AbstractPlugin
extends AbstractMap
implements IPlugin {
    private static Logger logger = Logger.getLogger(AbstractPlugin.class);
    private static final String DEFAULT_VALUE = "undefined";
    private static final String DEFAULT_META_PATH = "/META-INF/";
    private static final String DEFAULT_INFO_SUFFIX = ".inf";
    private static final String DEFAULT_INI_SUFFIX = ".ini";
    private static final String AUTHOR_PROPERTY = "author";
    private static final String VERSION_PROPERTY = "version";
    private static final String LICENSE_PROPERTY = "license";
    private static final String LABEL_PROPERTY = "label";
    private static final String CONTACT_PROPERTY = "contact";
    private static final String WEBSITE_PROPERTY = "website";
    private static final String INPUT_PROPERTY = "input";
    private static final String OUTPUT_PROPERTY = "output";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String API_PROPERTY = "API";
    private String author = "undefined";
    private String description = "undefined";
    private String contact = "undefined";
    private String license = "undefined";
    private String version = "undefined";
    private String label = "undefined";
    private String website = "undefined";
    private String api = "undefined";
    private String output = "undefined";
    private String input = "undefined";
    boolean isActive;

    public AbstractPlugin() {
    }

    public AbstractPlugin(Map<String, Object> params) {
        this.init(this.getClass(), params);
    }

    protected AbstractPlugin(Class<? extends IPlugin> clazz, Map<String, Object> params) {
        this.init(clazz, params);
    }

    private void init(Class<? extends IPlugin> clazz, Map<String, Object> params) {
        Map<String, Object> properties;
        Properties prop = new Properties();
        InputStream inStream = clazz.getResourceAsStream(DEFAULT_META_PATH + clazz.getName() + DEFAULT_INFO_SUFFIX);
        try {
            if (inStream != null) {
                prop.load(inStream);
                this.author = prop.getProperty(AUTHOR_PROPERTY, DEFAULT_VALUE);
                this.version = prop.getProperty(VERSION_PROPERTY, DEFAULT_VALUE);
                this.license = prop.getProperty(LICENSE_PROPERTY, DEFAULT_VALUE);
                this.label = prop.getProperty(LABEL_PROPERTY, DEFAULT_VALUE);
                this.contact = prop.getProperty(CONTACT_PROPERTY, DEFAULT_VALUE);
                this.description = prop.getProperty(DESCRIPTION_PROPERTY, DEFAULT_VALUE);
                this.website = prop.getProperty(WEBSITE_PROPERTY, DEFAULT_VALUE);
                this.api = prop.getProperty(API_PROPERTY, DEFAULT_VALUE);
                this.input = prop.getProperty(INPUT_PROPERTY, DEFAULT_VALUE);
                this.output = prop.getProperty(OUTPUT_PROPERTY, DEFAULT_VALUE);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error initializing component description properties:" + clazz.getName()), (Throwable)e);
        }
        if ((properties = PropertyLoaderUtil.getProperties(clazz, DEFAULT_META_PATH + clazz.getName() + DEFAULT_INI_SUFFIX)) != null) {
            this.setProperties(properties);
        }
        String className = clazz.getName();
        String classPath = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
        properties = PropertyLoaderUtil.getPropertiesFromFile(String.valueOf(classPath = classPath.substring(0, classPath.lastIndexOf("/"))) + "/" + className + DEFAULT_INI_SUFFIX);
        if (properties != null) {
            this.setProperties(properties);
        }
        if (params != null) {
            this.setProperties(params);
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        if (isActive) {
            this.startup();
        } else {
            this.shutdown();
        }
        this.isActive = isActive;
    }

    public void startup() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public String getWebsite() {
        return this.website;
    }

    @Override
    public String getAPI() {
        return this.api;
    }

    @Override
    public String getInput() {
        return this.input;
    }

    @Override
    public String getOutput() {
        return this.output;
    }

    @Override
    public String getContact() {
        return this.contact;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLicense() {
        return this.license;
    }

    @Override
    public String getId() {
        return String.valueOf(this.getLabel()) + " " + this.getVersion();
    }

    @Override
    public void accept(IPluginVisitor visitor) {
        visitor.visit(this);
    }
}

