/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.openqa;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class PersistentContextParams
implements Serializable {
    private static final long serialVersionUID = 8598003281170345448L;
    File file;

    public PersistentContextParams(String appContext) {
        this.file = new File(String.valueOf(appContext) + "_custom.prop");
    }

    public PersistentContextParams(String path, String appContext) {
        this.file = new File(String.valueOf(path) + "/" + appContext + "_custom.prop");
    }

    public synchronized String getProperty(String context, String property, String defaultValue) {
        DB db = DBMaker.newFileDB((File)this.file).make();
        BTreeMap treeMap = db.getTreeMap(context);
        String value = (String)treeMap.get(property);
        if (value == null) {
            return defaultValue;
        }
        db.close();
        return value;
    }

    public Map<String, String> listParams(String componentContext) {
        HashMap<String, String> params = new HashMap<String, String>();
        DB db = DBMaker.newFileDB((File)this.file).make();
        db = DBMaker.newFileDB((File)this.file).make();
        BTreeMap treeMap = db.getTreeMap(componentContext);
        for (Map.Entry entry : treeMap.entrySet()) {
            params.put((String)entry.getKey(), (String)entry.getValue());
        }
        db.close();
        return params;
    }

    public synchronized void setProperty(String context, String property, String value) {
        DB db = DBMaker.newFileDB((File)this.file).make();
        BTreeMap treeMap = db.getTreeMap(context);
        treeMap.put(property, value);
        db.commit();
        db.close();
    }
}

