/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.openqa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.aksw.openqa.DefaultPipeline;
import org.aksw.openqa.RunProcessVisitor;
import org.aksw.openqa.Stage;
import org.aksw.openqa.component.IComponent;
import org.aksw.openqa.component.IPlugin;
import org.aksw.openqa.component.IProcess;
import org.aksw.openqa.component.context.IContext;
import org.aksw.openqa.component.context.impl.Context;
import org.aksw.openqa.component.param.IParamMap;
import org.aksw.openqa.component.param.IResultMap;
import org.aksw.openqa.component.param.IResultMapList;
import org.aksw.openqa.component.param.ParamMap;
import org.aksw.openqa.component.param.ResultMapList;
import org.aksw.openqa.component.providers.impl.ContextProvider;
import org.aksw.openqa.component.providers.impl.QueryParserProvider;
import org.aksw.openqa.component.providers.impl.RetrieverProvider;
import org.aksw.openqa.component.providers.impl.ServiceProvider;
import org.aksw.openqa.component.providers.impl.SynthesizerProvider;
import org.aksw.openqa.main.ProcessResult;
import org.aksw.openqa.main.QueryResult;
import org.aksw.openqa.manager.plugin.PluginManager;
import org.apache.log4j.Logger;

public class AnswerFormulation
implements IComponent {
    private static Logger logger = Logger.getLogger(AnswerFormulation.class);
    public static List<Stage> DEFAULT_PIPELINE = Collections.synchronizedList(new DefaultPipeline());
    private PluginManager pluginManager;

    public AnswerFormulation() {
    }

    public AnswerFormulation(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public QueryResult process(String query) throws Exception {
        return this.process(query, this.pluginManager);
    }

    public QueryResult process(String query, PluginManager pluginManager) throws Exception {
        logger.info((Object)("Processing query " + query));
        ArrayList<IParamMap> params = new ArrayList<IParamMap>();
        ParamMap param = new ParamMap();
        param.setParam("LITERAL_TEXT_PARAM", query);
        params.add(param);
        Date start = new Date();
        QueryResult queryResult = this.process(params, pluginManager);
        Date end = new Date();
        queryResult.setRuntime(end.getTime() - start.getTime());
        logger.debug((Object)("Answer formulation Runtime(ms) " + queryResult.getRuntime()));
        return queryResult;
    }

    public QueryResult process(String query, PluginManager pluginManager, List<Stage> pipeline) throws Exception {
        logger.info((Object)("Processing query " + query));
        ArrayList<IParamMap> params = new ArrayList<IParamMap>();
        ParamMap param = new ParamMap();
        param.setParam("LITERAL_TEXT_PARAM", query);
        params.add(param);
        Date start = new Date();
        QueryResult queryResult = this.process(params, pluginManager, pipeline);
        Date end = new Date();
        queryResult.setRuntime(end.getTime() - start.getTime());
        logger.debug((Object)("Answer formulation Runtime(ms) " + queryResult.getRuntime()));
        return queryResult;
    }

    public QueryResult process(List<IParamMap> params, PluginManager pluginManager, List<Stage> stages) {
        ServiceProvider services = pluginManager.getProvider(ServiceProvider.class);
        ContextProvider contextProvider = pluginManager.getProvider(ContextProvider.class);
        IContext context = (IContext)contextProvider.get(IContext.class);
        if (context != null) {
            context.setParam("REQUEST_HOST", "localhost");
        }
        return this.process(params, services, context, pluginManager, stages);
    }

    public QueryResult process(List<IParamMap> params, ServiceProvider services, IContext context, PluginManager pluginManager, List<Stage> stages) {
        List<IParamMap> inputParams = params;
        QueryResult queryResult = new QueryResult();
        queryResult.setSource(this);
        queryResult.setInput(params);
        ResultMapList<IParamMap> results = null;
        for (Stage stage : stages) {
            results = new ResultMapList<IParamMap>();
            for (String componentID : stage.getComponentIDs()) {
                IPlugin p = pluginManager.getPlugin(componentID);
                ProcessResult processResult = null;
                if (p != null) {
                    RunProcessVisitor runVisitor = new RunProcessVisitor(inputParams, services, context);
                    p.accept(runVisitor);
                    processResult = runVisitor.getResult();
                } else {
                    IProcess process = pluginManager.getProcessProvider(componentID);
                    if (process != null) {
                        processResult = this.executeProcess(inputParams, process, services, context);
                    } else {
                        logger.warn((Object)("The component " + componentID + " in the dynamic pipeline is not active or does not exists!"));
                    }
                }
                if (processResult == null) continue;
                IResultMapList<? extends IResultMap> processResults = processResult.getOutput();
                logger.debug((Object)("Number of results for " + componentID + ":" + processResults.size()));
                logger.debug((Object)(String.valueOf(componentID) + ", runtime: " + processResult.getRuntime()));
                results.addAll(processResults);
                queryResult.setParam(String.valueOf(stage.getId()) + "." + componentID, processResult);
            }
            inputParams = results;
            queryResult.setParam(stage.getId(), results);
        }
        queryResult.setOutput(results);
        return queryResult;
    }

    protected ProcessResult executeProcess(List<? extends IParamMap> params, IProcess process, ServiceProvider services, IContext context) {
        Date start = new Date();
        Throwable throwable = null;
        IResultMapList<? extends IResultMap> results = null;
        try {
            results = process.process(params, services, context);
        }
        catch (Throwable t) {
            throwable = t;
        }
        Date end = new Date();
        ProcessResult processResult = new ProcessResult();
        processResult.setOutput(results);
        processResult.setRuntime(end.getTime() - start.getTime());
        processResult.setInput(params);
        processResult.setException(throwable);
        return processResult;
    }

    private QueryResult process(List<IParamMap> params, PluginManager pluginManager) throws Exception {
        ContextProvider contextProvider = pluginManager.getProvider(ContextProvider.class);
        ServiceProvider serviceProvider = pluginManager.getProvider(ServiceProvider.class);
        QueryParserProvider interpreterProvider = pluginManager.getProvider(QueryParserProvider.class);
        RetrieverProvider retrieverProvider = pluginManager.getProvider(RetrieverProvider.class);
        SynthesizerProvider synthesizerProvider = pluginManager.getProvider(SynthesizerProvider.class);
        IContext context = (IContext)contextProvider.get(IContext.class);
        if (context != null) {
            context.setParam("REQUEST_HOST", "localhost");
        }
        QueryResult result = new QueryResult();
        result.setComponentSource(this);
        result.setInput(params);
        logger.debug((Object)"Interpreting");
        ProcessResult processResult = this.executeProcess(params, interpreterProvider, serviceProvider, context);
        IResultMapList<? extends IResultMap> interpretations = processResult.getOutput();
        logger.debug((Object)("Number of interpretations: " + interpretations.size()));
        logger.debug((Object)("Interpreting runtime: " + processResult.getRuntime()));
        result.setParam("QueryResult.QUERYPARSING_RESULT", processResult);
        logger.debug((Object)"Retrieving");
        processResult = this.executeProcess(interpretations, retrieverProvider, serviceProvider, context);
        IResultMapList<? extends IResultMap> retrievingResults = processResult.getOutput();
        logger.debug((Object)("Number of retrieved results: " + retrievingResults.size()));
        logger.debug((Object)("Retrieval runtime: " + processResult.getRuntime()));
        result.setParam("QueryResult.RETRIEVAL_RESULT", processResult);
        logger.debug((Object)"Synthesizing");
        processResult = this.executeProcess(retrievingResults, synthesizerProvider, serviceProvider, context);
        IResultMapList<? extends IResultMap> synthesisResults = processResult.getOutput();
        logger.debug((Object)("Number of synthesis: " + synthesisResults.size()));
        logger.debug((Object)("Synthesis runtime: " + processResult.getRuntime()));
        result.setParam("QueryResult.SYNTHESIS_RESULT", processResult);
        result.setOutput(synthesisResults);
        return result;
    }

    public QueryResult process(Map<String, Object> params, PluginManager pluginManager, Context context) {
        List<Stage> stages = DEFAULT_PIPELINE;
        ServiceProvider services = pluginManager.getProvider(ServiceProvider.class);
        ParamMap paramMap = new ParamMap();
        logger.info((Object)"Parameterizing");
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            paramMap.setParam(entry.getKey(), entry.getValue());
        }
        ArrayList<IParamMap> paramMaps = new ArrayList<IParamMap>();
        paramMaps.add(paramMap);
        return this.process(paramMaps, services, context, pluginManager, stages);
    }

    public QueryResult process(Map<String, Object> params, PluginManager pluginManager, Context context, List<Stage> stages) {
        ServiceProvider services = pluginManager.getProvider(ServiceProvider.class);
        ParamMap paramMap = new ParamMap();
        logger.info((Object)"Parameterizing");
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            paramMap.setParam(entry.getKey(), entry.getValue());
        }
        ArrayList<IParamMap> paramMaps = new ArrayList<IParamMap>();
        paramMaps.add(paramMap);
        return this.process(paramMaps, services, context, pluginManager, stages);
    }

    @Override
    public String getId() {
        return "AnswerFormulation";
    }
}

