/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.mex.log4mex;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.aksw.mex.log4mex.ExperimentConfigurationVO;
import org.aksw.mex.log4mex.core.ApplicationContextVO;
import org.aksw.mex.log4mex.core.ExperimentVO;
import org.aksw.mex.util.MEXController;
import org.aksw.mex.util.MEXEnum;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyMEX {
    private static final Logger LOGGER = LoggerFactory.getLogger(MyMEX.class);
    private ApplicationContextVO applicationContext = new ApplicationContextVO();
    private ExperimentVO experiment = new ExperimentVO("MEX_EXPERIMENT");
    private List<ExperimentConfigurationVO> experimentConfigurationList = new ArrayList<ExperimentConfigurationVO>();
    private boolean withoutConfiguration = false;
    private String userHash;

    public ApplicationContextVO getApplicationContext() {
        return this.applicationContext;
    }

    public void setAuthor(String name, String email) {
        this.applicationContext.setAuthorName(name);
        this.applicationContext.setMailBox(email);
    }

    public void setAuthorName(String value) {
        this.applicationContext.setAuthorName(value);
    }

    public void setAuthorEmail(String value) {
        this.applicationContext.setMailBox(value);
    }

    public void setContext(MEXEnum.EnumContexts value) {
        this.applicationContext.setContext(value);
    }

    public void setOrganization(String value) {
        this.applicationContext.setOrganization(value);
    }

    public ExperimentVO getExperiment() {
        return this.experiment;
    }

    public void setExperimentId(String value) {
        this.experiment.setId(value);
    }

    public void setExperimentTitle(String value) {
        this.experiment.setTitle(value);
    }

    public void setExperimentDate(Date value) {
        this.experiment.setDate(value);
    }

    public void setExperimentDescription(String value) {
        this.experiment.setDescription(value);
    }

    public void setExperimentDataNormalizationDescription(String value) {
        this.experiment.setDataNormalizationDescription(value);
    }

    public void setExperimentNoiseRemovalDescription(String value) {
        this.experiment.setNoiseRemovalDescription(value);
    }

    public void setExperimentAttributeSelectionDescription(String value) {
        this.experiment.setAttributeSelectionDescription(value);
    }

    public void setExperimentOutlierDetectionDescription(String value) {
        this.experiment.setOutlierDetectionDescription(value);
    }

    private String addConf(String value) throws Exception {
        String ret = "";
        String valueaux = "";
        try {
            if (this.withoutConfiguration && (StringUtils.isNotEmpty((CharSequence)value) || StringUtils.isNotBlank((CharSequence)value))) {
                String logmessage = "You defined a SINGLE Configuration before and now are trying add a MULTIPLE Configuration. It's not allowed, sorry! Please change your method calls in order to have either [Configuration()] calls (just ONE configuration) or [addConfiguration(id) and Configuration(id)] (MORE THAN ONE configuration)";
                LOGGER.warn(logmessage);
                throw new Exception(logmessage);
            }
            if (this.experimentConfigurationList == null) {
                String logmessage = "fatal error: experiment config list is null!";
                LOGGER.warn(logmessage);
                throw new Exception(logmessage);
            }
            int totalElements = this.experimentConfigurationList.size();
            valueaux = StringUtils.isEmpty((CharSequence)value) || StringUtils.isBlank((CharSequence)value) ? "MEX_EXP_CONF_D" + String.valueOf(totalElements + 1) : value;
            String check = valueaux;
            Collection t = Collections2.filter(this.experimentConfigurationList, p -> p.getId().equals(check));
            if (t != null && t.size() > 0) {
                throw new Exception("Error: Experiment Configuration ID " + check + " already assigned");
            }
            if (!this.experimentConfigurationList.add(new ExperimentConfigurationVO(valueaux, totalElements + 1))) {
                throw new Exception("Error when including the item in the list");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        return valueaux;
    }

    public String addConfiguration() throws Exception {
        String ret = "";
        try {
            ret = this.addConf("");
            MEXController.getInstance().addExperimentConfigurationCounter();
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            throw e;
        }
        return ret;
    }

    public String addConfiguration(String value) throws Exception {
        String ret = "";
        try {
            ret = this.addConf(value);
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            throw e;
        }
        return ret;
    }

    protected List<ExperimentConfigurationVO> getExperimentConfigurations() {
        return this.experimentConfigurationList;
    }

    public ExperimentConfigurationVO Configuration(String value) throws Exception {
        ExperimentConfigurationVO ret = null;
        try {
            Collection t = Collections2.filter(this.experimentConfigurationList, experimentConfigurationVO -> experimentConfigurationVO.getId().equals(value));
            if (t == null || t.size() <= 0) {
                throw new Exception("Configuration ID has not been found: " + value);
            }
            ret = (ExperimentConfigurationVO)Iterables.get((Iterable)t, (int)0);
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        return ret;
    }

    public ExperimentConfigurationVO Configuration() throws Exception {
        ExperimentConfigurationVO ret;
        block7: {
            ret = null;
            try {
                String id = "MEX_EXP_CONF_D1";
                if (this.experimentConfigurationList == null) {
                    String logmsg = "We got a problem accessing the configurations (rule 1)! It looks like a bug! Please report it!";
                    LOGGER.warn(logmsg);
                    throw new Exception(logmsg);
                }
                if (!this.withoutConfiguration && this.experimentConfigurationList.size() > 0) {
                    String logmsg = "You defined a MULTIPLE Configuration (by calling addConfiguration(id) method) before and now are trying add a SINGLE Configuration (by calling Configuration() method). It's not allowed, sorry!";
                    LOGGER.warn(logmsg);
                    throw new Exception(logmsg);
                }
                if (this.withoutConfiguration && this.experimentConfigurationList.size() == 0) {
                    String logmsg = "We got a problem accessing the configurations (rule 2)! It looks like a bug! Please report it!";
                    LOGGER.warn(logmsg);
                    throw new Exception(logmsg);
                }
                if (!this.withoutConfiguration && this.experimentConfigurationList.size() == 0) {
                    this.withoutConfiguration = true;
                    ExperimentConfigurationVO conf = new ExperimentConfigurationVO("MEX_EXP_CONF_D1", 1);
                    this.experimentConfigurationList.add(conf);
                    ret = conf;
                    break block7;
                }
                if (this.withoutConfiguration && this.experimentConfigurationList.size() == 1) {
                    ret = this.experimentConfigurationList.get(0);
                    break block7;
                }
                String logmsg = "We got a problem accessing the configurations (rule 3)! It looks like a bug! Please report it!";
                LOGGER.warn(logmsg);
                throw new Exception(logmsg);
            }
            catch (Exception e) {
                LOGGER.error(e.toString());
            }
        }
        return ret;
    }

    protected void setUserHash() throws Exception {
        Random rand = new Random();
        int n = rand.nextInt(31999) + 1;
        this.userHash = String.valueOf(String.valueOf(this.getApplicationContext().get_mbox() + String.valueOf(this.getApplicationContext().get_givenName()) + this.getExperiment().getId() + n).hashCode());
    }

    protected String getUserHash() {
        return this.userHash;
    }
}

