/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.mex.log4mex;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.DCTerms;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import org.aksw.mex.log4mex.Execution;
import org.aksw.mex.log4mex.ExperimentConfigurationVO;
import org.aksw.mex.log4mex.MyMEX;
import org.aksw.mex.log4mex.algo.HyperParameterVO;
import org.aksw.mex.log4mex.algo.ToolParameterVO;
import org.aksw.mex.log4mex.algo.ToolVO;
import org.aksw.mex.log4mex.core.DataSetVO;
import org.aksw.mex.log4mex.core.ExampleVO;
import org.aksw.mex.log4mex.core.ExecutionIndividualVO;
import org.aksw.mex.log4mex.core.ExecutionSetVO;
import org.aksw.mex.log4mex.core.FeatureVO;
import org.aksw.mex.log4mex.core.HardwareConfigurationVO;
import org.aksw.mex.log4mex.core.ModelVO;
import org.aksw.mex.log4mex.core.PhaseVO;
import org.aksw.mex.log4mex.core.SamplingMethodVO;
import org.aksw.mex.log4mex.perf.example.ExamplePerformanceMeasureVO;
import org.aksw.mex.log4mex.perf.overall.ClassificationMeasureVO;
import org.aksw.mex.log4mex.perf.overall.ClusteringMeasureVO;
import org.aksw.mex.log4mex.perf.overall.Measure;
import org.aksw.mex.log4mex.perf.overall.RegressionMeasureVO;
import org.aksw.mex.log4mex.perf.overall.StatisticalMeasureVO;
import org.aksw.mex.log4mex.perf.overall.UserDefinedMeasureVO;
import org.aksw.mex.util.MEXConstant;
import org.aksw.mex.util.MEXEnum;
import org.aksw.mex.util.ontology.DCAT;
import org.aksw.mex.util.ontology.DOAP;
import org.aksw.mex.util.ontology.FOAF;
import org.aksw.mex.util.ontology.PROVO;
import org.aksw.mex.util.ontology.mex.MEXALGO_10;
import org.aksw.mex.util.ontology.mex.MEXCORE_10;
import org.aksw.mex.util.ontology.mex.MEXPERF_10;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MEXSerializer {
    private static MEXSerializer instance = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(MEXSerializer.class);

    protected MEXSerializer() {
    }

    public static MEXSerializer getInstance() {
        if (instance == null) {
            instance = new MEXSerializer();
        }
        return instance;
    }

    private boolean parse(MyMEX mex) throws Exception {
        try {
            if (mex.getExperiment() == null || StringUtils.isEmpty((CharSequence)mex.getExperiment().getId()) || StringUtils.isBlank((CharSequence)mex.getExperiment().getId())) {
                LOGGER.warn("[EXPERIMENT]: missing experiment id!");
                return false;
            }
            if (!mex.getApplicationContext().hasValue()) {
                LOGGER.warn("[APPLICATION_CONTEXT]: missing author name and email!");
                return false;
            }
            List<ExperimentConfigurationVO> configurations = mex.getExperimentConfigurations();
            for (int i = 0; i < configurations.size(); ++i) {
                if (!configurations.get(i).DataSet().hasValue()) {
                    LOGGER.warn("[EXPERIMENT_CONFIGURATION]: missing parameters for dataset!");
                    return false;
                }
                if (configurations.get(i).getAlgorithms() == null || configurations.get(i).getAlgorithms().size() == 0) {
                    LOGGER.warn("[EXPERIMENT_CONFIGURATION]: missing algorithm(s)!");
                    return false;
                }
                if (configurations.get(i).getExecutions() == null || configurations.get(i).getExecutions().size() == 0) {
                    LOGGER.warn("[EXPERIMENT_CONFIGURATION]: missing execution(s)!");
                    return false;
                }
                for (int j = 0; j < configurations.get(i).getExecutions().size(); ++j) {
                    if (configurations.get(i).getExecutions().get(j).getPerformances() != null && configurations.get(i).getExecutions().get(j).getPerformances().size() != 0 || !StringUtils.isBlank((CharSequence)configurations.get(i).getExecutions().get(j).getErrorMessage())) continue;
                    LOGGER.warn("[PERFORMANCE]: missing execution's performance for the execution index " + String.valueOf(j) + ". In case you have a run that have generated an exception, please set the execution's error message!");
                    return false;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            return false;
        }
        return true;
    }

    private void setHeaders(Model model, String URIbase) {
        model.setNsPrefix("prov", "http://www.w3.org/ns/prov#");
        model.setNsPrefix("mexcore", "http://mex.aksw.org/mex-core#");
        model.setNsPrefix("mexperf", "http://mex.aksw.org/mex-perf#");
        model.setNsPrefix("mexalgo", "http://mex.aksw.org/mex-algo#");
        model.setNsPrefix("dc", "http://purl.org/dc/elements/1.1/");
        model.setNsPrefix("owl", "http://www.w3.org/2002/07/owl#");
        model.setNsPrefix("this", URIbase);
        model.setNsPrefix("foaf", "http://xmlns.com/foaf/0.1/");
        model.setNsPrefix("rdfs", RDFS.getURI());
        model.setNsPrefix("xsd", XSD.getURI());
        model.setNsPrefix("dct", "http://purl.org/dc/terms/");
        model.setNsPrefix("doap", DOAP.getURI());
        model.setNsPrefix("dcat", DCAT.getURI());
    }

    private void updateInstanceNames(String URIbase, MyMEX mex) throws Exception {
        try {
            LOGGER.debug("creating the instance names...");
            if (mex.getApplicationContext() == null) {
                throw new Exception("No application data informed!");
            }
            mex.getApplicationContext().setIndividualName(URIbase + "app_" + mex.getUserHash());
            if (mex.getApplicationContext().getContext() != null) {
                mex.getApplicationContext().getContext().setIndividualName(URIbase + "ctx_" + mex.getUserHash());
                mex.getApplicationContext().getContext().setLabel(this.setLabelSplitingTerms(mex.getApplicationContext().getContext().get_context().toString()));
            }
            if (mex.getExperiment() == null) {
                throw new Exception("No experiment defined!");
            }
            mex.getExperiment().setIndividualName(URIbase + "exp_" + mex.getUserHash());
            if (mex.getExperimentConfigurations() == null) {
                throw new Exception("No experiment configuration defined!");
            }
            int i = 0;
            for (ExperimentConfigurationVO item : mex.getExperimentConfigurations()) {
                item.setIndividualName(URIbase + "exp_cf_" + String.valueOf(++i) + "_" + mex.getUserHash());
                if (item.Model() != null && item.Model().hasValue()) {
                    item.Model().setIndividualName(URIbase + "exp_cf_" + String.valueOf(i) + "_" + mex.getUserHash() + "_mod");
                } else {
                    LOGGER.warn("No model defined");
                }
                if (item.DataSet() != null && item.DataSet().hasValue()) {
                    item.DataSet().setIndividualName(URIbase + "exp_cf_" + String.valueOf(i) + "_" + mex.getUserHash() + "_ds");
                } else {
                    LOGGER.warn("No dataset defined");
                }
                if (item.HardwareConfiguration() != null && item.HardwareConfiguration().hasValue()) {
                    item.HardwareConfiguration().setIndividualName(URIbase + "exp_cf_" + String.valueOf(i) + "_" + mex.getUserHash() + "_hard");
                } else {
                    LOGGER.warn("No hardware defined");
                }
                if (item.SamplingMethod() != null && item.SamplingMethod().hasValue()) {
                    item.SamplingMethod().setIndividualName(URIbase + "exp_cf_" + String.valueOf(i) + "_" + mex.getUserHash() + "_sm");
                    item.SamplingMethod().setLabel(this.setLabelSplitingTerms(item.SamplingMethod().getClassName()));
                } else {
                    LOGGER.warn("No sampling method defined");
                }
                if (item.Tool() != null && item.Tool().hasValue()) {
                    item.Tool().setIndividualName(URIbase + "exp_cf_" + String.valueOf(i) + "_" + mex.getUserHash() + "_tool");
                } else {
                    LOGGER.warn("No tool defined");
                }
                if (item.getToolParameters() != null) {
                    if (item.Tool() == null || !item.Tool().hasValue()) {
                        throw new Exception("Tool Parameters defined without a proper Tool defined! Please define also a Tool ...");
                    }
                    int auxtoolparam = 0;
                    for (ToolParameterVO toolParam : item.getToolParameters()) {
                        toolParam.setIndividualName(URIbase + "exp_cf_" + String.valueOf(i) + "_" + mex.getUserHash() + "_tool_param_" + ++auxtoolparam);
                    }
                } else {
                    LOGGER.warn("No tool parameter defined");
                }
                if (item.getFeatures() != null) {
                    int auxf = 0;
                    for (FeatureVO f : item.getFeatures()) {
                        f.setIndividualName(URIbase + "exp_cf_" + String.valueOf(i) + "_" + mex.getUserHash() + "_feat_" + ++auxf);
                    }
                }
                int auxe = 0;
                if (item.getExecutions() == null) continue;
                for (Execution e : item.getExecutions()) {
                    List<Measure> UserDefinedList;
                    e.setIndividualName(URIbase + "exp_cf_" + String.valueOf(i) + "_" + mex.getUserHash() + "_exe_" + ++auxe);
                    if (e.getPhase() != null) {
                        e.getPhase().setIndividualName(URIbase + "exp_cf_" + String.valueOf(i) + "_" + mex.getUserHash() + "_exe_" + auxe + "_phase");
                    }
                    if (e.getExamples() != null) {
                        int auxexa = 0;
                        for (ExampleVO example : e.getExamples()) {
                            example.setIndividualName(URIbase + "exp_cf_" + String.valueOf(i) + "_" + mex.getUserHash() + "_exe_" + auxe + "_example_" + ++auxexa);
                        }
                    }
                    if (e.getAlgorithm() == null) {
                        throw new Exception("There is no algorithm defined for execution (" + auxe + ") id: " + e.getId() + ". Did you set ALGORITHM and EXECUTION (.Execution(x).setAlgorithm(y))? ");
                    }
                    e.getAlgorithm().setIndividualName(URIbase + "exp_cf_" + String.valueOf(i) + "_" + mex.getUserHash() + "_exe_" + auxe + "_algo");
                    if (e.getAlgorithm().getParameters() != null) {
                        Integer auxparam = 0;
                        for (HyperParameterVO algoParam : e.getAlgorithm().getParameters()) {
                            Integer n = auxparam;
                            Integer n2 = auxparam = Integer.valueOf(auxparam + 1);
                            algoParam.setIndividualName(URIbase + "exp_cf_" + String.valueOf(i) + "_" + mex.getUserHash() + "_exe_" + auxe + "_hyperpar_" + auxparam);
                        }
                    }
                    if (e.getPerformances() != null && e.getPerformances().size() > 0) {
                        Integer auxmea = 0;
                        for (Measure mea : e.getPerformances()) {
                            Integer n = auxmea;
                            Integer n3 = auxmea = Integer.valueOf(auxmea + 1);
                            mea.setIndividualName(URIbase + "exp_cf_" + String.valueOf(i) + "_" + mex.getUserHash() + "_exe_" + auxe + "_mea_" + auxmea);
                        }
                    } else {
                        LOGGER.warn("Potential problem: no common measures defined for execution (" + auxe + ") id: " + e.getId());
                    }
                    List<Measure> examplePerformanceList = e.getPerformances(ExamplePerformanceMeasureVO.class);
                    if (examplePerformanceList != null && examplePerformanceList.size() > 0) {
                        int auxep = 0;
                        for (ExamplePerformanceMeasureVO examplePerformanceMeasureVO : examplePerformanceList) {
                            examplePerformanceMeasureVO.setIndividualName(URIbase + "exp_cf_" + String.valueOf(i) + "_" + mex.getUserHash() + "_exe_" + auxe + "_mea_example_" + ++auxep);
                        }
                    }
                    if ((UserDefinedList = e.getPerformances(UserDefinedMeasureVO.class)) == null || UserDefinedList.size() <= 0) continue;
                    int auxud = 0;
                    for (UserDefinedMeasureVO userDefinedMeasureVO : UserDefinedList) {
                        userDefinedMeasureVO.setIndividualName(URIbase + "exp_cf_" + String.valueOf(i) + "_" + mex.getUserHash() + "_exe_" + auxe + "_mea_example_userdrf_" + ++auxud);
                    }
                }
            }
            LOGGER.debug("done...");
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeJena(String filename, String URIbase, MyMEX mex, MEXConstant.EnumRDFFormats format) throws Exception {
        Model model = ModelFactory.createDefaultModel();
        try {
            this.setHeaders(model, URIbase);
            Resource provAgent = model.createResource("http://www.w3.org/ns/prov#Agent");
            Resource provOrganization = model.createResource("http://www.w3.org/ns/prov#Organization");
            Resource mexcore_APC = model.createResource("http://mex.aksw.org/mex-core#ApplicationContext");
            Resource mexcore_EXP_HEADER = model.createResource("http://mex.aksw.org/mex-core#Experiment");
            Resource mexcore_EXP_CONF = model.createResource("http://mex.aksw.org/mex-core#ExperimentConfiguration");
            Resource mexcore_MODEL = model.createResource("http://mex.aksw.org/mex-core#Model");
            Resource mexcore_HARDWARE = model.createResource("http://mex.aksw.org/mex-core#HardwareConfiguration");
            Resource mexcore_DATASET = model.createResource("http://mex.aksw.org/mex-core#Dataset");
            Resource mexcore_FEATURE = model.createResource("http://mex.aksw.org/mex-core#Feature");
            Resource mexcore_FEATURE_COLLECTION = model.createResource("http://mex.aksw.org/mex-core#FeatureCollection");
            Resource mexcore_EXAMPLE = model.createResource("http://mex.aksw.org/mex-core#Example");
            Resource mexcore_EXAMPLE_COLLECTION = model.createResource("http://mex.aksw.org/mex-core#ExampleCollection");
            Resource mexalgo_ALGO = model.createResource("http://mex.aksw.org/mex-algo#Algorithm");
            Resource mexalgo_HYPER_PARAM = model.createResource("http://mex.aksw.org/mex-algo#HyperParameter");
            Resource mexalgo_HYPER_PARAM_COLLECTION = model.createResource("http://mex.aksw.org/mex-algo#HyperParameterCollection");
            Resource mexalgo_TOOL_PARAM = model.createResource("http://mex.aksw.org/mex-algo#ToolParameter");
            Resource mexalgo_TOOL_PARAM_COLLECTION = model.createResource("http://mex.aksw.org/mex-algo#ToolParameterCollection");
            Resource mexperf_EXAMPLE_PERFORMANCE_COLLECTION = model.createResource("http://mex.aksw.org/mex-perf#ExamplePerformanceCollection");
            Resource mexperf_EXAMPLE_PERFORMANCE_MEASURE = model.createResource("http://mex.aksw.org/mex-perf#ExamplePerformanceMeasure");
            Resource mexperf_USER_DEFINED_PERFORMANCE_COLLECTION = model.createResource("http://mex.aksw.org/mex-perf#UserDefinedMeasureCollection");
            Resource mexperf_USER_DEFINED_PERFORMANCE_MEASURE = model.createResource("http://mex.aksw.org/mex-perf#UserDefinedMeasure");
            Resource _application = null;
            Resource _expHeader = null;
            if (mex.getApplicationContext() != null) {
                _application = model.createResource(mex.getApplicationContext().getIndividualName()).addProperty(RDFS.label, "Basic Experiment Infomation").addProperty(RDF.type, (RDFNode)mexcore_APC).addProperty(DCTerms.dateCopyrighted, new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z").format(mex.getApplicationContext().get_fileDate()));
                if (mex.getApplicationContext().get_givenName() != null) {
                    _application.addProperty(FOAF.givenName, mex.getApplicationContext().get_givenName());
                }
                if (mex.getApplicationContext().get_mbox() != null) {
                    _application.addProperty(FOAF.mbox, mex.getApplicationContext().get_mbox());
                }
                if (mex.getApplicationContext().get_homepage() != null) {
                    _application.addProperty(DOAP.homepage, mex.getApplicationContext().get_givenName());
                }
                if (mex.getApplicationContext().get_description() != null) {
                    _application.addProperty(DOAP.description, mex.getApplicationContext().get_mbox());
                }
                if (mex.getApplicationContext().get_category() != null) {
                    _application.addProperty(DOAP.category, mex.getApplicationContext().get_givenName());
                }
                if (mex.getApplicationContext().get_location() != null) {
                    _application.addProperty(DOAP.location, mex.getApplicationContext().get_mbox());
                }
                if (mex.getApplicationContext().get_trustyURI() != null) {
                    _application.addProperty(MEXCORE_10.trustyURI, mex.getApplicationContext().get_trustyURI());
                }
                if (mex.getApplicationContext().get_organization() != null) {
                    Resource _organization = model.createResource(URIbase + "org_" + mex.getUserHash()).addProperty(RDF.type, (RDFNode)provOrganization).addProperty(FOAF.givenName, mex.getApplicationContext().get_organization());
                    _application.addProperty(PROVO.actedOnBehalfOf, (RDFNode)_organization);
                }
                if (mex.getApplicationContext().getContext() != null && mex.getApplicationContext().getContext().get_context() != MEXEnum.EnumContexts.NOT_INFORMED) {
                    Resource mexcore_CON = model.createResource("http://mex.aksw.org/mex-core#" + mex.getApplicationContext().getContext().get_context().toString());
                    Resource mexcore_CONAux = model.createResource("http://mex.aksw.org/mex-core#Context");
                    Resource resource = model.createResource(mex.getApplicationContext().getContext().getIndividualName()).addProperty(RDF.type, (RDFNode)mexcore_CON).addProperty(RDF.type, (RDFNode)mexcore_CONAux).addProperty(RDFS.label, mex.getApplicationContext().getContext().getLabel()).addProperty(PROVO.wasAttributedTo, (RDFNode)_application);
                }
                Resource resource = model.createResource(URIbase + "version").addProperty(DCTerms.hasVersion, this.getVersion());
            }
            if (mex.getExperiment() != null) {
                _expHeader = model.createResource(mex.getExperiment().getIndividualName()).addProperty(RDF.type, (RDFNode)mexcore_EXP_HEADER).addProperty(MEXCORE_10.experimentHash, mex.getUserHash());
                if (StringUtils.isNotEmpty((CharSequence)mex.getExperiment().getId()) && StringUtils.isNotBlank((CharSequence)mex.getExperiment().getId())) {
                    _expHeader.addProperty(DCTerms.identifier, mex.getExperiment().getId());
                    _expHeader.addProperty(RDFS.label, "Experiment: " + mex.getExperiment().getId());
                }
                if (StringUtils.isNotEmpty((CharSequence)mex.getExperiment().getTitle()) && StringUtils.isNotBlank((CharSequence)mex.getExperiment().getTitle())) {
                    _expHeader.addProperty(DCTerms.title, mex.getExperiment().getTitle());
                }
                if (mex.getExperiment().getDate() != null) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z");
                    try {
                        df.setLenient(false);
                        df.parse(mex.getExperiment().getDate().toString());
                        _expHeader.addProperty(DCTerms.date, new SimpleDateFormat("yyyy.MM.dd HH:mm:ss z").format(mex.getExperiment().getDate()));
                    }
                    catch (ParseException mexcore_CONAux) {
                        // empty catch block
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)mex.getExperiment().getAttributeSelectionDescription()) && StringUtils.isNotBlank((CharSequence)mex.getExperiment().getAttributeSelectionDescription())) {
                    _expHeader.addProperty(MEXCORE_10.attributeSelectionDescription, mex.getExperiment().getAttributeSelectionDescription());
                }
                if (StringUtils.isNotEmpty((CharSequence)mex.getExperiment().getDataNormalizedDescription()) && StringUtils.isNotBlank((CharSequence)mex.getExperiment().getDataNormalizedDescription())) {
                    _expHeader.addProperty(MEXCORE_10.dataNormalizedDescription, mex.getExperiment().getDataNormalizedDescription());
                }
                if (StringUtils.isNotEmpty((CharSequence)mex.getExperiment().getNoiseRemovedDescription()) && StringUtils.isNotBlank((CharSequence)mex.getExperiment().getNoiseRemovedDescription())) {
                    _expHeader.addProperty(MEXCORE_10.noiseRemovedDescription, mex.getExperiment().getNoiseRemovedDescription());
                }
                if (StringUtils.isNotEmpty((CharSequence)mex.getExperiment().getOutliersRemovedDescription()) && StringUtils.isNotBlank((CharSequence)mex.getExperiment().getOutliersRemovedDescription())) {
                    _expHeader.addProperty(MEXCORE_10.outliersRemovedDescription, mex.getExperiment().getOutliersRemovedDescription());
                }
                if (StringUtils.isNotEmpty((CharSequence)mex.getExperiment().getDescription()) && StringUtils.isNotBlank((CharSequence)mex.getExperiment().getDescription())) {
                    _expHeader.addProperty(DCTerms.description, mex.getExperiment().getDescription());
                }
                if (mex.getApplicationContext() != null) {
                    _expHeader.addProperty(PROVO.wasAttributedTo, (RDFNode)_application);
                }
            }
            if (mex.getExperimentConfigurations() != null) {
                int auxExpConf = 0;
                for (ExperimentConfigurationVO item : mex.getExperimentConfigurations()) {
                    String auxIN;
                    Resource _expConfiguration = model.createResource(item.getIndividualName()).addProperty(RDF.type, (RDFNode)mexcore_EXP_CONF).addProperty(PROVO.wasStartedBy, (RDFNode)_expHeader).addProperty(RDFS.label, item.getLabel());
                    if (StringUtils.isNotEmpty((CharSequence)item.getId()) && StringUtils.isNotBlank((CharSequence)item.getId())) {
                        _expConfiguration.addProperty(DCTerms.identifier, item.getId());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)item.getDescription()) && StringUtils.isNotBlank((CharSequence)item.getDescription())) {
                        _expConfiguration.addProperty(DCTerms.description, item.getDescription());
                    }
                    if (item.Model() != null && item.Model().hasValue()) {
                        Resource _model;
                        String auxIN2 = this.objectCreatedBefore(item.Model(), auxExpConf, mex.getExperimentConfigurations());
                        if (StringUtils.isEmpty((CharSequence)auxIN2)) {
                            _model = model.createResource(item.Model().getIndividualName()).addProperty(RDF.type, (RDFNode)mexcore_MODEL);
                            if (StringUtils.isNotBlank((CharSequence)item.Model().getId()) && StringUtils.isNotEmpty((CharSequence)item.Model().getId())) {
                                _model.addProperty(DCTerms.identifier, item.Model().getId());
                            }
                            if (StringUtils.isNotBlank((CharSequence)item.Model().getDescription()) && StringUtils.isNotEmpty((CharSequence)item.Model().getDescription())) {
                                _model.addProperty(DCTerms.description, item.Model().getDescription());
                            }
                            if (item.Model().getDate() != null) {
                                _model.addProperty(DCTerms.date, item.Model().getDate().toString());
                            }
                        } else {
                            _model = model.getResource(auxIN2);
                        }
                        _expConfiguration.addProperty(PROVO.used, (RDFNode)_model);
                    }
                    Resource _imp = null;
                    if (item.Tool() != null && item.Tool().hasValue()) {
                        if (StringUtils.isNotBlank((CharSequence)item.Tool().getName()) && StringUtils.isNotEmpty((CharSequence)item.Tool().getName())) {
                            auxIN = this.objectCreatedBefore(item.Tool(), auxExpConf, mex.getExperimentConfigurations());
                            if (StringUtils.isEmpty((CharSequence)auxIN)) {
                                Resource _tool = model.createResource("http://mex.aksw.org/mex-algo#" + item.Tool().getName());
                                _imp = model.createResource(item.Tool().getIndividualName()).addProperty(RDFS.label, this.setLabelSplitingTerms(item.Tool().getName())).addProperty(RDF.type, (RDFNode)_tool);
                            } else {
                                _imp = model.getResource(auxIN);
                            }
                            _expConfiguration.addProperty(PROVO.used, (RDFNode)_imp);
                        }
                        if (item.getToolParameters() != null && item.getToolParameters().size() > 0) {
                            Resource _toolcollection = model.createResource(URIbase + "exp_cf_" + (auxExpConf + 1) + "_" + mex.getUserHash() + "_tool_param_collection").addProperty(RDF.type, (RDFNode)mexalgo_TOOL_PARAM_COLLECTION).addProperty(RDFS.label, "Tool Parameter Collection");
                            _expConfiguration.addProperty(PROVO.used, (RDFNode)_toolcollection);
                            for (ToolParameterVO toolParam : item.getToolParameters()) {
                                String auxIN3 = this.objectCreatedBefore(toolParam, auxExpConf, mex.getExperimentConfigurations());
                                Resource _toolParam = StringUtils.isEmpty((CharSequence)auxIN3) ? model.createResource(toolParam.getIndividualName()).addProperty(RDF.type, (RDFNode)mexalgo_TOOL_PARAM).addProperty(RDFS.label, toolParam.getLabel()).addProperty(PROVO.value, toolParam.getValue()).addProperty(DCTerms.identifier, toolParam.getId()) : model.getResource(auxIN3);
                                _imp.addProperty(MEXALGO_10.hasToolParameter, (RDFNode)_toolParam);
                                _toolcollection.addProperty(PROVO.hadMember, (RDFNode)_toolParam);
                            }
                        }
                    }
                    if (item.SamplingMethod() != null && item.SamplingMethod().hasValue()) {
                        Resource _sampling;
                        auxIN = this.objectCreatedBefore(item.SamplingMethod(), auxExpConf, mex.getExperimentConfigurations());
                        if (StringUtils.isEmpty((CharSequence)auxIN)) {
                            Resource mexcore_SAMPLING_METHOD = model.createResource("http://mex.aksw.org/mex-core#" + item.SamplingMethod().getClassName());
                            _sampling = model.createResource(item.SamplingMethod().getIndividualName()).addProperty(RDFS.label, item.SamplingMethod().getLabel()).addProperty(RDF.type, (RDFNode)mexcore_SAMPLING_METHOD);
                            if (item.SamplingMethod().getFolds() != null && StringUtils.isNotBlank((CharSequence)item.SamplingMethod().getFolds().toString()) && StringUtils.isNotEmpty((CharSequence)item.SamplingMethod().getFolds().toString())) {
                                _sampling.addProperty(MEXCORE_10.folds, item.SamplingMethod().getFolds().toString());
                            }
                            if (item.SamplingMethod().getSequential() != null && StringUtils.isNotBlank((CharSequence)item.SamplingMethod().getSequential().toString()) && StringUtils.isNotEmpty((CharSequence)item.SamplingMethod().getSequential().toString())) {
                                _sampling.addProperty(MEXCORE_10.sequential, item.SamplingMethod().getSequential().toString());
                            }
                            if (item.SamplingMethod().getTrainSize() != null && StringUtils.isNotBlank((CharSequence)item.SamplingMethod().getTrainSize().toString()) && StringUtils.isNotEmpty((CharSequence)item.SamplingMethod().getTrainSize().toString())) {
                                _sampling.addProperty(MEXCORE_10.trainSize, item.SamplingMethod().getTrainSize().toString());
                            }
                            if (item.SamplingMethod().getTestSize() != null && StringUtils.isNotBlank((CharSequence)item.SamplingMethod().getTestSize().toString()) && StringUtils.isNotEmpty((CharSequence)item.SamplingMethod().getTestSize().toString())) {
                                _sampling.addProperty(MEXCORE_10.testSize, item.SamplingMethod().getTestSize().toString());
                            }
                        } else {
                            _sampling = model.getResource(auxIN);
                        }
                        _expConfiguration.addProperty(PROVO.used, (RDFNode)_sampling);
                    }
                    if (item.HardwareConfiguration() != null && item.HardwareConfiguration().hasValue()) {
                        Resource _hardware;
                        auxIN = this.objectCreatedBefore(item.HardwareConfiguration(), auxExpConf, mex.getExperimentConfigurations());
                        if (StringUtils.isEmpty((CharSequence)auxIN)) {
                            _hardware = model.createResource(item.HardwareConfiguration().getIndividualName()).addProperty(RDF.type, (RDFNode)mexcore_HARDWARE);
                            if (StringUtils.isNotBlank((CharSequence)item.HardwareConfiguration().getOs()) && StringUtils.isNotEmpty((CharSequence)item.HardwareConfiguration().getOs())) {
                                _hardware.addProperty(DOAP.os, item.HardwareConfiguration().getOs());
                            }
                            if (StringUtils.isNotBlank((CharSequence)item.HardwareConfiguration().getCache()) && StringUtils.isNotEmpty((CharSequence)item.HardwareConfiguration().getCache())) {
                                _hardware.addProperty(MEXCORE_10.cache, item.HardwareConfiguration().getCache());
                            }
                            if (StringUtils.isNotBlank((CharSequence)item.HardwareConfiguration().getCPU()) && StringUtils.isNotEmpty((CharSequence)item.HardwareConfiguration().getCPU())) {
                                _hardware.addProperty(MEXCORE_10.cpu, item.HardwareConfiguration().getCPU());
                            }
                            if (StringUtils.isNotBlank((CharSequence)item.HardwareConfiguration().getMemory()) && StringUtils.isNotEmpty((CharSequence)item.HardwareConfiguration().getMemory())) {
                                _hardware.addProperty(MEXCORE_10.memory, item.HardwareConfiguration().getMemory());
                            }
                            if (StringUtils.isNotBlank((CharSequence)item.HardwareConfiguration().getHD()) && StringUtils.isNotEmpty((CharSequence)item.HardwareConfiguration().getHD())) {
                                _hardware.addProperty(MEXCORE_10.hd, item.HardwareConfiguration().getHD());
                            }
                            if (StringUtils.isNotBlank((CharSequence)item.HardwareConfiguration().getVideo()) && StringUtils.isNotEmpty((CharSequence)item.HardwareConfiguration().getVideo())) {
                                _hardware.addProperty(MEXCORE_10.video, item.HardwareConfiguration().getVideo());
                            }
                            _hardware.addProperty(RDFS.label, item.HardwareConfiguration().getLabel());
                        } else {
                            _hardware = model.getResource(auxIN);
                        }
                        _expConfiguration.addProperty(PROVO.used, (RDFNode)_hardware);
                    }
                    if (item.DataSet() != null && item.DataSet().hasValue()) {
                        Resource _dataset;
                        auxIN = this.objectCreatedBefore(item.DataSet(), auxExpConf, mex.getExperimentConfigurations());
                        if (StringUtils.isEmpty((CharSequence)auxIN)) {
                            _dataset = model.createResource(item.DataSet().getIndividualName()).addProperty(RDFS.label, "Dataset " + item.DataSet().getLabel()).addProperty(RDF.type, (RDFNode)mexcore_DATASET);
                            if (StringUtils.isNotBlank((CharSequence)item.DataSet().getName()) && StringUtils.isNotEmpty((CharSequence)item.DataSet().getName())) {
                                _dataset.addProperty(DCTerms.title, item.DataSet().getName());
                            }
                            if (StringUtils.isNotBlank((CharSequence)item.DataSet().getDescription()) && StringUtils.isNotEmpty((CharSequence)item.DataSet().getDescription())) {
                                _dataset.addProperty(DCTerms.description, item.DataSet().getDescription());
                            }
                            if (StringUtils.isNotBlank((CharSequence)item.DataSet().getURI()) && StringUtils.isNotEmpty((CharSequence)item.DataSet().getURI())) {
                                _dataset.addProperty(DCAT.landingPage, item.DataSet().getURI());
                            }
                        } else {
                            _dataset = model.getResource(auxIN);
                        }
                        _expConfiguration.addProperty(PROVO.used, (RDFNode)_dataset);
                    }
                    if (item.getFeatures() != null && item.getFeatures().size() > 0) {
                        Resource _featurecollection = model.createResource(URIbase + "fea_col_cf_" + (auxExpConf + 1) + "_" + mex.getUserHash()).addProperty(RDF.type, (RDFNode)mexcore_FEATURE_COLLECTION).addProperty(RDFS.label, "Feature Collection");
                        _expConfiguration.addProperty(PROVO.used, (RDFNode)_featurecollection);
                        int auxf = 1;
                        for (FeatureVO f : item.getFeatures()) {
                            if (f == null) continue;
                            Resource _feature = model.createResource(f.getIndividualName()).addProperty(RDF.type, (RDFNode)mexcore_FEATURE);
                            if (StringUtils.isNotBlank((CharSequence)f.getId()) && StringUtils.isNotEmpty((CharSequence)f.getId())) {
                                _feature.addProperty(DCTerms.identifier, f.getId());
                            }
                            if (StringUtils.isNotBlank((CharSequence)f.getName()) && StringUtils.isNotEmpty((CharSequence)f.getName())) {
                                _feature.addProperty(RDFS.label, f.getName());
                            }
                            ++auxf;
                            _featurecollection.addProperty(PROVO.hadMember, (RDFNode)_feature);
                        }
                    }
                    if (item.getExecutions() != null && item.getExecutions().size() > 0) {
                        int auxexecutions = 1;
                        for (Execution e : item.getExecutions()) {
                            Resource _exec = null;
                            if (e != null) {
                                _exec = model.createResource(e.getIndividualName());
                                Resource mexcore_EXEC = null;
                                if (e instanceof ExecutionIndividualVO) {
                                    mexcore_EXEC = model.createResource("http://mex.aksw.org/mex-core#ExecutionSingle");
                                    _exec.addProperty(RDF.type, (RDFNode)mexcore_EXEC);
                                    _exec.addProperty(RDFS.label, "Single Execution: " + e.getId());
                                } else if (e instanceof ExecutionSetVO) {
                                    mexcore_EXEC = model.createResource("http://mex.aksw.org/mex-core#ExecutionOverall");
                                    _exec.addProperty(RDF.type, (RDFNode)mexcore_EXEC);
                                    _exec.addProperty(RDFS.label, "Overall Execution: " + e.getId());
                                } else {
                                    throw new Exception("Execution type unknown!");
                                }
                                _exec.addProperty(PROVO.id, e.getId());
                                if (e.getErrorMessage() != null) {
                                    _exec.addProperty(MEXCORE_10.executionErrorMessage, e.getErrorMessage().toString());
                                }
                                if (e.getStartedAtTime() != null) {
                                    _exec.addProperty(PROVO.startedAtTime, e.getStartedAtTime().toString());
                                }
                                if (e.getEndedAtTime() != null) {
                                    _exec.addProperty(PROVO.endedAtTime, e.getEndedAtTime().toString());
                                }
                                if (e.getTargetClass() != null && StringUtils.isNotEmpty((CharSequence)e.getTargetClass()) && StringUtils.isNotBlank((CharSequence)e.getTargetClass())) {
                                    _exec.addProperty(MEXCORE_10.targetClass, e.getTargetClass());
                                }
                                if (e instanceof ExecutionSetVO) {
                                    ExecutionSetVO temp = (ExecutionSetVO)e;
                                    if (temp.getStartsAtPosition() != null) {
                                        _exec.addProperty(MEXCORE_10.startsAtPosition, temp.getStartsAtPosition());
                                    }
                                    if (temp.getEndsAtPosition() != null) {
                                        _exec.addProperty(MEXCORE_10.endsAtPosition, temp.getEndsAtPosition());
                                    }
                                    _exec.addProperty(MEXCORE_10.group, (RDFNode)model.createTypedLiteral("true", (RDFDatatype)XSDDatatype.XSDboolean));
                                } else {
                                    _exec.addProperty(MEXCORE_10.group, (RDFNode)model.createTypedLiteral("false", (RDFDatatype)XSDDatatype.XSDboolean));
                                }
                                if (e.getPhase() != null) {
                                    Resource _phase;
                                    String auxIN4 = this.objectCreatedBefore(e.getPhase(), auxExpConf, mex.getExperimentConfigurations());
                                    if (StringUtils.isEmpty((CharSequence)auxIN4)) {
                                        Resource mexcore_PHASE = model.createResource("http://mex.aksw.org/mex-core#" + e.getPhase().getName());
                                        if (StringUtils.isNotBlank((CharSequence)e.getPhase().getName().toString()) && StringUtils.isNotEmpty((CharSequence)e.getPhase().getName().toString())) {
                                            _phase = model.createResource(e.getPhase().getIndividualName()).addProperty(RDFS.label, e.getPhase().getLabel()).addProperty(RDF.type, (RDFNode)mexcore_PHASE);
                                            _exec.addProperty(PROVO.used, (RDFNode)_phase);
                                        }
                                    } else {
                                        _phase = model.getResource(auxIN4);
                                        _exec.addProperty(PROVO.used, (RDFNode)_phase);
                                    }
                                }
                                if (e.getExamples() != null && e.getExamples().size() > 0) {
                                    Resource _examplecollection = model.createResource(URIbase + "exa_col__cf_" + (auxExpConf + 1) + "_exe_" + String.valueOf(auxexecutions) + "_" + mex.getUserHash()).addProperty(RDF.type, (RDFNode)mexcore_EXAMPLE_COLLECTION).addProperty(RDFS.label, "Example Collection");
                                    _exec.addProperty(PROVO.used, (RDFNode)_examplecollection);
                                    Integer auxex = 1;
                                    for (ExampleVO example : e.getExamples()) {
                                        if (example == null) continue;
                                        Resource resource = model.createResource(example.getIndividualName()).addProperty(RDFS.label, "Dataset Example " + example.getId()).addProperty(RDF.type, (RDFNode)mexcore_EXAMPLE).addProperty(DCTerms.identifier, example.getId()).addProperty(PROVO.value, example.getValue());
                                        if (example.getDatasetColumn() != 0L) {
                                            resource.addProperty(MEXCORE_10.datasetColumn, String.valueOf(example.getDatasetColumn()));
                                        }
                                        if (example.getDatasetRow() != 0L) {
                                            resource.addProperty(MEXCORE_10.datasetRow, String.valueOf(example.getDatasetRow()));
                                        }
                                        if (StringUtils.isNotEmpty((CharSequence)example.getExampleType())) {
                                            resource.addProperty(MEXCORE_10.exampleType, String.valueOf(example.getExampleType()));
                                        }
                                        _examplecollection.addProperty(PROVO.hadMember, (RDFNode)resource);
                                        Integer n = auxex;
                                        Integer n2 = auxex = Integer.valueOf(auxex + 1);
                                    }
                                }
                                if (e.getAlgorithm() != null) {
                                    Resource _alg = model.createResource(e.getAlgorithm().getIndividualName()).addProperty(RDF.type, (RDFNode)mexalgo_ALGO);
                                    if (StringUtils.isNotBlank((CharSequence)e.getAlgorithm().getClassName()) && StringUtils.isNotEmpty((CharSequence)e.getAlgorithm().getClassName())) {
                                        Resource _algClass = model.createResource("http://mex.aksw.org/mex-algo#" + e.getAlgorithm().getClassName());
                                        _algClass.addProperty(RDFS.label, this.setLabelSplitingTerms(e.getAlgorithm().getClassName()));
                                        _alg.addProperty(MEXALGO_10.hasAlgorithmClass, (RDFNode)_algClass);
                                        _alg.addProperty(RDFS.label, this.setLabelSplitingTerms(e.getAlgorithm().getClassName()));
                                    } else if (StringUtils.isNotBlank((CharSequence)e.getAlgorithm().getLabel()) && StringUtils.isNotEmpty((CharSequence)e.getAlgorithm().getLabel())) {
                                        _alg.addProperty(RDFS.label, e.getAlgorithm().getLabel());
                                    }
                                    _exec.addProperty(PROVO.used, (RDFNode)_alg);
                                    if (StringUtils.isNotBlank((CharSequence)e.getAlgorithm().getIdentifier()) && StringUtils.isNotEmpty((CharSequence)e.getAlgorithm().getIdentifier())) {
                                        _alg.addProperty(DCTerms.identifier, e.getAlgorithm().getIdentifier());
                                    }
                                    if (e.getAlgorithm().getURI() != null && StringUtils.isNotBlank((CharSequence)e.getAlgorithm().getURI().toURL().toString()) && StringUtils.isNotEmpty((CharSequence)e.getAlgorithm().getURI().toURL().toString())) {
                                        _alg.addProperty(DCAT.landingPage, e.getAlgorithm().getURI().toURL().toString());
                                    }
                                    if (StringUtils.isNotBlank((CharSequence)e.getAlgorithm().getAcronym()) && StringUtils.isNotEmpty((CharSequence)e.getAlgorithm().getAcronym())) {
                                        _alg.addProperty(MEXALGO_10.acronym, e.getAlgorithm().getAcronym());
                                    }
                                    _exec.addProperty(PROVO.used, (RDFNode)_alg);
                                    if (e.getAlgorithm().getParameters() != null && e.getAlgorithm().getParameters().size() > 0) {
                                        Resource _hypercollection = model.createResource(URIbase + "hyperp_colcf" + (auxExpConf + 1) + "_" + mex.getUserHash()).addProperty(RDF.type, (RDFNode)mexalgo_HYPER_PARAM_COLLECTION).addProperty(RDFS.label, "HyperParameter Collection");
                                        _exec.addProperty(PROVO.used, (RDFNode)_hypercollection);
                                        for (HyperParameterVO algoParam : e.getAlgorithm().getParameters()) {
                                            if (algoParam == null) continue;
                                            Object var46_57 = null;
                                            Resource resource = model.createResource(algoParam.getIndividualName()).addProperty(RDF.type, (RDFNode)mexalgo_HYPER_PARAM).addProperty(RDFS.label, algoParam.getLabel()).addProperty(PROVO.value, algoParam.getValue()).addProperty(DCTerms.identifier, algoParam.getIdentifier());
                                            _alg.addProperty(MEXALGO_10.hasHyperParameter, (RDFNode)resource);
                                            _hypercollection.addProperty(PROVO.hadMember, (RDFNode)resource);
                                        }
                                    }
                                }
                                if (e.getPerformances() != null && e.getPerformances().size() > 0) {
                                    List<Measure> UserDefinedList;
                                    for (Measure mea : e.getPerformances()) {
                                        if (mea == null) continue;
                                        Resource mexperf_klass = null;
                                        Resource mexperf_cla = null;
                                        Object var46_59 = null;
                                        Object var47_66 = null;
                                        Resource mexperf_sta = null;
                                        Object mexperf_custom = null;
                                        Object mexperf_example = null;
                                        Resource mexperf_ins = null;
                                        Resource mexperf_cla_ins = null;
                                        Resource mexperf_reg_ins = null;
                                        Resource mexperf_clu_ins = null;
                                        Resource mexperf_sta_ins = null;
                                        Object mexperf_custom_ins = null;
                                        Object mexperf_example_ins = null;
                                        if (mea instanceof ClassificationMeasureVO) {
                                            if (mexperf_cla == null) {
                                                mexperf_cla_ins = model.createResource(mea.getIndividualName());
                                                mexperf_cla = model.createResource("http://mex.aksw.org/mex-perf#ClassificationMeasure");
                                            }
                                            mexperf_klass = mexperf_cla;
                                            mexperf_ins = mexperf_cla_ins;
                                        } else if (mea instanceof RegressionMeasureVO) {
                                            void var46_61;
                                            if (var46_59 == null) {
                                                mexperf_reg_ins = model.createResource(mea.getIndividualName());
                                                Resource resource = model.createResource("http://mex.aksw.org/mex-perf#RegressionMeasure");
                                            }
                                            mexperf_klass = var46_61;
                                            mexperf_ins = mexperf_reg_ins;
                                        } else if (mea instanceof ClusteringMeasureVO) {
                                            void var47_68;
                                            if (var47_66 == null) {
                                                mexperf_clu_ins = model.createResource(mea.getIndividualName());
                                                Resource resource = model.createResource("http://mex.aksw.org/mex-perf#ClusteringMeasure");
                                            }
                                            mexperf_klass = var47_68;
                                            mexperf_ins = mexperf_clu_ins;
                                        } else if (mea instanceof StatisticalMeasureVO) {
                                            if (mexperf_sta == null) {
                                                mexperf_sta_ins = model.createResource(mea.getIndividualName());
                                                mexperf_sta = model.createResource("http://mex.aksw.org/mex-perf#StatisticalMeasure");
                                            }
                                            mexperf_klass = mexperf_sta;
                                            mexperf_ins = mexperf_sta_ins;
                                        }
                                        mexperf_ins.addProperty(RDF.type, (RDFNode)mexperf_klass);
                                        mexperf_ins.addProperty(RDFS.label, mea.getLabel());
                                        mexperf_ins.addProperty(model.createProperty("http://mex.aksw.org/mex-perf#" + mea.getName()), (RDFNode)model.createTypedLiteral((Object)mea.getValue()));
                                        mexperf_ins.addProperty(PROVO.wasGeneratedBy, (RDFNode)_exec);
                                        _exec.addProperty(PROVO.generated, (RDFNode)mexperf_ins);
                                    }
                                    List<Measure> examplePerformanceList = e.getPerformances(ExamplePerformanceMeasureVO.class);
                                    if (examplePerformanceList != null && examplePerformanceList.size() > 0) {
                                        Resource _examplePerformanceCollection = model.createResource(URIbase + "exa_perf_col_cf_" + (auxExpConf + 1) + "_" + mex.getUserHash()).addProperty(RDF.type, (RDFNode)mexperf_EXAMPLE_PERFORMANCE_COLLECTION).addProperty(RDFS.label, "Dataset Example Performance").addProperty(PROVO.wasGeneratedBy, (RDFNode)_exec);
                                        _exec.addProperty(PROVO.generated, (RDFNode)_examplePerformanceCollection);
                                        int auxep = 1;
                                        for (ExamplePerformanceMeasureVO examplePerformanceMeasureVO : examplePerformanceList) {
                                            if (examplePerformanceMeasureVO == null) continue;
                                            Resource resource = model.createResource(examplePerformanceMeasureVO.getIndividualName()).addProperty(RDF.type, (RDFNode)mexperf_EXAMPLE_PERFORMANCE_MEASURE);
                                            if (StringUtils.isNotBlank((CharSequence)examplePerformanceMeasureVO.getId()) && StringUtils.isNotEmpty((CharSequence)examplePerformanceMeasureVO.getId())) {
                                                resource.addProperty(DCTerms.identifier, examplePerformanceMeasureVO.getId());
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)examplePerformanceMeasureVO.getPredictedValue()) && StringUtils.isNotEmpty((CharSequence)examplePerformanceMeasureVO.getPredictedValue())) {
                                                resource.addProperty(MEXPERF_10.predictedValue, examplePerformanceMeasureVO.getPredictedValue());
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)examplePerformanceMeasureVO.getRealValue()) && StringUtils.isNotEmpty((CharSequence)examplePerformanceMeasureVO.getRealValue())) {
                                                resource.addProperty(MEXPERF_10.realValue, examplePerformanceMeasureVO.getRealValue());
                                            }
                                            ++auxep;
                                            _examplePerformanceCollection.addProperty(PROVO.hadMember, (RDFNode)resource);
                                        }
                                    }
                                    if ((UserDefinedList = e.getPerformances(UserDefinedMeasureVO.class)) != null && UserDefinedList.size() > 0) {
                                        Resource _userDefinedCollection = model.createResource(URIbase + "userdef_perf_col_cf_" + (auxExpConf + 1) + "_" + mex.getUserHash()).addProperty(RDF.type, (RDFNode)mexperf_USER_DEFINED_PERFORMANCE_COLLECTION).addProperty(PROVO.wasGeneratedBy, (RDFNode)_exec);
                                        _exec.addProperty(PROVO.generated, (RDFNode)_userDefinedCollection);
                                        int auxudf = 1;
                                        for (UserDefinedMeasureVO userDefinedMeasureVO : UserDefinedList) {
                                            if (userDefinedMeasureVO == null) continue;
                                            Resource _userdefPerf = model.createResource(userDefinedMeasureVO.getIndividualName()).addProperty(RDF.type, (RDFNode)mexperf_USER_DEFINED_PERFORMANCE_MEASURE).addProperty(RDFS.label, "User Defined Measure");
                                            if (StringUtils.isNotBlank((CharSequence)userDefinedMeasureVO.getId()) && StringUtils.isNotEmpty((CharSequence)userDefinedMeasureVO.getId())) {
                                                _userdefPerf.addProperty(DCTerms.identifier, userDefinedMeasureVO.getId());
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)userDefinedMeasureVO.getValue().toString()) && StringUtils.isNotEmpty((CharSequence)userDefinedMeasureVO.getValue().toString())) {
                                                _userdefPerf.addProperty(PROVO.value, userDefinedMeasureVO.getValue().toString());
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)userDefinedMeasureVO.getDescription()) && StringUtils.isNotEmpty((CharSequence)userDefinedMeasureVO.getDescription())) {
                                                _userdefPerf.addProperty(DCTerms.description, userDefinedMeasureVO.getDescription());
                                            }
                                            if (StringUtils.isNotBlank((CharSequence)userDefinedMeasureVO.getFormula()) && StringUtils.isNotEmpty((CharSequence)userDefinedMeasureVO.getFormula())) {
                                                _userdefPerf.addProperty(MEXPERF_10.formula, userDefinedMeasureVO.getFormula());
                                            }
                                            ++auxudf;
                                            _userDefinedCollection.addProperty(PROVO.hadMember, (RDFNode)_userdefPerf);
                                        }
                                    }
                                }
                            }
                            ++auxexecutions;
                            _exec.addProperty(PROVO.wasInformedBy, (RDFNode)_expConfiguration);
                        }
                    }
                    ++auxExpConf;
                }
            }
            FileWriter out = new FileWriter(filename + "." + format.toString().toLowerCase().replace("/", "").replace(".", "").replace("-", ""));
            model.write((Writer)out, format.toString());
            out.close();
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            throw e;
        }
    }

    private String getVersion() {
        String path = "/version.prop";
        InputStream stream = this.getClass().getClass().getResourceAsStream(path);
        if (stream == null) {
            return "UNKNOWN";
        }
        Properties props = new Properties();
        try {
            props.load(stream);
            stream.close();
            return (String)props.get("version");
        }
        catch (IOException e) {
            return "UNKNOWN";
        }
    }

    private String setLabelSplitingTerms(String value) {
        String auxLabel = "";
        if (!value.isEmpty()) {
            auxLabel = value.substring(0, 1);
            for (int i = 1; i < value.length(); ++i) {
                if (!value.substring(i, i + 1).toString().isEmpty() && value.substring(i, i + 1).toString().toUpperCase().equals(value.substring(i, i + 1).toString())) {
                    if (i != value.length() - 1 && !value.substring(i + 1, i + 2).toString().toUpperCase().equals(value.substring(i + 1, i + 2).toString())) {
                        if (!value.substring(i, i + 1).matches("[0-9]")) {
                            auxLabel = auxLabel + " " + value.substring(i, i + 1).toString();
                            continue;
                        }
                        auxLabel = auxLabel + value.substring(i, i + 1).toString();
                        continue;
                    }
                    auxLabel = auxLabel + value.substring(i, i + 1).toString();
                    continue;
                }
                auxLabel = auxLabel + value.substring(i, i + 1).toString();
            }
        }
        auxLabel = auxLabel.replace("_", " ");
        return auxLabel;
    }

    public void saveToDisk(String filename, String URIbase, MyMEX mex, MEXConstant.EnumRDFFormats format) throws Exception {
        try {
            if (!this.parse(mex)) {
                throw new Exception("The MEX file could not be generated. Please see the log for more details");
            }
            mex.setUserHash();
            this.updateInstanceNames(URIbase, mex);
            this.writeJena(filename, URIbase, mex, format);
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            throw new Exception(e);
        }
    }

    public void parseAndSave(String filename, String URIbase, MyMEX mex, MEXConstant.EnumRDFFormats format) throws Exception {
        this.writeJena(filename, URIbase, mex, format);
    }

    protected String objectCreatedBefore(Object obj, int current, List<ExperimentConfigurationVO> conf) throws Exception {
        String ind = "";
        if (current == 0 || conf == null || conf.size() == 1) {
            return "";
        }
        for (int i = 0; i < current; ++i) {
            ExperimentConfigurationVO item = conf.get(i);
            if (obj instanceof ModelVO && item.Model().equals(obj)) {
                ind = item.Model().getId();
                return ind;
            }
            if (obj instanceof SamplingMethodVO && item.SamplingMethod().equals(obj)) {
                ind = item.SamplingMethod().getIndividualName();
                return ind;
            }
            if (obj instanceof PhaseVO && item.Phase().equals(obj)) {
                ind = item.Phase().getIndividualName();
                return ind;
            }
            if (obj instanceof HardwareConfigurationVO && item.HardwareConfiguration().equals(obj)) {
                ind = item.HardwareConfiguration().getIndividualName();
                return ind;
            }
            if (obj instanceof ToolVO && item.Tool().equals(obj)) {
                ind = item.Tool().getIndividualName();
                return ind;
            }
            if (obj instanceof DataSetVO && item.DataSet().equals(obj)) {
                ind = item.DataSet().getIndividualName();
                return ind;
            }
            if (obj instanceof ToolParameterVO) {
                List<ToolParameterVO> lstToolParameter = item.getToolParameters();
                if (lstToolParameter == null) continue;
                for (ToolParameterVO toolParameter : lstToolParameter) {
                    if (!toolParameter.equals(obj)) continue;
                    ind = toolParameter.getIndividualName();
                    return ind;
                }
                continue;
            }
            if (!(obj instanceof PhaseVO)) continue;
        }
        return ind;
    }
}

