/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.mex.log4mex;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.aksw.mex.log4mex.Execution;
import org.aksw.mex.log4mex.InstanceObjects;
import org.aksw.mex.log4mex.algo.AlgorithmVO;
import org.aksw.mex.log4mex.algo.ToolParameterVO;
import org.aksw.mex.log4mex.algo.ToolVO;
import org.aksw.mex.log4mex.core.DataSetVO;
import org.aksw.mex.log4mex.core.ExecutionIndividualVO;
import org.aksw.mex.log4mex.core.ExecutionSetVO;
import org.aksw.mex.log4mex.core.FeatureVO;
import org.aksw.mex.log4mex.core.HardwareConfigurationVO;
import org.aksw.mex.log4mex.core.ModelVO;
import org.aksw.mex.log4mex.core.PhaseVO;
import org.aksw.mex.log4mex.core.SamplingMethodVO;
import org.aksw.mex.util.MEXController;
import org.aksw.mex.util.MEXEnum;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentConfigurationVO
extends InstanceObjects {
    private String _id;
    private String _description;
    private Integer _seq = 0;
    private ModelVO _model;
    private PhaseVO _phase;
    private SamplingMethodVO _sampling;
    private HardwareConfigurationVO _hard;
    private DataSetVO _ds;
    private ToolVO _tool;
    private List<ToolParameterVO> _toolParameters;
    private List<Execution> _executions;
    private List<FeatureVO> _features;
    private List<AlgorithmVO> _algorithms;
    private int _maxLabel = 30;
    private static String _userHash;
    private static final Logger LOGGER;

    public ExperimentConfigurationVO(String id, String description, Integer sequential) {
        this._id = id;
        this._description = description;
        this._executions = new ArrayList<Execution>();
        this._features = new ArrayList<FeatureVO>();
        this._algorithms = new ArrayList<AlgorithmVO>();
        this._label = this._description + "...";
        if (this._label.length() > this._maxLabel) {
            this._label = this._label.substring(0, this._maxLabel - 1) + "...";
        }
        this._seq = sequential;
        this._individualName = "exp_cf_" + sequential.toString() + "_";
        this._label = "Configuration for a set of Executions";
    }

    public ExperimentConfigurationVO(String id, Integer sequential) {
        this._id = id;
        this._executions = new ArrayList<Execution>();
        this._features = new ArrayList<FeatureVO>();
        this._algorithms = new ArrayList<AlgorithmVO>();
        this._seq = sequential;
        this._individualName = "exp_cf_" + sequential.toString() + "_";
        this._label = "Configuration for a set of Executions";
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    public String getId() {
        return this._id;
    }

    public String getDescription() {
        return this._description;
    }

    public ModelVO Model() {
        if (this._model == null) {
            this._model = new ModelVO();
            this._model.setIndividualName("mod_cf_" + this._seq + "_");
        }
        return this._model;
    }

    public PhaseVO Phase() {
        if (this._phase == null) {
            this._phase = new PhaseVO(MEXEnum.EnumPhases.NOT_INFORMED);
            this._phase.setIndividualName("phase_cf_" + this._seq + "_");
        }
        return this._phase;
    }

    public SamplingMethodVO SamplingMethod() {
        try {
            if (this._sampling == null) {
                this.setSamplingMethod(MEXEnum.EnumSamplingMethods.NOT_INFORMED, null);
                this._sampling.setIndividualName("sm_cf_" + this._seq + "_");
            }
            return this._sampling;
        }
        catch (Exception e) {
            return null;
        }
    }

    public HardwareConfigurationVO HardwareConfiguration() {
        try {
            if (this._hard == null) {
                this.setHardwareConfiguration(null, MEXEnum.EnumProcessors.NOT_INFORMED, MEXEnum.EnumRAM.NOT_INFORMED, null, MEXEnum.EnumCaches.NOT_INFORMED);
                this._hard.setIndividualName("hard_cf_" + this._seq + "_");
            }
            return this._hard;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ToolVO Tool() {
        try {
            if (this._tool == null) {
                this.setTool("", null);
            }
            return this._tool;
        }
        catch (Exception e) {
            return null;
        }
    }

    public DataSetVO DataSet() {
        if (this._ds == null) {
            this._ds = new DataSetVO();
            this._ds.setIndividualName("ds_cf_" + this._seq + "_");
        }
        return this._ds;
    }

    public AlgorithmVO Algorithm(MEXEnum.EnumAlgorithmsClasses algo) {
        if (this._algorithms == null) {
            this._algorithms = new ArrayList<AlgorithmVO>();
        }
        AlgorithmVO ret = null;
        try {
            Collection t = Collections2.filter(this._algorithms, p -> p.getClassName().equals(algo.name()));
            if (t != null && t.size() > 0) {
                ret = (AlgorithmVO)Iterables.get((Iterable)t, (int)0);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return ret;
    }

    public AlgorithmVO Algorithm(String algoInstanceName) {
        if (this._algorithms == null) {
            this._algorithms = new ArrayList<AlgorithmVO>();
        }
        AlgorithmVO ret = null;
        try {
            Collection t = Collections2.filter(this._algorithms, p -> p.getIndividualName().equals(algoInstanceName));
            if (t != null && t.size() > 0) {
                ret = (AlgorithmVO)Iterables.get((Iterable)t, (int)0);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return ret;
    }

    public Execution Execution(String id) {
        Execution ret = null;
        try {
            Collection t = Collections2.filter(this._executions, p -> p._id.equals(id));
            if (t != null && t.size() > 0) {
                ret = (Execution)Iterables.get((Iterable)t, (int)0);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return ret;
    }

    protected List<AlgorithmVO> getAlgorithms() {
        return this._algorithms;
    }

    protected List<FeatureVO> getFeatures() {
        return this._features;
    }

    protected List<ToolParameterVO> getToolParameters() {
        return this._toolParameters;
    }

    protected List<Execution> getExecutions() {
        return this._executions;
    }

    public void setId(String _id) {
        this._id = _id;
    }

    public void setDescription(String _description) {
        this._description = _description;
        this._label = _description + "...";
        if (this._label.length() > this._maxLabel) {
            this._label = this._label.substring(0, this._maxLabel - 1) + "...";
        }
    }

    public void setExecutionStartTime(String executionId, Date value) {
        try {
            Collection t = Collections2.filter(this._executions, p -> p._id.equals(executionId));
            if (t != null && t.size() > 0) {
                ((Execution)Iterables.get((Iterable)t, (int)0)).setStartDate(value);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void setExecutionEndTime(String executionId, Date value) {
        try {
            Collection t = Collections2.filter(this._executions, p -> p._id.equals(executionId));
            if (t != null && t.size() > 0) {
                ((Execution)Iterables.get((Iterable)t, (int)0)).setEndDate(value);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void setExecutionId(Integer index, String id) {
        this._executions.get((int)index.intValue())._id = id;
    }

    public String addExecution(MEXEnum.EnumExecutionsType type, MEXEnum.EnumPhases phase) throws Exception {
        Integer total = this._executions.size() + 1;
        if (type.toString().equals(MEXEnum.EnumExecutionsType.SINGLE.toString())) {
            this._executions.add(new ExecutionIndividualVO(this, "C" + this._seq.toString() + "_" + "MEX_EXEC_D" + String.valueOf(total), new PhaseVO(phase)));
        }
        if (type.toString().equals(MEXEnum.EnumExecutionsType.OVERALL.toString())) {
            this._executions.add(new ExecutionSetVO(this, "C" + this._seq.toString() + "_" + "MEX_EXEC_D" + String.valueOf(total), new PhaseVO(phase)));
        }
        String execCode = "C" + this._seq.toString() + "_" + "MEX_EXEC_D" + total.toString();
        LOGGER.debug(execCode);
        return execCode;
    }

    public void addToolParameters(String key, String value) throws Exception {
        try {
            Collection t;
            if (this._toolParameters == null) {
                this._toolParameters = new ArrayList<ToolParameterVO>();
            }
            if ((t = Collections2.filter(this._toolParameters, p -> p.getId().equals(key))) != null && t.size() > 0) {
                throw new Exception("Tool parameter key " + key + " already assigned");
            }
            ToolParameterVO tp = new ToolParameterVO(key, value);
            this._toolParameters.add(tp);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private void _addFeatures(String[] featuresName) {
        if (this._features == null) {
            this._features = new ArrayList<FeatureVO>();
        }
        for (String feature : featuresName) {
            try {
                Collection t = Collections2.filter(this._features, p -> p.getId().equals(feature));
                if (t != null && t.size() > 0) {
                    throw new Exception("Features already assigned");
                }
                this._features.add(new FeatureVO(String.valueOf(this._features.size() + 1), feature));
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
        }
    }

    public void addFeature(String featureName) {
        this._addFeatures(new String[]{featureName});
    }

    public void addFeature(String[] featuresName) {
        this._addFeatures(featuresName);
    }

    public void setSamplingMethod(MEXEnum.EnumSamplingMethods sm, Double train, Double test) throws Exception {
        try {
            if (this._sampling == null) {
                this._sampling = new SamplingMethodVO(sm, train, test);
                MEXController.getInstance().addSamplingMethodCounter();
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void setSamplingMethod(MEXEnum.EnumSamplingMethods sm, Integer folds) throws Exception {
        try {
            if (this._sampling == null) {
                this._sampling = new SamplingMethodVO(sm);
                if (folds != null) {
                    this._sampling.setFolds(folds);
                }
                MEXController.getInstance().addSamplingMethodCounter();
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void setModel(String id, String description, Date date) {
        if (this._model == null) {
            this._model = new ModelVO();
        }
        this._model.setDate(date);
        this._model.setDescription(description);
        this._model.setId(id);
    }

    public void setModel(String id, String description) {
        if (this._model == null) {
            this._model = new ModelVO();
        }
        this._model.setDescription(description);
        this._model.setId(id);
    }

    public void setModel(String id) {
        if (this._model == null) {
            this._model = new ModelVO();
        }
        this._model.setId(id);
    }

    public void setHardwareConfiguration(String os, MEXEnum.EnumProcessors cpu, MEXEnum.EnumRAM mb, String hd, MEXEnum.EnumCaches cache) {
        if (this._hard == null) {
            this._hard = new HardwareConfigurationVO();
        }
        this._hard.setCache(cache);
        this._hard.setOperationalSystem(os);
        this._hard.setCPU(cpu);
        this._hard.setMemory(mb);
        this._hard.setHD(hd);
    }

    public void setDataSet(String URI2, String description, String name) {
        if (this._ds == null) {
            this._ds = new DataSetVO();
        }
        this._ds.setDescription(description);
        this._ds.setName(name);
        this._ds.setURI(URI2);
    }

    public void setDataSet(String URI2, String name) {
        if (this._ds == null) {
            this._ds = new DataSetVO();
        }
        this._ds.setName(name);
        this._ds.setURI(URI2);
    }

    public void setTool(MEXEnum.EnumTools name, String version) {
        if (this._tool == null) {
            this._tool = new ToolVO();
        }
        this._tool.setRevision(version);
        this._tool.setName(name.name());
    }

    public void setTool(String name, String version) {
        if (this._tool == null) {
            this._tool = new ToolVO();
        }
        this._tool.setRevision(version);
        this._tool.setName(name);
    }

    public String addAlgorithm(String algorithmId, URI algorithmURI) throws Exception {
        return this._addAlgorithm(algorithmId, null, null, algorithmURI, null).getIndividualName();
    }

    public String addAlgorithm(String algorithmId, String algorithmLabel) throws Exception {
        return this._addAlgorithm(algorithmId, algorithmLabel, null, null, null).getIndividualName();
    }

    public String addAlgorithm(String algorithmId, String algorithmName, URI algorithmURI) throws Exception {
        return this._addAlgorithm(algorithmId, algorithmName, null, algorithmURI, null).getIndividualName();
    }

    public String addAlgorithm(String algorithmId, MEXEnum.EnumAlgorithmsClasses algorithmClass) throws Exception {
        return this._addAlgorithm(algorithmId, null, algorithmClass, null, null).getIndividualName();
    }

    public String addAlgorithm(String algorithmId, MEXEnum.EnumAlgorithmsClasses algorithmClass, String algorithmLabel) throws Exception {
        return this._addAlgorithm(algorithmId, algorithmLabel, algorithmClass, null, null).getIndividualName();
    }

    public String addAlgorithm(String algorithmId, String algorithmName, MEXEnum.EnumAlgorithmsClasses algorithmClass, URI algorithmURI) throws Exception {
        return this._addAlgorithm(algorithmId, algorithmName, algorithmClass, algorithmURI, null).getIdentifier();
    }

    public String addAlgorithm(String algorithmId, String algorithmLabel, MEXEnum.EnumAlgorithmsClasses algorithmClass, URI algorithmURI, String algorithmAcronym) throws Exception {
        return this._addAlgorithm(algorithmId, algorithmLabel, algorithmClass, algorithmURI, algorithmAcronym).getIndividualName();
    }

    public String addAlgorithm(String algorithmId, URI algorithmURI, MEXEnum.EnumAlgorithmsClasses algorithmClass) throws Exception {
        return this._addAlgorithm(algorithmId, null, algorithmClass, algorithmURI, null).getIndividualName();
    }

    private AlgorithmVO _addAlgorithm(String id, String algorithmLabel, MEXEnum.EnumAlgorithmsClasses algorithmClass, URI algorithmURI, String algorithmAcronym) throws Exception {
        AlgorithmVO algo = null;
        String klass = "";
        try {
            try {
                if (algorithmClass != null && StringUtils.isNotEmpty((CharSequence)algorithmClass.name())) {
                    MEXEnum.EnumAlgorithmsClasses.valueOf((String)algorithmClass.toString());
                    klass = algorithmClass.name().toString();
                }
            }
            catch (Exception e) {
                throw new Exception(algorithmClass.toString() + " does not exist in MEXEnum.EnumAlgorithmsClasses. Please, check the method you're invoking...");
            }
            if (this._algorithms == null) {
                this._algorithms = new ArrayList<AlgorithmVO>();
            }
            String idaux = "Algorithm".toLowerCase() + String.valueOf(MEXController.getInstance().getNumberOfAlgorithms() + 1);
            if (id == "") {
                id = idaux;
            }
            if (algorithmLabel == null || algorithmLabel == "") {
                algorithmLabel = idaux;
            }
            algo = new AlgorithmVO(id, algorithmAcronym, algorithmLabel, algorithmURI, klass);
            this._algorithms.add(algo);
            MEXController.getInstance().addAlgorithmCounter();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return algo;
    }

    @Override
    public boolean equals(Object other) {
        return false;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    static {
        LOGGER = LoggerFactory.getLogger(ExperimentConfigurationVO.class);
    }
}

