/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.mex.log4mex;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.aksw.mex.log4mex.ExperimentConfigurationVO;
import org.aksw.mex.log4mex.InstanceObjects;
import org.aksw.mex.log4mex.algo.AlgorithmVO;
import org.aksw.mex.log4mex.core.ExampleVO;
import org.aksw.mex.log4mex.core.PhaseVO;
import org.aksw.mex.log4mex.perf.IMeasure;
import org.aksw.mex.log4mex.perf.example.ExamplePerformanceMeasureVO;
import org.aksw.mex.log4mex.perf.overall.ClassificationMeasureVO;
import org.aksw.mex.log4mex.perf.overall.ClusteringMeasureVO;
import org.aksw.mex.log4mex.perf.overall.Measure;
import org.aksw.mex.log4mex.perf.overall.RegressionMeasureVO;
import org.aksw.mex.log4mex.perf.overall.StatisticalMeasureVO;
import org.aksw.mex.log4mex.perf.overall.UserDefinedMeasureVO;
import org.aksw.mex.util.MEXEnum;
import org.apache.commons.lang3.EnumUtils;

public abstract class Execution
extends InstanceObjects {
    protected String _id;
    protected String _targetClass;
    protected Date _startedAtTime;
    protected Date _endedAtTime;
    protected String _errorMessage;
    protected ExperimentConfigurationVO _expConf;
    protected PhaseVO _phase;
    protected AlgorithmVO _algo;
    protected List<ExampleVO> _examples;
    protected List<Measure> _performances = new ArrayList<Measure>();

    public Execution() {
        this._examples = new ArrayList<ExampleVO>();
    }

    protected String getId() {
        return this._id;
    }

    protected String getTargetClass() {
        return this._targetClass;
    }

    protected Date getStartedAtTime() {
        return this._startedAtTime;
    }

    protected Date getEndedAtTime() {
        return this._endedAtTime;
    }

    protected PhaseVO getPhase() {
        return this._phase;
    }

    protected AlgorithmVO getAlgorithm() {
        return this._algo;
    }

    private ExperimentConfigurationVO getExpConf() {
        return this._expConf;
    }

    protected List<Measure> getPerformances() {
        return this._performances;
    }

    protected List<ExampleVO> getExamples() {
        return this._examples;
    }

    protected List<Measure> getPerformances(Class<? extends IMeasure> klass) {
        ArrayList<Measure> _p = new ArrayList<Measure>();
        for (Measure item : this._performances) {
            if (!item.getClass().equals(klass)) continue;
            _p.add(item);
        }
        return _p;
    }

    protected String getErrorMessage() {
        return this._errorMessage;
    }

    public abstract void setStartsAtPosition(String var1);

    public abstract void setEndsAtPosition(String var1);

    public void setTargetClass(String _targetClass) {
        this._targetClass = _targetClass;
    }

    public void setStartDate(Date value) {
        this._startedAtTime = value;
    }

    public void setEndDate(Date value) {
        this._endedAtTime = value;
    }

    public void setAlgorithm(AlgorithmVO value) {
        this._algo = value;
    }

    public boolean setAlgorithm(String algorithmidentifier) throws Exception {
        try {
            Collection t = Collections2.filter(this.getExpConf().getAlgorithms(), p -> p instanceof AlgorithmVO && (p.getIndividualName().equals(algorithmidentifier) || p.getIdentifier().equals(algorithmidentifier)));
            if (t == null || t.size() <= 0) {
                throw new Exception("The algorithm " + algorithmidentifier + " does not belong to the experiment");
            }
            this._algo = (AlgorithmVO)Iterables.get((Iterable)t, (int)0);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return true;
    }

    public void setErrorMessage(String value) {
        this._errorMessage = value;
    }

    public boolean addPerformance(String id, String description, String formula, Double value) {
        UserDefinedMeasureVO m = new UserDefinedMeasureVO(id, description, formula, value);
        return this._performances.add(m);
    }

    public boolean addPerformance(String exampleIdentifier, String predictedValue, String realValue) {
        ExamplePerformanceMeasureVO m = new ExamplePerformanceMeasureVO(exampleIdentifier, predictedValue, realValue);
        return this._performances.add(m);
    }

    public void addPerformance(MEXEnum.EnumMeasures m, double v) throws Exception {
        String type = "";
        String p = m.toString().replace("_", "").toUpperCase();
        String paux = m.toString().replace("_", "");
        boolean ret = false;
        type = "cla";
        if (!EnumUtils.isValidEnum(MEXEnum.EnumClassificationMeasure.class, (String)p)) {
            type = "reg";
            if (!EnumUtils.isValidEnum(MEXEnum.EnumRegressionMeasure.class, (String)p)) {
                type = "sta";
                if (!EnumUtils.isValidEnum(MEXEnum.EnumStatisticalMeasure.class, (String)p)) {
                    type = "clu";
                    if (!EnumUtils.isValidEnum(MEXEnum.EnumClusteringMeasure.class, (String)p)) {
                        throw new Exception("measure has not been found: " + m.toString());
                    }
                }
            }
        }
        switch (type) {
            case "cla": {
                this.addClassificationPerformance(paux, v);
                break;
            }
            case "reg": {
                this.addRegressionPerformance(paux, v);
                break;
            }
            case "sta": {
                this.addStatisticalPerformance(paux, v);
                break;
            }
            case "clu": {
                this.addClusteringPerformance(paux, v);
                break;
            }
            default: {
                throw new Exception("measure has not been found: " + p);
            }
        }
    }

    private boolean addClassificationPerformance(String p, double value) {
        ClassificationMeasureVO m = new ClassificationMeasureVO();
        m.setValue(value);
        m.setName(p);
        return this._performances.add(m);
    }

    private boolean addRegressionPerformance(String p, double value) {
        RegressionMeasureVO m = new RegressionMeasureVO();
        m.setValue(value);
        m.setName(p);
        return this._performances.add(m);
    }

    private boolean addStatisticalPerformance(String p, double value) {
        StatisticalMeasureVO m = new StatisticalMeasureVO();
        m.setValue(value);
        m.setName(p);
        return this._performances.add(m);
    }

    private boolean addClusteringPerformance(String p, double value) {
        ClusteringMeasureVO m = new ClusteringMeasureVO();
        m.setValue(value);
        m.setName(p);
        return this._performances.add(m);
    }

    public boolean addDatasetExample(String id, String value, long datasetRow, long datasetColumn, MEXEnum.EnumExamplesType type) throws Exception {
        ExampleVO example = new ExampleVO();
        example.setId(id);
        example.setValue(value);
        example.setDatasetRow(datasetRow);
        example.setDatasetColumn(datasetColumn);
        example.setExampleType(type.toString());
        this._examples.add(example);
        return true;
    }
}

