/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.view;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import org.aksw.limes.core.gui.controller.EditClassMatchingController;
import org.aksw.limes.core.gui.model.AutomatedClassMatchingNode;
import org.aksw.limes.core.gui.model.ClassMatchingNode;
import org.aksw.limes.core.gui.util.SourceOrTarget;
import org.aksw.limes.core.gui.view.ClassMatchingTreeCell;
import org.aksw.limes.core.gui.view.IEditView;
import org.aksw.limes.core.gui.view.WizardView;

public class EditClassMatchingView
implements IEditView {
    private EditClassMatchingController controller;
    private ScrollPane rootPane;
    private final WizardView wizardView;
    private final Button switchModeButton = new Button();
    private final BooleanProperty automated = new SimpleBooleanProperty(true);
    private TreeView<ClassMatchingNode> sourceTreeView;
    private TreeView<ClassMatchingNode> targetTreeView;
    private final Label errorManualMissingClassMatchingLabel = new Label("One source and one target class must be chosen!");
    private TitledPane sourcePanelWithTitle;
    private TitledPane targetPanelWithTitle;
    private TableView<AutomatedClassMatchingNode> tableView;
    private final Label errorAutomatedMissingClassMatchingLabel = new Label("One class must be chosen!");

    EditClassMatchingView(WizardView wizardView) {
        this.wizardView = wizardView;
        this.createRootPane();
    }

    public void setController(EditClassMatchingController controller) {
        this.controller = controller;
    }

    private Parent createRootPane() {
        if (this.automated.get()) {
            this.rootPane = this.createAutomatedRootPane();
            this.rootPane.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> this.errorAutomatedMissingClassMatchingLabel.setVisible(false));
        } else {
            this.rootPane = this.createManualRootPane();
            this.rootPane.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> this.errorManualMissingClassMatchingLabel.setVisible(false));
        }
        this.switchModeButton.setOnAction(e -> {
            this.rootPane = null;
            this.automated.set(!this.automated.get());
            this.wizardView.setToRootPane((Parent)this.rootPane);
            this.controller.load(this.automated.get());
        });
        this.automated.addListener((observable, oldValue, newValue) -> {
            if (this.rootPane == null) {
                this.createRootPane();
            }
            if (!this.automated.get() && this.sourceTreeView == null) {
                this.createRootPane();
            }
        });
        this.rootPane.setFitToHeight(true);
        this.rootPane.setFitToWidth(true);
        return this.rootPane;
    }

    private ScrollPane createManualRootPane() {
        HBox hbox = new HBox();
        this.sourcePanelWithTitle = this.createClassMatchingPane(SourceOrTarget.SOURCE);
        this.sourcePanelWithTitle.setId("sourcePanel");
        HBox.setHgrow((Node)this.sourcePanelWithTitle, (Priority)Priority.ALWAYS);
        hbox.getChildren().add((Object)this.sourcePanelWithTitle);
        this.targetPanelWithTitle = this.createClassMatchingPane(SourceOrTarget.TARGET);
        this.targetPanelWithTitle.setId("targetPanel");
        HBox.setHgrow((Node)this.targetPanelWithTitle, (Priority)Priority.ALWAYS);
        hbox.getChildren().add((Object)this.targetPanelWithTitle);
        VBox vbox = new VBox();
        this.switchModeButton.setText("Automated Matching");
        this.switchModeButton.setId("switchModeButton");
        this.errorManualMissingClassMatchingLabel.setTextFill((Paint)Color.RED);
        this.errorManualMissingClassMatchingLabel.setVisible(false);
        vbox.getChildren().addAll((Object[])new Node[]{hbox, this.errorManualMissingClassMatchingLabel, this.switchModeButton});
        ScrollPane pane = new ScrollPane((Node)vbox);
        pane.setPadding(new Insets(5.0));
        return pane;
    }

    private ScrollPane createAutomatedRootPane() {
        this.tableView = this.createTableView();
        VBox vbox = new VBox();
        this.errorAutomatedMissingClassMatchingLabel.setTextFill((Paint)Color.RED);
        this.errorAutomatedMissingClassMatchingLabel.setVisible(false);
        this.switchModeButton.setText("Manual Matching");
        this.switchModeButton.setId("switchModeButton");
        vbox.getChildren().addAll((Object[])new Node[]{this.tableView, this.errorAutomatedMissingClassMatchingLabel, this.switchModeButton});
        ScrollPane pane = new ScrollPane((Node)vbox);
        pane.setPadding(new Insets(5.0));
        return pane;
    }

    private TableView<AutomatedClassMatchingNode> createTableView() {
        this.tableView = new TableView();
        this.tableView.setId("tableView");
        TableColumn sourceColumn = new TableColumn("Source classes");
        sourceColumn.setId("sourceColumn");
        TableColumn targetColumn = new TableColumn("Target classes");
        targetColumn.setId("targetColumn");
        sourceColumn.setCellValueFactory((Callback)new PropertyValueFactory("sourceName"));
        targetColumn.setCellValueFactory((Callback)new PropertyValueFactory("targetName"));
        this.tableView.getColumns().addAll((Object[])new TableColumn[]{sourceColumn, targetColumn});
        this.tableView.setEditable(false);
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        return this.tableView;
    }

    @Override
    public Parent getPane() {
        return this.rootPane;
    }

    private TitledPane createClassMatchingPane(SourceOrTarget sourceOrTarget) {
        BorderPane pane = new BorderPane();
        TreeView treeView = new TreeView();
        treeView.setCellFactory(tv -> new ClassMatchingTreeCell());
        pane.setCenter((Node)treeView);
        if (sourceOrTarget == SourceOrTarget.SOURCE) {
            this.sourceTreeView = treeView;
            this.sourceTreeView.setId("sourceTreeView");
            return new TitledPane("Source class", (Node)pane);
        }
        this.targetTreeView = treeView;
        this.targetTreeView.setId("targetTreeView");
        return new TitledPane("Target class", (Node)pane);
    }

    private void addTreeChildren(TreeItem<ClassMatchingNode> parent, List<ClassMatchingNode> childNodes, Predicate<ClassMatchingNode> shouldSelect) {
        Collections.sort(childNodes, ClassMatchingNode.CLASS_MATCHING_NODE_COMPARATOR);
        for (ClassMatchingNode childNode : childNodes) {
            TreeItem child = new TreeItem((Object)childNode);
            parent.getChildren().add((Object)child);
            this.addTreeChildren((TreeItem<ClassMatchingNode>)child, childNode.getChildren(), shouldSelect);
        }
    }

    public void showTree(SourceOrTarget sourceOrTarget, List<ClassMatchingNode> items, ClassMatchingNode currentClass) {
        TreeItem root = new TreeItem();
        this.addTreeChildren((TreeItem<ClassMatchingNode>)root, items, node -> node == currentClass);
        TreeView<ClassMatchingNode> treeView = sourceOrTarget == SourceOrTarget.SOURCE ? this.sourceTreeView : this.targetTreeView;
        treeView.setShowRoot(false);
        treeView.setRoot(root);
        if (sourceOrTarget == SourceOrTarget.SOURCE) {
            this.sourcePanelWithTitle.setText(this.controller.getConfig().getSourceInfo().getId() + " classes");
        } else {
            this.targetPanelWithTitle.setText(this.controller.getConfig().getTargetInfo().getId() + " classes");
        }
    }

    public void showTable(ObservableList<AutomatedClassMatchingNode> items) {
        Collections.sort(items, AutomatedClassMatchingNode.AUTOMATED_CLASS_MATCHING_NODE_COMPARATOR);
        this.tableView.setItems(items);
        double fixedCellSize = 30.0;
        this.tableView.setFixedCellSize(30.0);
        this.tableView.prefHeightProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tableView.getItems()).multiply(this.tableView.getFixedCellSize()).add(30.0).add(3.3333333333333335));
    }

    @Override
    public void save() {
        if (this.automated.get()) {
            this.controller.save(((AutomatedClassMatchingNode)this.tableView.getSelectionModel().getSelectedItem()).getSourceUri().toString(), ((AutomatedClassMatchingNode)this.tableView.getSelectionModel().getSelectedItem()).getTargetUri().toString());
        } else {
            TreeItem selectedSourceClass = (TreeItem)this.sourceTreeView.getSelectionModel().getSelectedItem();
            TreeItem selectedTargetClass = (TreeItem)this.targetTreeView.getSelectionModel().getSelectedItem();
            this.controller.save(selectedSourceClass == null ? null : (ClassMatchingNode)selectedSourceClass.getValue(), selectedTargetClass == null ? null : (ClassMatchingNode)selectedTargetClass.getValue());
        }
    }

    public TreeView<ClassMatchingNode> getSourceTreeView() {
        return this.sourceTreeView;
    }

    public TreeView<ClassMatchingNode> getTargetTreeView() {
        return this.targetTreeView;
    }

    public TableView<AutomatedClassMatchingNode> getTableView() {
        return this.tableView;
    }

    public Label getErrorAutomatedMissingClassMatchingLabel() {
        return this.errorAutomatedMissingClassMatchingLabel;
    }

    public Label getErrorManualMissingClassMatchingLabel() {
        return this.errorManualMissingClassMatchingLabel;
    }

    public Button getSwitchModeButton() {
        return this.switchModeButton;
    }

    @Override
    public void setAutomated(boolean automated) {
        this.automated.set(automated);
        this.switchModeButton.setVisible(automated);
    }

    @Override
    public Boolean isAutomated() {
        return this.automated.get();
    }
}

