/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.model;

import javafx.concurrent.Task;
import org.aksw.limes.core.gui.util.TaskResultSerializer;
import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.ml.algorithm.matching.DefaultPropertyMapper;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.jena.rdf.model.Model;

public class GetAutomatedPropertiesTask
extends Task<AMapping> {
    private final KBInfo sinfo;
    private final KBInfo tinfo;
    private final Model smodel;
    private final Model tmodel;
    private final String sourceClass;
    private final String targetClass;

    public GetAutomatedPropertiesTask(KBInfo sinfo, KBInfo tinfo, Model smodel, Model tmodel, String sourceClass, String targetClass) {
        this.sinfo = sinfo;
        this.tinfo = tinfo;
        this.smodel = smodel;
        this.tmodel = tmodel;
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
    }

    protected AMapping call() throws Exception {
        Object serializedResult = TaskResultSerializer.getTaskResult(this);
        AMapping result = null;
        if (serializedResult instanceof AMapping && serializedResult != null) {
            result = (AMapping)serializedResult;
            return result;
        }
        result = this.getAutomatedPropertyMatching();
        TaskResultSerializer.serializeTaskResult(this, result);
        return result;
    }

    private AMapping getAutomatedPropertyMatching() {
        if (this.isCancelled()) {
            return null;
        }
        DefaultPropertyMapper mapper = this.smodel != null && this.tmodel != null ? new DefaultPropertyMapper(this.smodel, this.tmodel) : new DefaultPropertyMapper();
        AMapping result = mapper.getPropertyMapping(this.sinfo.getEndpoint(), this.tinfo.getEndpoint(), this.sourceClass, this.targetClass);
        return result;
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 37).append((Object)this.sinfo.getEndpoint()).append((Object)this.tinfo.getEndpoint()).append((Object)this.smodel).append((Object)this.tmodel).append((Object)this.sourceClass).append((Object)this.targetClass).toHashCode();
    }
}

