/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.aksw.limes.core.gui.util.Restriction;
import org.aksw.limes.core.io.config.KBInfo;

public class AdvancedKBInfo
extends KBInfo
implements Serializable {
    public List<String> classes = new LinkedList<String>();

    public AdvancedKBInfo(KBInfo kb) {
        this.id = kb.getId();
        this.endpoint = kb.getEndpoint();
        this.graph = kb.getGraph();
        this.var = kb.getVar();
        this.properties = kb.getProperties();
        this.restrictions = kb.getRestrictions();
        this.functions = kb.getFunctions();
        this.prefixes = kb.getPrefixes();
        this.pageSize = kb.getPageSize();
        this.type = kb.getType();
    }

    public AdvancedKBInfo(String id, String endpoint, String var, String graph, List<String> properties, Collection<Restriction> restrictions, HashMap<String, String> prefixes, int pageSize) {
        this.id = id;
        this.endpoint = endpoint;
        this.var = var;
        this.graph = graph;
        this.properties = properties;
        if (restrictions != null) {
            for (Restriction restriction : restrictions) {
                String p = restriction.getProperty();
                if (p.equals("a") || p.equals("rdf:type") || p.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
                    this.classes.add(restriction.getObject().replace("<", "").replace(">", ""));
                }
                this.restrictions.add(restriction.toString(var));
            }
        }
        this.prefixes = prefixes;
        this.pageSize = pageSize;
    }

    public AdvancedKBInfo(String id, String endpoint, String var, String graph) {
        this(id, endpoint, var, graph, Collections.emptyList(), null, new HashMap<String, String>(), 1000);
    }

    public AdvancedKBInfo(String id, String endpoint, String var, String graph, String restrictionProperty, String restrictionObject) {
        this(id, endpoint, var, graph, Collections.emptyList(), Collections.singleton(new Restriction(restrictionProperty, restrictionObject)), new HashMap<String, String>(), 1000);
    }

    public static String expandPrefix(String url, Map<String, String> prefixes) {
        if (url.startsWith("http") || url.startsWith("<")) {
            return url;
        }
        for (String prefix : prefixes.keySet()) {
            if (!url.startsWith(prefix + ':')) continue;
            return '<' + url.replace(prefix + ':', prefixes.get(prefix)) + '>';
        }
        return url;
    }

    public void expandPrefixes(Map<String, String> prefixes) {
        Vector<String> newProperties = new Vector<String>();
        for (String property : this.properties) {
            newProperties.add(AdvancedKBInfo.expandPrefix(property, prefixes));
        }
        this.properties = newProperties;
        Vector<Restriction> newRestrictions = new Vector<Restriction>();
        for (String restrictionStr : this.restrictions) {
            Restriction restriction = Restriction.fromString(restrictionStr);
            String newProperty = AdvancedKBInfo.expandPrefix(restriction.getProperty(), prefixes);
            String newObject = AdvancedKBInfo.expandPrefix(restriction.getObject(), prefixes);
            newRestrictions.add(new Restriction(newProperty, newObject));
        }
        this.restrictions.clear();
        for (Restriction restriction : newRestrictions) {
            this.restrictions.add(restriction.toString(this.var));
        }
    }

    public String getRestrictionQuerySubstring() {
        StringBuffer where = new StringBuffer();
        for (int i = 0; i < this.restrictions.size(); ++i) {
            where.append((String)this.restrictions.get(i) + ".\n");
        }
        return where.toString().substring(0, where.length() - 1);
    }
}

