/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.model.metric;

import java.util.Arrays;
import java.util.LinkedList;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.metric.MetricFormatException;
import org.aksw.limes.core.gui.model.metric.Node;
import org.aksw.limes.core.gui.model.metric.Output;
import org.aksw.limes.core.gui.model.metric.Property;
import org.aksw.limes.core.gui.util.SourceOrTarget;

public class MetricParser {
    protected static String[] splitFunc(String s) {
        if (!s.contains("(")) {
            return new String[]{s};
        }
        LinkedList<String> tokenList = new LinkedList<String>();
        int i = s.indexOf("(");
        tokenList.add(s.substring(0, i));
        s = s.substring(i, s.length());
        int depth = 0;
        StringBuilder sb = new StringBuilder();
        block5: for (char c : s.toCharArray()) {
            switch (c) {
                case '(': {
                    if (depth > 0) {
                        sb.append(c);
                    }
                    ++depth;
                    continue block5;
                }
                case ')': {
                    if (depth > 1) {
                        sb.append(c);
                    }
                    --depth;
                    continue block5;
                }
                case ',': {
                    if (depth > 1) {
                        sb.append(c);
                        continue block5;
                    }
                    tokenList.add(sb.toString());
                    sb = new StringBuilder();
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        tokenList.add(sb.toString());
        return tokenList.toArray(new String[0]);
    }

    protected static String setParametersFromString(Node node, String s, int pos) {
        if (node.hasFrontParameters()) {
            int i = s.indexOf("*");
            if (i == -1) {
                return s;
            }
            Double d = Double.valueOf(s.substring(0, i));
            s = s.substring(i + 1);
            switch (pos) {
                case 0: {
                    node.param1 = d;
                    break;
                }
                case 1: {
                    node.param2 = d;
                }
            }
        } else {
            int i = s.lastIndexOf("|");
            if (i == -1 || i < s.lastIndexOf(")")) {
                return s;
            }
            Double d = Double.valueOf(s.substring(i + 1));
            s = s.substring(0, i);
            switch (pos) {
                case 0: {
                    node.param1 = d;
                    break;
                }
                case 1: {
                    node.param2 = d;
                }
            }
        }
        return s;
    }

    protected static Node parsePart(Node parent, String s, String sourceVar, int pos, Config c) throws MetricFormatException {
        String[] tokens = MetricParser.splitFunc(s);
        String id = tokens[0].trim();
        if (id.contains("*")) {
            String[] parts = id.split("\\*");
            double d = Double.parseDouble(parts[0]);
            if (parent.param1 == null) {
                parent.param1 = d;
            } else {
                parent.param2 = d;
            }
            id = parts[1];
        }
        if (tokens.length == 1) {
            SourceOrTarget origin;
            SourceOrTarget sourceOrTarget = origin = id.startsWith(sourceVar) ? SourceOrTarget.SOURCE : SourceOrTarget.TARGET;
            if (c.getSourceInfo().getOptionalProperties().contains(c.removeVar(id, origin)) || c.getTargetInfo().getOptionalProperties().contains(c.removeVar(id, origin))) {
                return new Property(id, origin, true);
            }
            return new Property(id, origin, false);
        }
        Node node = Node.createNode(id);
        s = MetricParser.setParametersFromString(parent, s, pos);
        tokens = MetricParser.splitFunc(s);
        int i = 0;
        for (String argument : Arrays.copyOfRange(tokens, 1, tokens.length)) {
            if (!node.addChild(MetricParser.parsePart(node, argument, sourceVar, i, c))) {
                throw new MetricFormatException("Could not add child \"" + argument + '\"');
            }
            ++i;
        }
        return node;
    }

    public static Output parse(String s, String sourceVar, Config c) throws MetricFormatException {
        if (s.isEmpty()) {
            throw new MetricFormatException();
        }
        Output output = new Output();
        s = MetricParser.setParametersFromString(output, s, 0);
        output.param1 = null;
        output.param2 = null;
        try {
            output.addChild(MetricParser.parsePart(output, s, sourceVar, 0, c));
        }
        catch (MetricFormatException e) {
            throw new MetricFormatException("Error parsing metric expression \"" + s + "\".", e);
        }
        return output;
    }
}

