/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.model.metric;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.aksw.limes.core.gui.model.metric.Node;
import org.aksw.limes.core.gui.model.metric.Property;
import org.aksw.limes.core.gui.util.SourceOrTarget;
import org.aksw.limes.core.measures.measure.MeasureType;

public class Measure
extends Node {
    public static final Set<Class<? extends Node>> validChildClasses = Collections.singleton(Property.class);

    public Measure(String id) {
        super(id);
    }

    @Override
    public Set<String> identifiers() {
        HashSet<String> identifiers = new HashSet<String>();
        for (int i = 0; i < MeasureType.values().length; ++i) {
            identifiers.add(MeasureType.values()[i].toString().toLowerCase());
        }
        return identifiers;
    }

    @Override
    public byte getMaxChilds() {
        return 2;
    }

    @Override
    public Set<Class<? extends Node>> validChildClasses() {
        return validChildClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acceptsChild(Node node) {
        Measure measure = this;
        synchronized (measure) {
            Node node2 = node;
            synchronized (node2) {
                return super.acceptsChild(node) && (this.getChilds().isEmpty() || ((Property)this.getChilds().iterator().next()).origin != ((Property)node).origin);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node.Acceptance acceptsChildWithReason(Node node) {
        Measure measure = this;
        synchronized (measure) {
            Node node2 = node;
            synchronized (node2) {
                Node.Acceptance acceptance = super.acceptsChildWithReason(node);
                if (acceptance != Node.Acceptance.OK) {
                    return acceptance;
                }
                if (!this.acceptsChild(node)) {
                    if (((Property)this.getChilds().iterator().next()).origin == SourceOrTarget.SOURCE) {
                        return Node.Acceptance.TARGET_PROPERTY_EXPECTED;
                    }
                    return Node.Acceptance.SOURCE_PROPERTY_EXPECTED;
                }
                return Node.Acceptance.OK;
            }
        }
    }
}

