/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.model;

import java.io.Serializable;
import java.net.URI;
import java.util.Comparator;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class AutomatedClassMatchingNode
implements Serializable {
    private static final long serialVersionUID = -2983091498542870621L;
    private final URI sourceUri;
    private final URI targetUri;
    private String sourceName;
    private String targetName;
    public static final Comparator<AutomatedClassMatchingNode> AUTOMATED_CLASS_MATCHING_NODE_COMPARATOR = (c1, c2) -> c1.sourceName.compareTo(c2.sourceName);

    public AutomatedClassMatchingNode(URI sourceUri, URI targetUri) {
        String path;
        this.sourceUri = sourceUri;
        this.targetUri = targetUri;
        String sourceFragment = sourceUri.getFragment();
        String targetFragment = targetUri.getFragment();
        if (sourceFragment != null) {
            this.sourceName = sourceFragment;
        } else {
            path = sourceUri.getPath();
            this.sourceName = path.substring(path.lastIndexOf(47) + 1);
        }
        if (targetFragment != null) {
            this.targetName = targetFragment;
        } else {
            path = targetUri.getPath();
            this.targetName = path.substring(path.lastIndexOf(47) + 1);
        }
    }

    public URI getSourceUri() {
        return this.sourceUri;
    }

    public URI getTargetUri() {
        return this.targetUri;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String toString() {
        String s = "";
        s = s + "sourceUri: " + this.sourceUri;
        s = s + "targetUri: " + this.targetUri;
        s = s + "sourceName: " + this.sourceName;
        s = s + "targetName: " + this.targetName;
        return s;
    }

    public int hashCode() {
        return new HashCodeBuilder(19, 37).append((Object)this.sourceUri).append((Object)this.targetUri).append((Object)this.sourceName).append((Object)this.targetName).toHashCode();
    }
}

