/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.controller.ml;

import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import org.aksw.limes.core.gui.controller.MainController;
import org.aksw.limes.core.gui.controller.TaskProgressController;
import org.aksw.limes.core.gui.controller.ml.MachineLearningController;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.Result;
import org.aksw.limes.core.gui.model.ml.UnsupervisedLearningModel;
import org.aksw.limes.core.gui.view.ResultView;
import org.aksw.limes.core.gui.view.TaskProgressView;
import org.aksw.limes.core.gui.view.ml.MachineLearningView;
import org.aksw.limes.core.io.cache.ACache;

public class UnsupervisedLearningController
extends MachineLearningController {
    private final MainController mainController;

    public UnsupervisedLearningController(Config config, ACache sourceCache, ACache targetCache, MainController mainController) {
        this.mainController = mainController;
        this.mlModel = new UnsupervisedLearningModel(config, sourceCache, targetCache);
    }

    @Override
    public void learn(MachineLearningView view) {
        Task<Void> learnTask = this.mlModel.createLearningTask();
        TaskProgressView taskProgressView = new TaskProgressView("Learning");
        taskProgressView.getCancelled().addListener((observable, oldValue, newValue) -> view.getLearnButton().setDisable(false));
        TaskProgressController taskProgressController = new TaskProgressController(taskProgressView, new Task[0]);
        taskProgressController.addTask(learnTask, items -> {
            view.getLearnButton().setDisable(false);
            ObservableList results = FXCollections.observableArrayList();
            this.mlModel.getLearnedMapping().getMap().forEach((sourceURI, map2) -> map2.forEach((targetURI, value) -> results.add((Object)new Result((String)sourceURI, (String)targetURI, (Double)value))));
            Platform.runLater(() -> {
                ResultView resultView = new ResultView(this.mlModel.getConfig(), this.mlModel.getLearnedLS(), this.mainController);
                resultView.showResults((ObservableList<Result>)results, this.mlModel.getLearnedMapping());
            });
            if (this.mlModel.getLearnedMapping() != null && this.mlModel.getLearnedMapping().size() > 0) {
                logger.info(this.mlModel.getConfig().getMetricExpression());
            } else {
                Platform.runLater(() -> view.showErrorDialog("Error", "Empty mapping!"));
            }
        }, error -> view.showErrorDialog("Error during learning", error.getMessage()));
    }
}

