/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.controller.ml;

import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.scene.control.Alert;
import org.aksw.limes.core.gui.controller.MainController;
import org.aksw.limes.core.gui.controller.TaskProgressController;
import org.aksw.limes.core.gui.controller.ml.MachineLearningController;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.model.Result;
import org.aksw.limes.core.gui.model.ml.BatchLearningModel;
import org.aksw.limes.core.gui.view.ResultView;
import org.aksw.limes.core.gui.view.TaskProgressView;
import org.aksw.limes.core.gui.view.ml.BatchLearningInputView;
import org.aksw.limes.core.gui.view.ml.MachineLearningView;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.reader.CSVMappingReader;
import org.aksw.limes.core.io.mapping.reader.RDFMappingReader;

public class BatchLearningController
extends MachineLearningController {
    private final MainController mainController;

    public BatchLearningController(Config config, ACache sourceCache, ACache targetCache, MainController mainController) {
        this.mainController = mainController;
        this.mlModel = new BatchLearningModel(config, sourceCache, targetCache);
    }

    private void startLearning(MachineLearningView view) {
        Task<Void> learnTask = this.mlModel.createLearningTask();
        TaskProgressView taskProgressView = new TaskProgressView("Learning");
        taskProgressView.getCancelled().addListener((observable, oldValue, newValue) -> view.getLearnButton().setDisable(false));
        TaskProgressController taskProgressController = new TaskProgressController(taskProgressView, new Task[0]);
        taskProgressController.addTask(learnTask, items -> {
            view.getLearnButton().setDisable(false);
            ObservableList results = FXCollections.observableArrayList();
            this.mlModel.getLearnedMapping().getMap().forEach((sourceURI, map2) -> map2.forEach((targetURI, value) -> results.add((Object)new Result((String)sourceURI, (String)targetURI, (Double)value))));
            Platform.runLater(() -> {
                ResultView resultView = new ResultView(this.mlModel.getConfig(), this.mlModel.getLearnedLS(), this.mainController);
                resultView.showResults((ObservableList<Result>)results, this.mlModel.getLearnedMapping());
            });
            if (this.mlModel.getLearnedMapping() != null && this.mlModel.getLearnedMapping().size() > 0) {
                logger.info(this.mlModel.getConfig().getMetricExpression());
            } else {
                Platform.runLater(() -> view.showErrorDialog("Error", "Empty mapping!"));
            }
        }, error -> view.showErrorDialog("Error during learning", error.getMessage()));
    }

    @Override
    public void learn(MachineLearningView view) {
        if (this.mlModel.getConfig().getMlTrainingDataFile() != null && !this.mlModel.getConfig().getMlTrainingDataFile().equals("")) {
            CSVMappingReader reader = null;
            if (this.mlModel.getConfig().getMlTrainingDataFile().endsWith("csv")) {
                reader = new CSVMappingReader(this.mlModel.getConfig().getMlTrainingDataFile());
            } else if (this.mlModel.getConfig().getMlTrainingDataFile().endsWith("rdf") || this.mlModel.getConfig().getMlTrainingDataFile().endsWith("ttl") || this.mlModel.getConfig().getMlTrainingDataFile().endsWith("nt") || this.mlModel.getConfig().getMlTrainingDataFile().endsWith("n3")) {
                System.err.println(this.mlModel.getConfig().getMlTrainingDataFile());
                reader = new RDFMappingReader(this.mlModel.getConfig().getMlTrainingDataFile());
            } else {
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setContentText("Unknown Mapping filetype!");
                alert.showAndWait();
            }
            AMapping trainingMapping = reader.read();
            ((BatchLearningModel)this.mlModel).setTrainingMapping(trainingMapping);
        }
        if (((BatchLearningModel)this.mlModel).getTrainingMapping() == null) {
            BatchLearningInputView bliv = new BatchLearningInputView((BatchLearningModel)this.mlModel);
            bliv.finished.addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.startLearning(this.mlView);
                }
            });
        } else {
            this.startLearning(this.mlView);
        }
    }
}

