/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.view.ml;

import java.util.ArrayList;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.aksw.limes.core.gui.model.Config;
import org.aksw.limes.core.gui.view.ToolBox;
import org.aksw.limes.core.ml.algorithm.LearningParameter;
import org.aksw.limes.core.ml.algorithm.eagle.util.PropertyMapping;

public class MLPropertyMatchingView {
    private ScrollPane rootPane;
    private ListView<String> sourcePropList;
    private ListView<String> targetPropList;
    private boolean sourcePropertyUnmatched = false;
    private boolean targetPropertyUnmatched = false;
    private Button cancelButton;
    private Button finishButton;
    private Stage stage;
    private final LearningParameter param;
    private VBox matchedPropertiesBox;
    private HBox unmatchedPropertyBox;
    private final Config config;
    private final ToolBox mainViewToolBox;

    public MLPropertyMatchingView(Config config, LearningParameter param, ToolBox tb) {
        this.config = config;
        this.param = param;
        this.mainViewToolBox = tb;
        this.createRootPane();
        this.addListeners();
    }

    private void createRootPane() {
        this.sourcePropList = new ListView();
        this.sourcePropList.setId("MLPropertyMatchingViewSourcePropList");
        this.targetPropList = new ListView();
        this.sourcePropList.setId("MLPropertyMatchingViewTargetPropList");
        if (this.mainViewToolBox.getToolBoxSourceProperties() != null) {
            for (ToolBox.PropertyItem prop : this.mainViewToolBox.getToolBoxSourceProperties().getItems()) {
                this.sourcePropList.getItems().add((Object)prop.getName());
            }
        } else {
            this.sourcePropList.getItems().addAll((Collection)this.config.getSourceInfo().getProperties());
        }
        if (this.mainViewToolBox.getToolBoxTargetProperties() != null) {
            for (ToolBox.PropertyItem prop : this.mainViewToolBox.getToolBoxTargetProperties().getItems()) {
                this.targetPropList.getItems().add((Object)prop.getName());
            }
        } else {
            this.targetPropList.getItems().addAll((Collection)this.config.getTargetInfo().getProperties());
        }
        Label sourceLabel = new Label("available Source Properties:");
        Label targetLabel = new Label("available Target Properties:");
        VBox sourceColumn = new VBox();
        VBox targetColumn = new VBox();
        sourceColumn.getChildren().addAll((Object[])new Node[]{sourceLabel, this.sourcePropList});
        targetColumn.getChildren().addAll((Object[])new Node[]{targetLabel, this.targetPropList});
        this.matchedPropertiesBox = new VBox();
        this.cancelButton = new Button("cancel");
        this.cancelButton.setTooltip(new Tooltip("cancel property matching"));
        this.finishButton = new Button("finish");
        this.finishButton.setTooltip(new Tooltip("set this property matching"));
        this.makeUnmatchedPropertyBox();
        this.finishButton.setDisable(true);
        HBox buttons = new HBox();
        buttons.getChildren().addAll((Object[])new Node[]{this.cancelButton, this.finishButton});
        BorderPane root = new BorderPane();
        HBox hb = new HBox();
        hb.getChildren().addAll((Object[])new Node[]{sourceColumn, targetColumn});
        HBox.setHgrow((Node)sourceColumn, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)targetColumn, (Priority)Priority.ALWAYS);
        VBox topBox = new VBox();
        topBox.getChildren().addAll((Object[])new Node[]{hb});
        root.setTop((Node)topBox);
        root.setCenter((Node)this.matchedPropertiesBox);
        root.setBottom((Node)buttons);
        this.rootPane = new ScrollPane((Node)root);
        this.rootPane.setFitToHeight(true);
        this.rootPane.setFitToWidth(true);
        Scene scene = new Scene((Parent)this.rootPane, 300.0, 400.0);
        scene.getStylesheets().add((Object)"gui/main.css");
        this.stage = new Stage();
        this.stage.setTitle("LIMES - Property Matching");
        this.stage.setScene(scene);
        this.stage.show();
    }

    private void addListeners() {
        this.cancelButton.setOnAction(e -> this.stage.close());
        this.finishButton.setOnAction(e -> {
            if (!this.sourcePropertyUnmatched && !this.targetPropertyUnmatched) {
                PropertyMapping propMap = new PropertyMapping();
                block12: for (int i = 0; i < this.matchedPropertiesBox.getChildren().size() - 1; ++i) {
                    String type;
                    HBox row = (HBox)this.matchedPropertiesBox.getChildren().get(i);
                    String sourceProp = ((Label)((VBox)row.getChildren().get(0)).getChildren().get(0)).getText();
                    String targetProp = ((Label)((VBox)row.getChildren().get(1)).getChildren().get(0)).getText();
                    switch (type = (String)((Spinner)((HBox)row.getChildren().get(2)).getChildren().get(0)).getValue()) {
                        case "String": {
                            propMap.addStringPropertyMatch(sourceProp, targetProp);
                            continue block12;
                        }
                        case "Number": {
                            propMap.addNumberPropertyMatch(sourceProp, targetProp);
                            continue block12;
                        }
                        case "Date": {
                            propMap.addDatePropertyMatch(sourceProp, targetProp);
                            continue block12;
                        }
                        case "Pointset": {
                            propMap.addPointsetPropertyMatch(sourceProp, targetProp);
                        }
                    }
                }
                this.param.setValue((Object)propMap);
                this.config.propertyMapping = propMap;
                this.stage.close();
            }
        });
        this.sourcePropList.setOnMouseClicked(e -> {
            if (this.sourcePropList.getSelectionModel().getSelectedItem() != null && (this.sourcePropertyUnmatched || !this.sourcePropertyUnmatched && !this.targetPropertyUnmatched)) {
                Label sourceProp = new Label((String)this.sourcePropList.getSelectionModel().getSelectedItem());
                sourceProp.setAlignment(Pos.BASELINE_LEFT);
                ((VBox)this.unmatchedPropertyBox.getChildren().get(0)).getChildren().add((Object)sourceProp);
                this.sourcePropList.getItems().remove(this.sourcePropList.getSelectionModel().getSelectedItem());
                if (this.unmatchedPropertyBox.getChildren().size() < 3) {
                    this.addSpinnerAndButton();
                }
                if (this.sourcePropertyUnmatched) {
                    this.sourcePropertyUnmatched = false;
                    this.makeUnmatchedPropertyBox();
                } else {
                    this.finishButton.setDisable(true);
                    this.targetPropertyUnmatched = true;
                }
            }
        });
        this.targetPropList.setOnMouseClicked(e -> {
            if (this.targetPropList.getSelectionModel().getSelectedItem() != null && (this.targetPropertyUnmatched || !this.sourcePropertyUnmatched && !this.targetPropertyUnmatched)) {
                Label targetProp = new Label((String)this.targetPropList.getSelectionModel().getSelectedItem());
                targetProp.setAlignment(Pos.BASELINE_LEFT);
                ((VBox)this.unmatchedPropertyBox.getChildren().get(1)).getChildren().add((Object)targetProp);
                this.targetPropList.getItems().remove(this.targetPropList.getSelectionModel().getSelectedItem());
                if (this.unmatchedPropertyBox.getChildren().size() < 3) {
                    this.addSpinnerAndButton();
                }
                if (this.targetPropertyUnmatched) {
                    this.targetPropertyUnmatched = false;
                    this.makeUnmatchedPropertyBox();
                } else {
                    this.finishButton.setDisable(true);
                    this.sourcePropertyUnmatched = true;
                }
            }
        });
    }

    private void addSpinnerAndButton() {
        ArrayList<String> propertyTypeList = new ArrayList<String>();
        propertyTypeList.add("String");
        propertyTypeList.add("Number");
        propertyTypeList.add("Date");
        propertyTypeList.add("Pointset");
        ObservableList obsPropTypeList = FXCollections.observableList(propertyTypeList);
        SpinnerValueFactory.ListSpinnerValueFactory svf = new SpinnerValueFactory.ListSpinnerValueFactory(obsPropTypeList);
        Spinner propertyTypeSpinner = new Spinner();
        propertyTypeSpinner.setValueFactory((SpinnerValueFactory)svf);
        Button deleteRowButton = new Button("x");
        HBox spinnerAndButtonBox = new HBox();
        spinnerAndButtonBox.setAlignment(Pos.CENTER_RIGHT);
        HBox.setHgrow((Node)spinnerAndButtonBox, (Priority)Priority.ALWAYS);
        spinnerAndButtonBox.getChildren().addAll((Object[])new Node[]{propertyTypeSpinner, deleteRowButton});
        this.unmatchedPropertyBox.getChildren().add((Object)spinnerAndButtonBox);
        this.unmatchedPropertyBox.setAlignment(Pos.CENTER_LEFT);
        this.unmatchedPropertyBox.setPrefWidth(this.stage.getWidth());
        deleteRowButton.setOnAction(e_ -> {
            HBox column = (HBox)deleteRowButton.getParent();
            String matchedSource = ((Label)((VBox)column.getChildren().get(0)).getChildren().get(0)).getText();
            String matchedTarget = ((Label)((VBox)column.getChildren().get(1)).getChildren().get(0)).getText();
            if (matchedSource != null) {
                this.sourcePropList.getItems().add((Object)matchedSource);
            }
            if (matchedTarget != null) {
                this.targetPropList.getItems().add((Object)matchedTarget);
            }
            VBox row = (VBox)deleteRowButton.getParent().getParent();
            row.getChildren().remove((Object)deleteRowButton.getParent());
        });
    }

    private void makeUnmatchedPropertyBox() {
        this.finishButton.setDisable(false);
        this.sourcePropertyUnmatched = false;
        this.unmatchedPropertyBox = new HBox();
        this.unmatchedPropertyBox.setSpacing(20.0);
        VBox unmatchedProp1 = new VBox();
        VBox unmatchedProp2 = new VBox();
        this.unmatchedPropertyBox.getChildren().addAll((Object[])new Node[]{unmatchedProp1, unmatchedProp2});
        this.matchedPropertiesBox.getChildren().add((Object)this.unmatchedPropertyBox);
    }
}

