/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.view.graphBuilder;

import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.aksw.limes.core.gui.view.graphBuilder.GraphBuildView;
import org.aksw.limes.core.gui.view.graphBuilder.NodeView;

public class ThresholdModifyView {
    private Label acceptanceThresholdlabel = null;
    private TextField acceptanceThresholdinput = null;

    public ThresholdModifyView(GraphBuildView gbv, NodeView node) {
        Stage stage = new Stage();
        VBox root = new VBox();
        HBox verThresh = new HBox(25.0);
        HBox accThresh = new HBox(23.0);
        HBox buttons = new HBox(100.0);
        String verThreshLabeltext = "";
        String accThreshLabeltext = "";
        if (node.nodeShape == 3) {
            verThreshLabeltext = node.nodeData.getChilds().size() > 0 ? node.nodeData.getChilds().get((int)0).id + " threshold: " : "parent 1 threshold: ";
            accThreshLabeltext = node.nodeData.getChilds().size() > 1 ? node.nodeData.getChilds().get((int)1).id + " threshold: " : "parent 2 threshold: ";
        } else {
            verThreshLabeltext = "Verification threshold: ";
            accThreshLabeltext = "Acceptance threshold: ";
        }
        int index = gbv.nodeList.indexOf(node);
        Label verificationThresholdlabel = new Label(verThreshLabeltext);
        TextField verificationThresholdinput = new TextField();
        verificationThresholdinput.setPromptText("value between 0 and 1");
        verThresh.getChildren().addAll((Object[])new Node[]{verificationThresholdlabel, verificationThresholdinput});
        if (node.nodeShape != 3 || node.nodeData.getChilds().size() != 1) {
            this.acceptanceThresholdlabel = new Label(accThreshLabeltext);
            this.acceptanceThresholdinput = new TextField();
            this.acceptanceThresholdinput.setPromptText("value between 0 and 1");
            accThresh.getChildren().addAll((Object[])new Node[]{this.acceptanceThresholdlabel, this.acceptanceThresholdinput});
        }
        Button save = new Button("Save");
        save.setOnAction(e -> {
            if (node.nodeShape == 3 && node.nodeData.getChilds().size() == 1) {
                if (verificationThresholdinput.getText() != null && !verificationThresholdinput.getText().isEmpty()) {
                    try {
                        String acc1 = verificationThresholdinput.getText().replaceAll(",", ".");
                        gbv.nodeList.get((int)index).nodeData.param1 = Double.parseDouble(acc1);
                    }
                    catch (NumberFormatException exc1) {
                        Alert alert1 = new Alert(Alert.AlertType.INFORMATION);
                        alert1.setContentText("Value is not legitimate!");
                        alert1.showAndWait();
                    }
                } else {
                    Alert alert2 = new Alert(Alert.AlertType.INFORMATION);
                    alert2.setContentText("You have not entered a value!");
                    alert2.showAndWait();
                }
                if (gbv.nodeList.get((int)index).nodeData.param1 != null) {
                    stage.close();
                    gbv.draw();
                }
            } else {
                if (this.acceptanceThresholdinput.getText() != null && !this.acceptanceThresholdinput.getText().isEmpty() && verificationThresholdinput.getText() != null && !verificationThresholdinput.getText().isEmpty()) {
                    try {
                        String acc2 = this.acceptanceThresholdinput.getText().replaceAll(",", ".");
                        gbv.nodeList.get((int)index).nodeData.param1 = Double.parseDouble(acc2);
                        String ver = verificationThresholdinput.getText().replaceAll(",", ".");
                        gbv.nodeList.get((int)index).nodeData.param2 = Double.parseDouble(ver);
                    }
                    catch (NumberFormatException exc2) {
                        Alert alert3 = new Alert(Alert.AlertType.INFORMATION);
                        alert3.setContentText("Values are not legitimate!");
                        alert3.showAndWait();
                    }
                } else {
                    Alert alert4 = new Alert(Alert.AlertType.INFORMATION);
                    alert4.setContentText("Entered values are incomplete!");
                    alert4.showAndWait();
                }
                if (gbv.nodeList.get((int)index).nodeData.param1 != null && gbv.nodeList.get((int)index).nodeData.param2 != null) {
                    stage.close();
                    gbv.draw();
                }
            }
        });
        Button cancel = new Button("Cancel");
        cancel.setOnAction(e -> stage.close());
        buttons.getChildren().addAll((Object[])new Node[]{save, cancel});
        buttons.setPadding(new Insets(5.0, 50.0, 1.0, 50.0));
        buttons.setSpacing(120.0);
        if (node.nodeShape != 3 || node.nodeData.getChilds().size() != 1) {
            root.getChildren().addAll((Object[])new Node[]{verThresh, accThresh, buttons});
        } else {
            root.getChildren().addAll((Object[])new Node[]{verThresh, buttons});
        }
        root.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Scene scene = new Scene((Parent)root, 450.0, 130.0);
        scene.getStylesheets().add((Object)"gui/main.css");
        stage.setMinHeight(scene.getHeight());
        stage.setMinWidth(scene.getWidth());
        stage.setResizable(false);
        stage.setScene(scene);
        stage.show();
    }
}

