/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.gui.view;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import org.aksw.limes.core.gui.controller.TaskProgressController;

public class TaskProgressView {
    private Stage stage;
    private TaskProgressController controller;
    private StringProperty informationLabel;
    private ProgressBar progressBar;
    private final BooleanProperty finishedSuccessfully = new SimpleBooleanProperty(false);
    private final BooleanProperty cancelled = new SimpleBooleanProperty(false);

    public TaskProgressView(String title) {
        this.showWindow(title);
    }

    public void setController(TaskProgressController controller) {
        this.controller = controller;
    }

    private void showWindow(String title) {
        BorderPane mainPane = new BorderPane();
        Label label = new Label(title);
        Label information = new Label("");
        this.informationLabel = new SimpleStringProperty(" ");
        information.textProperty().bind((ObservableValue)this.informationLabel);
        this.progressBar = new ProgressBar();
        HBox hb = new HBox();
        hb.setSpacing(5.0);
        hb.setAlignment(Pos.CENTER);
        hb.getChildren().addAll((Object[])new Node[]{label, this.progressBar});
        VBox vb = new VBox();
        vb.getChildren().addAll((Object[])new Node[]{hb, information});
        vb.setAlignment(Pos.CENTER);
        mainPane.setTop((Node)vb);
        Button cancelButton = new Button("Cancel");
        HBox hb2 = new HBox();
        hb2.setSpacing(5.0);
        hb2.setAlignment(Pos.CENTER);
        hb2.getChildren().addAll((Object[])new Node[]{cancelButton});
        mainPane.setBottom((Node)hb2);
        cancelButton.setOnAction(event -> this.controller.cancel());
        Scene scene = new Scene((Parent)mainPane, 250.0, 100.0, (Paint)Color.WHITE);
        scene.getStylesheets().add((Object)"gui/main.css");
        this.stage = new Stage();
        this.stage.setMinHeight(scene.getHeight());
        this.stage.setMinWidth(scene.getWidth());
        this.stage.setAlwaysOnTop(true);
        this.stage.setTitle(title);
        this.stage.setScene(scene);
        this.stage.show();
    }

    public void close() {
        this.stage.close();
    }

    public StringProperty getInformationLabel() {
        return this.informationLabel;
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public BooleanProperty getFinishedSuccessfully() {
        return this.finishedSuccessfully;
    }

    public void setFinishedSuccessfully(boolean finishedSuccessfully) {
        this.finishedSuccessfully.set(finishedSuccessfully);
    }

    public BooleanProperty getCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled.set(cancelled);
    }
}

